/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler;

import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.LibrarySource;
import com.google.dart.compiler.SystemLibraryManager;
import com.google.dart.compiler.UrlSource;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class UrlDartSource
extends UrlSource
implements DartSource {
    private final LibrarySource lib;
    private final String relPath;

    protected UrlDartSource(URI uri, String relPath, LibrarySource lib, SystemLibraryManager slm) {
        super(uri, slm);
        this.relPath = relPath;
        this.lib = lib;
    }

    protected UrlDartSource(URI uri, String relPath, LibrarySource lib) {
        this(uri, relPath, lib, null);
    }

    public UrlDartSource(File file, LibrarySource lib) {
        super(file);
        this.relPath = file.getPath();
        this.lib = lib;
    }

    @Override
    public LibrarySource getLibrary() {
        return this.lib;
    }

    @Override
    public String getName() {
        try {
            String uriSafeName = new URI(null, null, this.relPath, null).toString();
            return this.lib.getName() + "/" + uriSafeName;
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public String getRelativePath() {
        return this.relPath;
    }
}

