/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class SystemLibrary {
    private final String shortName;
    private final String host;
    private final String pathToLib;
    private final File dirOrZip;

    public SystemLibrary(String shortName, String host, String pathToLib, File dirOrZip) {
        this.shortName = shortName;
        this.host = host;
        this.pathToLib = pathToLib;
        this.dirOrZip = dirOrZip;
    }

    public String getHost() {
        return this.host;
    }

    public String getPathToLib() {
        return this.pathToLib;
    }

    public String getShortName() {
        return this.shortName;
    }

    public URI translateUri(URI dartUri) {
        if (!this.dirOrZip.exists()) {
            throw new RuntimeException("System library for " + dartUri + " does not exist: " + this.dirOrZip.getPath());
        }
        try {
            URI dirOrZipURI = this.dirOrZip.toURI();
            if (this.dirOrZip.isFile()) {
                return new URI("jar", "file:" + dirOrZipURI.getPath() + "!" + dartUri.getPath(), null);
            }
            return dirOrZipURI.resolve("." + dartUri.getPath());
        }
        catch (URISyntaxException e) {
            throw new AssertionError();
        }
    }

    public File getFile() {
        return this.dirOrZip;
    }
}

