/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler;

import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.Source;
import com.google.dart.compiler.ast.DartUnit;

public abstract class SourceDelta {
    public abstract Source getSourceBefore();

    public abstract DartSource getSourceAfter();

    public abstract DartUnit getUnitAfter();

    public final SourceDelta after(DartSource sourceAfter) {
        return new BeforeAfter(this.getSourceBefore(), sourceAfter, null);
    }

    public final SourceDelta after(DartUnit nodeAfter) {
        return new BeforeAfter(this.getSourceBefore(), null, nodeAfter);
    }

    public static SourceDelta before(DartSource sourceBefore) {
        return new BeforeAfter(sourceBefore, sourceBefore, null);
    }

    private static class BeforeAfter
    extends SourceDelta {
        private final Source sourceBefore;
        private final DartSource sourceAfter;
        private final DartUnit nodeAfter;

        BeforeAfter(Source sourceBefore, DartSource sourceAfter, DartUnit nodeAfter) {
            this.sourceBefore = sourceBefore;
            this.sourceAfter = sourceAfter;
            this.nodeAfter = nodeAfter;
        }

        @Override
        public Source getSourceBefore() {
            return this.sourceBefore;
        }

        @Override
        public DartSource getSourceAfter() {
            return this.sourceAfter;
        }

        @Override
        public DartUnit getUnitAfter() {
            return this.nodeAfter;
        }
    }
}

