/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler;

import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.dart.compiler.CompilerConfiguration;
import com.google.dart.compiler.DartCompilationError;
import com.google.dart.compiler.DartCompilerContext;
import com.google.dart.compiler.DartCompilerListener;
import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.LibrarySource;
import com.google.dart.compiler.Source;
import com.google.dart.compiler.SourceDelta;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.LibraryUnit;
import com.google.dart.compiler.metrics.CompilerMetrics;
import com.google.dart.compiler.parser.DartParser;
import com.google.dart.compiler.parser.DartScannerParserContext;
import com.google.dart.compiler.parser.ParserContext;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import com.google.dart.compiler.resolver.CoreTypeProviderImplementation;
import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.LibraryElement;
import com.google.dart.compiler.resolver.MemberBuilder;
import com.google.dart.compiler.resolver.Resolver;
import com.google.dart.compiler.resolver.Scope;
import com.google.dart.compiler.resolver.SupertypeResolver;
import com.google.dart.compiler.resolver.TopLevelElementBuilder;
import com.google.dart.compiler.type.TypeAnalyzer;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;

class DeltaAnalyzer {
    private final SourceDelta delta;
    private final LibraryElement enclosingLibrary;
    private final CompilerConfiguration config;
    private final DartCompilerListener listener;
    private final CoreTypeProvider typeProvider;
    private final DartCompilerContext context;

    public DeltaAnalyzer(SourceDelta delta, LibraryElement enclosingLibrary, LibraryElement coreLibrary, DartNode interestNode, int interestStart, int interestLength, CompilerConfiguration config, DartCompilerListener listener) {
        this.delta = delta;
        this.enclosingLibrary = enclosingLibrary;
        this.config = config;
        this.listener = listener;
        this.typeProvider = new CoreTypeProviderImplementation(coreLibrary.getScope(), listener);
        this.context = new Context();
    }

    public DartNode analyze() throws IOException {
        Source originalSource = this.delta.getSourceBefore();
        DartUnit unit = this.delta.getUnitAfter();
        if (unit == null) {
            DartSource source = this.delta.getSourceAfter();
            unit = this.getParser(source).parseUnit(source);
        }
        Scope scope = this.deltaLibraryScope(originalSource, unit);
        new SupertypeResolver().exec(unit, this.context, this.typeProvider);
        new MemberBuilder().exec(unit, this.context, this.typeProvider);
        new Resolver(this.context, scope, this.typeProvider).exec(unit);
        new TypeAnalyzer().exec(unit, this.context, this.typeProvider);
        return unit;
    }

    private Scope deltaLibraryScope(Source originalSource, DartUnit unit) {
        LibraryUnit libraryUnit = new LibraryUnit(this.makeLibrarySource("delta"));
        libraryUnit.putUnit(unit);
        libraryUnit.populateTopLevelNodes();
        new TopLevelElementBuilder().exec(libraryUnit, this.context);
        new TopLevelElementBuilder().fillInLibraryScope(libraryUnit, this.listener);
        Scope scope = libraryUnit.getElement().getScope();
        for (Element member : this.enclosingLibrary.getMembers()) {
            if (member.getNode() == null || member.getNode().getSource() == originalSource) continue;
            scope.declareElement(member.getName(), member);
        }
        return scope;
    }

    private LibrarySource makeLibrarySource(final String name) {
        final URI uri = URI.create(name);
        return new LibrarySource(){

            @Override
            public URI getUri() {
                return uri;
            }

            @Override
            public Reader getSourceReader() {
                throw new AssertionError();
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public long getLastModified() {
                throw new AssertionError();
            }

            @Override
            public boolean exists() {
                throw new AssertionError();
            }

            @Override
            public DartSource getSourceFor(String relPath) {
                throw new AssertionError();
            }

            @Override
            public LibrarySource getImportFor(String relPath) {
                throw new AssertionError();
            }
        };
    }

    private DartParser getParser(Source source) throws IOException {
        Reader r = source.getSourceReader();
        String sourceString = CharStreams.toString((Readable)r);
        Closeables.close((Closeable)r, (boolean)false);
        return new DartParser((ParserContext)new DartScannerParserContext(source, sourceString, this.listener), false);
    }

    private class Context
    implements DartCompilerListener,
    DartCompilerContext {
        private Context() {
        }

        @Override
        public LibraryUnit getApplicationUnit() {
            throw new AssertionError();
        }

        @Override
        public LibraryUnit getAppLibraryUnit() {
            throw new AssertionError();
        }

        @Override
        public LibraryUnit getLibraryUnit(LibrarySource lib) {
            throw new AssertionError();
        }

        @Override
        public Reader getArtifactReader(Source source, String part, String extension) {
            throw new AssertionError();
        }

        @Override
        public URI getArtifactUri(DartSource source, String part, String extension) {
            throw new AssertionError();
        }

        @Override
        public Writer getArtifactWriter(Source source, String part, String extension) {
            throw new AssertionError();
        }

        @Override
        public boolean isOutOfDate(Source source, Source base, String extension) {
            throw new AssertionError();
        }

        @Override
        public CompilerMetrics getCompilerMetrics() {
            return null;
        }

        @Override
        public boolean shouldWarnOnNoSuchType() {
            return false;
        }

        @Override
        public CompilerConfiguration getCompilerConfiguration() {
            return DeltaAnalyzer.this.config;
        }

        @Override
        public LibrarySource getSystemLibraryFor(String importSpec) {
            throw new AssertionError();
        }

        @Override
        public void onError(DartCompilationError event) {
            DeltaAnalyzer.this.listener.onError(event);
        }

        @Override
        public void unitAboutToCompile(DartSource source, boolean diet) {
        }

        @Override
        public void unitCompiled(DartUnit unit) {
        }
    }
}

