/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler;

import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.LibrarySource;
import com.google.dart.compiler.UrlDartSource;
import com.google.dart.compiler.UrlLibrarySource;
import com.google.dart.compiler.UrlSource;
import com.google.dart.compiler.util.DartSourceString;
import com.google.dart.compiler.util.Lists;
import com.google.dart.compiler.util.Paths;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultLibrarySource
extends UrlSource
implements LibrarySource {
    private static final String WRAPPED_NAME_PREFIX = "_DefaultLibrarySource.wrapper.";
    private final File sourceFile;
    private final Map<String, DartSource> sources;
    private final Map<String, LibrarySource> imports;
    private String source;
    private String wrappedName;

    public DefaultLibrarySource(List<String> sources, String entryPoint) {
        this(sources.get(0), Paths.toFiles(sources), entryPoint);
    }

    public DefaultLibrarySource(List<String> sources, List<String> imports, String entryPoint) {
        this(sources.get(0), Paths.toFiles(sources), Paths.toFiles(imports), entryPoint);
    }

    public DefaultLibrarySource(File sourceFile, String entryPoint) {
        this(sourceFile.getName(), Lists.create(sourceFile), Lists.create(), entryPoint);
    }

    public DefaultLibrarySource(String appName, List<File> sourceFiles, String entryPoint) {
        this(appName, sourceFiles, Lists.create(), entryPoint);
    }

    public DefaultLibrarySource(String appName, List<File> sourceFiles, List<File> importFiles, String entryPoint) {
        this(sourceFiles.get(0));
        String relPath;
        for (File file : sourceFiles) {
            relPath = Paths.relativePathFor(this.sourceFile, file);
            this.sources.put(relPath, new UrlDartSource(file, this));
        }
        for (File file : importFiles) {
            relPath = Paths.relativePathFor(this.sourceFile, file);
            this.imports.put(relPath, new UrlLibrarySource(file));
        }
        this.wrappedName = WRAPPED_NAME_PREFIX + appName;
        this.source = DefaultLibrarySource.generateSource(this.wrappedName, this.sourceFile, importFiles, sourceFiles, entryPoint);
        this.sources.put(this.wrappedName, new DartSourceString(this.wrappedName, this.source));
    }

    private DefaultLibrarySource(File sourceFile) {
        super(sourceFile);
        this.sourceFile = sourceFile;
        this.sources = new HashMap<String, DartSource>();
        this.imports = new HashMap<String, LibrarySource>();
    }

    public static String generateSource(String name, List<String> imports, List<String> sources, String entryPoint) {
        return DefaultLibrarySource.generateSource(name, new File(name), Paths.toFiles(imports), Paths.toFiles(sources), entryPoint);
    }

    public static String generateSource(String name, File baseFile, List<File> importFiles, List<File> sourceFiles, String entryPoint) {
        String relPath;
        StringWriter sw = new StringWriter(200);
        PrintWriter pw = new PrintWriter(sw);
        pw.println("#library(\"" + name + "\");");
        if (importFiles != null) {
            for (File file : importFiles) {
                relPath = file.getPath();
                if (!relPath.startsWith("dart:")) {
                    relPath = Paths.relativePathFor(baseFile, file);
                }
                if (relPath == null) continue;
                pw.println("#import(\"" + relPath + "\");");
            }
        }
        if (sourceFiles != null) {
            for (File file : sourceFiles) {
                relPath = Paths.relativePathFor(baseFile, file);
                if (relPath == null) continue;
                pw.println("#source(\"" + relPath + "\");");
            }
        }
        if (entryPoint != null) {
            pw.println();
            pw.println("main() {");
            pw.println("  " + entryPoint + "();");
            pw.println("}");
        }
        return sw.toString();
    }

    @Override
    public Reader getSourceReader() {
        return new StringReader(this.source);
    }

    @Override
    public URI getUri() {
        try {
            return new URI("string://" + this.wrappedName);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public String getName() {
        return this.wrappedName;
    }

    @Override
    public LibrarySource getImportFor(String relPath) {
        return this.imports.get(relPath);
    }

    @Override
    public DartSource getSourceFor(String relPath) {
        return this.sources.get(relPath);
    }
}

