/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler;

import com.google.dart.compiler.CompilerConfiguration;
import com.google.dart.compiler.DartCompilationError;
import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.ErrorFormatter;
import com.google.dart.compiler.LibrarySource;
import com.google.dart.compiler.Source;
import java.io.PrintStream;

public class DefaultErrorFormatter
implements ErrorFormatter {
    protected final PrintStream outputStream;
    protected final CompilerConfiguration.ErrorFormat errorFormat;

    public DefaultErrorFormatter(PrintStream outputStream, CompilerConfiguration.ErrorFormat errorFormat) {
        this.outputStream = outputStream;
        this.errorFormat = errorFormat;
    }

    @Override
    public void format(DartCompilationError event) {
        String sourceName = "<unknown-source-file>";
        Source sourceFile = event.getSource();
        String includeFrom = this.getImportString(sourceFile);
        if (sourceFile != null) {
            sourceName = sourceFile.getUri().toString();
        }
        this.outputStream.printf("%s:%d:%d: %s%s\n", sourceName, event.getLineNumber(), event.getColumnNumber(), event.getMessage(), includeFrom);
    }

    public String getImportString(Source sourceFile) {
        String includeFrom = "";
        if (sourceFile instanceof DartSource) {
            LibrarySource lib = ((DartSource)sourceFile).getLibrary();
            if (!sourceFile.getUri().equals(lib.getUri())) {
                includeFrom = " (sourced from " + lib.getUri() + ")";
            }
        }
        return includeFrom;
    }
}

