/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler;

import com.google.dart.compiler.CompilerConfiguration;
import com.google.dart.compiler.DartCompilationError;
import com.google.dart.compiler.DartCompilerListener;
import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.ErrorFormatter;
import com.google.dart.compiler.ErrorSeverity;
import com.google.dart.compiler.PrettyErrorFormatter;
import com.google.dart.compiler.SubSystem;
import com.google.dart.compiler.ast.DartUnit;
import java.io.PrintStream;

public class DefaultDartCompilerListener
implements DartCompilerListener {
    private int errorCount = 0;
    private int warningCount = 0;
    private int typeErrorCount = 0;
    protected final ErrorFormatter formatter;

    public DefaultDartCompilerListener(CompilerConfiguration.ErrorFormat errorFormat) {
        this(System.err, errorFormat);
    }

    public DefaultDartCompilerListener(PrintStream outputStream, CompilerConfiguration.ErrorFormat errorFormat) {
        this.formatter = new PrettyErrorFormatter(outputStream, this.useColor(), errorFormat);
    }

    private boolean useColor() {
        return String.valueOf(System.getenv("TERM")).startsWith("xterm") && System.console() != null;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getTypeErrorCount() {
        return this.typeErrorCount;
    }

    protected void incrementErrorCount() {
        ++this.errorCount;
    }

    protected void incrementWarningCount() {
        ++this.warningCount;
    }

    protected void incrementTypeErrorCount() {
        ++this.typeErrorCount;
    }

    @Override
    public void onError(DartCompilationError event) {
        this.formatter.format(event);
        if (event.getErrorCode().getSubSystem() == SubSystem.STATIC_TYPE) {
            this.incrementTypeErrorCount();
        } else if (event.getErrorCode().getErrorSeverity() == ErrorSeverity.ERROR) {
            this.incrementErrorCount();
        } else if (event.getErrorCode().getErrorSeverity() == ErrorSeverity.WARNING) {
            this.incrementWarningCount();
        }
    }

    @Override
    public void unitAboutToCompile(DartSource source, boolean diet) {
    }

    @Override
    public void unitCompiled(DartUnit unit) {
    }
}

