/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler;

import com.google.dart.compiler.CompilerConfiguration;
import com.google.dart.compiler.DartArtifactProvider;
import com.google.dart.compiler.DartCompilationError;
import com.google.dart.compiler.DartCompilerContext;
import com.google.dart.compiler.DartCompilerErrorCode;
import com.google.dart.compiler.DartCompilerListener;
import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.ErrorCode;
import com.google.dart.compiler.ErrorSeverity;
import com.google.dart.compiler.LibrarySource;
import com.google.dart.compiler.Source;
import com.google.dart.compiler.SubSystem;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.LibraryUnit;
import com.google.dart.compiler.metrics.CompilerMetrics;
import com.google.dart.compiler.parser.DartParser;
import com.google.dart.compiler.resolver.ResolverErrorCode;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

final class DartCompilerMainContext
implements DartCompilerListener,
DartCompilerContext {
    private final LibrarySource lib;
    private final DartArtifactProvider provider;
    private final DartCompilerListener listener;
    private final AtomicInteger errorCount = new AtomicInteger(0);
    private final AtomicInteger warningCount = new AtomicInteger(0);
    private final AtomicInteger typeErrorCount = new AtomicInteger(0);
    private final AtomicBoolean filesHaveChanged = new AtomicBoolean();
    private volatile LibraryUnit appLibraryUnit = null;
    private final CompilerConfiguration compilerConfiguration;

    DartCompilerMainContext(LibrarySource lib, DartArtifactProvider provider, DartCompilerListener listener, CompilerConfiguration compilerConfiguration) {
        this.lib = lib;
        this.provider = provider;
        this.listener = listener;
        this.compilerConfiguration = compilerConfiguration;
    }

    @Override
    public void onError(DartCompilationError event) {
        if (event.getErrorCode().getSubSystem() == SubSystem.STATIC_TYPE) {
            this.incrementTypeErrorCount();
        } else if (this.shouldWarnOnNoSuchType() && event.getErrorCode() == ResolverErrorCode.NO_SUCH_TYPE) {
            this.incrementTypeErrorCount();
        } else if (event.getErrorCode().getErrorSeverity() == ErrorSeverity.ERROR) {
            this.incrementErrorCount();
        } else if (event.getErrorCode().getErrorSeverity() == ErrorSeverity.WARNING) {
            this.incrementWarningCount();
        }
        this.listener.onError(event);
    }

    @Override
    public LibraryUnit getApplicationUnit() {
        return this.getAppLibraryUnit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LibraryUnit getAppLibraryUnit() {
        if (this.appLibraryUnit == null) {
            DartCompilerMainContext dartCompilerMainContext = this;
            synchronized (dartCompilerMainContext) {
                if (this.appLibraryUnit == null) {
                    try {
                        this.appLibraryUnit = DartParser.getSourceParser(this.lib, this.listener).preProcessLibraryDirectives(this.lib);
                    }
                    catch (IOException e) {
                        this.onError(new DartCompilationError((Source)this.lib, (ErrorCode)DartCompilerErrorCode.IO, e.getMessage()));
                        return null;
                    }
                }
            }
        }
        return this.appLibraryUnit;
    }

    @Override
    public Reader getArtifactReader(Source source, String part, String extension) throws IOException {
        return this.provider.getArtifactReader(source, part, extension);
    }

    @Override
    public URI getArtifactUri(DartSource source, String part, String extension) {
        return this.provider.getArtifactUri(source, part, extension);
    }

    @Override
    public Writer getArtifactWriter(Source source, String part, String extension) throws IOException {
        return this.provider.getArtifactWriter(source, part, extension);
    }

    public int getErrorCount() {
        return this.errorCount.get();
    }

    public int getWarningCount() {
        return this.warningCount.get();
    }

    public int getTypeErrorCount() {
        return this.typeErrorCount.get();
    }

    @Override
    public LibraryUnit getLibraryUnit(LibrarySource libSrc) {
        if (libSrc == this.lib) {
            return this.getApplicationUnit();
        }
        try {
            return DartParser.getSourceParser(libSrc, this.listener).preProcessLibraryDirectives(libSrc);
        }
        catch (IOException e) {
            this.onError(new DartCompilationError((Source)libSrc, (ErrorCode)DartCompilerErrorCode.IO, e.getMessage()));
            return null;
        }
    }

    @Override
    public boolean isOutOfDate(Source source, Source base, String extension) {
        return this.provider.isOutOfDate(source, base, extension);
    }

    protected void incrementErrorCount() {
        this.errorCount.incrementAndGet();
    }

    protected void incrementWarningCount() {
        this.warningCount.incrementAndGet();
    }

    protected void incrementTypeErrorCount() {
        this.typeErrorCount.incrementAndGet();
    }

    @Override
    public CompilerMetrics getCompilerMetrics() {
        return this.compilerConfiguration.getCompilerMetrics();
    }

    public void setFilesHaveChanged() {
        this.filesHaveChanged.set(true);
    }

    public boolean getFilesHaveChanged() {
        return this.filesHaveChanged.get();
    }

    @Override
    public boolean shouldWarnOnNoSuchType() {
        return this.compilerConfiguration.shouldWarnOnNoSuchType();
    }

    @Override
    public CompilerConfiguration getCompilerConfiguration() {
        return this.compilerConfiguration;
    }

    @Override
    public LibrarySource getSystemLibraryFor(String importSpec) {
        return this.compilerConfiguration.getSystemLibraryFor(importSpec);
    }

    @Override
    public void unitAboutToCompile(DartSource source, boolean diet) {
        this.listener.unitAboutToCompile(source, diet);
    }

    @Override
    public void unitCompiled(DartUnit unit) {
        this.listener.unitCompiled(unit);
    }
}

