/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Pair;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.ArrayBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.DateBinding;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.PrimitiveValueBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.Nullable;

class XmlSerializerImpl {
    private final SerializationFilter filter;
    private final Map<Pair<Type, Accessor>, Binding> myBindings = new HashMap<Pair<Type, Accessor>, Binding>();

    public XmlSerializerImpl(SerializationFilter filter) {
        this.filter = filter;
    }

    Element serialize(Object object) throws XmlSerializationException {
        try {
            return (Element)this.getBinding(object.getClass()).serialize(object, null);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }

    Binding getBinding(Type type) {
        return this.getTypeBinding(type, null);
    }

    Binding getBinding(Accessor accessor) {
        return this.getTypeBinding(accessor.getGenericType(), accessor);
    }

    Binding getTypeBinding(Type type, @Nullable Accessor accessor) {
        if (type instanceof Class) {
            return this._getClassBinding((Class)type, type, accessor);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            assert (rawType instanceof Class);
            return this._getClassBinding((Class)rawType, type, accessor);
        }
        throw new UnsupportedOperationException("Can't get binding for: " + type);
    }

    private Binding _getClassBinding(Class<?> aClass, Type originalType, Accessor accessor) {
        Pair<Type, Accessor> p = new Pair<Type, Accessor>(originalType, accessor);
        Binding binding = this.myBindings.get(p);
        if (binding == null) {
            binding = this._getNonCachedClassBinding(aClass, accessor, originalType);
            this.myBindings.put(p, binding);
            binding.init();
        }
        return binding;
    }

    private Binding _getNonCachedClassBinding(Class<?> aClass, Accessor accessor, Type originalType) {
        if (aClass.isPrimitive()) {
            return new PrimitiveValueBinding(aClass);
        }
        if (aClass.isArray()) {
            return Element.class.isAssignableFrom(aClass.getComponentType()) ? new JDOMElementBinding(accessor) : new ArrayBinding(this, aClass, accessor);
        }
        if (Number.class.isAssignableFrom(aClass)) {
            return new PrimitiveValueBinding(aClass);
        }
        if (Boolean.class.isAssignableFrom(aClass)) {
            return new PrimitiveValueBinding(aClass);
        }
        if (String.class.isAssignableFrom(aClass)) {
            return new PrimitiveValueBinding(aClass);
        }
        if (Collection.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
            return new CollectionBinding((ParameterizedType)originalType, this, accessor);
        }
        if (Map.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
            return new MapBinding((ParameterizedType)originalType, this, accessor);
        }
        if (Element.class.isAssignableFrom(aClass)) {
            return new JDOMElementBinding(accessor);
        }
        if (Date.class.isAssignableFrom(aClass)) {
            return new DateBinding();
        }
        if (aClass.isEnum()) {
            return new PrimitiveValueBinding(aClass);
        }
        return new BeanBinding(aClass, this, accessor);
    }

    @Nullable
    static <T> T findAnnotation(Annotation[] annotations, Class<T> aClass) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!aClass.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    @Nullable
    static <T> T convert(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)String.valueOf(value);
        }
        if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
            return (T)Integer.valueOf(String.valueOf(value));
        }
        if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
            return (T)Double.valueOf(String.valueOf(value));
        }
        if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
            return (T)Float.valueOf(String.valueOf(value));
        }
        if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
            return (T)Long.valueOf(String.valueOf(value));
        }
        if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
            return (T)Boolean.valueOf(String.valueOf(value));
        }
        if (type.isEnum()) {
            T[] enumConstants;
            for (T enumConstant : enumConstants = type.getEnumConstants()) {
                if (!enumConstant.toString().equals(value.toString())) continue;
                return enumConstant;
            }
            return null;
        }
        throw new XmlSerializationException("Can't covert " + value.getClass() + " into " + type);
    }

    public SerializationFilter getFilter() {
        return this.filter;
    }

    public static boolean isIgnoredNode(Object child) {
        Attribute attr;
        String namespaceURI;
        if (child instanceof Text && ((Text)child).getValue().trim().length() == 0) {
            return true;
        }
        if (child instanceof Comment) {
            return true;
        }
        return child instanceof Attribute && (namespaceURI = (attr = (Attribute)child).getNamespaceURI()) != null && namespaceURI != "";
    }

    public static Content[] getNotIgnoredContent(Element m) {
        ArrayList<Content> result = new ArrayList<Content>();
        List content = m.getContent();
        for (Object o : content) {
            if (XmlSerializerImpl.isIgnoredNode(o)) continue;
            result.add((Content)o);
        }
        return result.toArray(new Content[result.size()]);
    }
}

