/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;

public class SkipDefaultValuesSerializationFilters
implements SerializationFilter {
    private final Map<Class, Object> myDefaultBeans = new HashMap<Class, Object>();

    @Override
    public boolean accepts(Accessor accessor, Object bean) {
        if (bean == null) {
            return true;
        }
        Object defaultBean = this.getDefaultBean(bean);
        Object defValue = accessor.read(defaultBean);
        Object beanValue = accessor.read(bean);
        if (defValue instanceof Element && beanValue instanceof Element) {
            return !JDOMUtil.writeElement((Element)defValue, "\n").equals(JDOMUtil.writeElement((Element)beanValue, "\n"));
        }
        return !Comparing.equal(beanValue, defValue);
    }

    private Object getDefaultBean(Object bean) {
        Class<?> c = bean.getClass();
        Object o = this.myDefaultBeans.get(c);
        if (o == null) {
            try {
                o = c.newInstance();
                this.configure(o);
            }
            catch (InstantiationException e) {
                throw new XmlSerializationException(e);
            }
            catch (IllegalAccessException e) {
                throw new XmlSerializationException(e);
            }
            this.myDefaultBeans.put(c, o);
        }
        return o;
    }

    protected void configure(Object o) {
    }
}

