/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SideBorder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AwtVisitor;
import com.intellij.util.ui.ClientPropertyHolder;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.MacUIUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ProgressBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIUtil {
    private static final String TABLE_DECORATION_KEY = "TABLE_DECORATION_KEY";
    private static final Color DECORATED_ROW_BG_COLOR = new Color(242, 245, 249);
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        protected Boolean compute() {
            Boolean bl;
            Boolean bl2;
            if (!SystemInfo.isLinux) {
                bl2 = false;
                if (bl2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ui/UIUtil$1.compute must not return null");
                return bl2;
            }
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                Method method = clazz.getMethod("isXRenderAvailable", new Class[0]);
                bl = (Boolean)method.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                bl2 = false;
                if (bl2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ui/UIUtil$1.compute must not return null");
                return bl2;
            }
            bl2 = bl;
            if (bl == null) throw new IllegalStateException("@NotNull method com/intellij/util/ui/UIUtil$1.compute must not return null");
            return bl2;
        }
    };
    public static final char MNEMONIC = '\u001b';
    @NonNls
    public static final String HTML_MIME = "text/html";
    @NonNls
    public static final String JSLIDER_ISFILLED = "JSlider.isFilled";
    @NonNls
    public static final String ARIAL_FONT_NAME = "Arial";
    @NonNls
    public static final String TABLE_FOCUS_CELL_BACKGROUND_PROPERTY = "Table.focusCellBackground";
    @NonNls
    public static final String CENTER_TOOLTIP_DEFAULT = "ToCenterTooltip";
    @NonNls
    public static final String CENTER_TOOLTIP_STRICT = "ToCenterTooltip.default";
    public static final Pattern CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
    @NonNls
    public static final String FOCUS_PROXY_KEY = "isFocusProxy";
    public static Key<Integer> KEEP_BORDER_SIDES = Key.create("keepBorderSides");
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.UIUtil");
    private static final Color UNFOCUSED_SELECTION_COLOR = Gray._212;
    private static final Color ACTIVE_HEADER_COLOR = new Color(160, 186, 213);
    private static final Color INACTIVE_HEADER_COLOR = Gray._128;
    private static final Color BORDER_COLOR = Color.LIGHT_GRAY;
    public static final Color AQUA_SEPARATOR_FOREGROUND_COLOR = Gray._190;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR = Gray._240;
    public static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    public static final int DEFAULT_HGAP = 10;
    public static final int DEFAULT_VGAP = 4;
    public static final int LARGE_VGAP = 12;
    public static final Insets PANEL_REGULAR_INSETS = new Insets(8, 12, 8, 12);
    public static final Insets PANEL_SMALL_INSETS = new Insets(5, 8, 5, 8);
    private static final HashMap<Color, BufferedImage> ourAppleDotSamples = new HashMap();
    @NonNls
    private static final String ROOT_PANE = "JRootPane.future";

    public static void applyStyle(@NotNull ComponentStyle componentStyle, @NotNull Component comp) {
        if (componentStyle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.applyStyle must not be null");
        }
        if (comp == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ui/UIUtil.applyStyle must not be null");
        }
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent c = (JComponent)comp;
        if (UIUtil.isUnderAquaLookAndFeel()) {
            c.putClientProperty("JComponent.sizeVariant", componentStyle == ComponentStyle.REGULAR ? "regular" : (componentStyle == ComponentStyle.SMALL ? "small" : "mini"));
        } else {
            c.setFont(UIUtil.getFont(componentStyle == ComponentStyle.REGULAR ? FontSize.NORMAL : (componentStyle == ComponentStyle.SMALL ? FontSize.SMALL : FontSize.MINI), c.getFont()));
        }
        Container p = c.getParent();
        if (p != null) {
            SwingUtilities.updateComponentTreeUI(p);
        }
    }

    public static Cursor getTextCursor(Color backgroundColor) {
        return SystemInfo.isMac && ColorUtil.isDark(backgroundColor) ? MacUIUtil.getInvertedTextCursor() : Cursor.getPredefinedCursor(2);
    }

    private UIUtil() {
    }

    public static boolean hasLeakingAppleListeners() {
        return SystemInfo.isMac && System.getProperty("java.runtime.version").startsWith("1.6.0_29");
    }

    public static void removeLeakingAppleListeners() {
        if (!UIUtil.hasLeakingAppleListeners()) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String name = "apple.awt.contentScaleFactor";
        for (PropertyChangeListener each : toolkit.getPropertyChangeListeners(name)) {
            toolkit.removePropertyChangeListener(name, each);
        }
    }

    public static String getHtmlBody(String text) {
        return UIUtil.getHtmlBody(new Html(text));
    }

    public static String getHtmlBody(Html html) {
        String result;
        String text = html.getText();
        if (!text.startsWith("<html>")) {
            result = text.replaceAll("\n", "<br>");
        } else {
            int bodyIdx = text.indexOf("<body>");
            int closedBodyIdx = text.indexOf("</body>");
            if (bodyIdx != -1 && closedBodyIdx != -1) {
                result = text.substring(bodyIdx + "<body>".length(), closedBodyIdx);
            } else {
                text = StringUtil.trimStart(text, "<html>").trim();
                text = StringUtil.trimEnd(text, "</html>").trim();
                text = StringUtil.trimStart(text, "<body>").trim();
                result = text = StringUtil.trimEnd(text, "</body>").trim();
            }
        }
        return html.isKeepFont() ? result : result.replaceAll("<font(.*?)>", "").replaceAll("</font>", "");
    }

    public static void drawLinePickedOut(Graphics graphics, int x, int y, int x1, int y1) {
        if (x == x1) {
            int minY = Math.min(y, y1);
            int maxY = Math.max(y, y1);
            graphics.drawLine(x, minY + 1, x1, maxY - 1);
        } else if (y == y1) {
            int minX = Math.min(x, x1);
            int maxX = Math.max(x, x1);
            graphics.drawLine(minX + 1, y, maxX - 1, y1);
        } else {
            UIUtil.drawLine(graphics, x, y, x1, y1);
        }
    }

    public static boolean isReallyTypedEvent(KeyEvent e) {
        char c = e.getKeyChar();
        if (c < ' ' || c == '\u007f') {
            return false;
        }
        int modifiers = e.getModifiers();
        if (SystemInfo.isMac) {
            return !e.isMetaDown() && !e.isControlDown();
        }
        return (modifiers & 8) == (modifiers & 2);
    }

    public static int getStringY(@NotNull String string, @NotNull Rectangle bounds, @NotNull Graphics2D g) {
        if (string == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.getStringY must not be null");
        }
        if (bounds == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ui/UIUtil.getStringY must not be null");
        }
        if (g == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ui/UIUtil.getStringY must not be null");
        }
        int centerY = bounds.height / 2;
        Font font = g.getFont();
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle stringBounds = font.getStringBounds(string, frc).getBounds();
        return (int)((double)centerY - (double)stringBounds.height / 2.0 - (double)stringBounds.y);
    }

    public static void setEnabled(Component component, boolean enabled, boolean recursively) {
        component.setEnabled(enabled);
        if (component instanceof JLabel) {
            Color color;
            Color color2 = color = enabled ? UIUtil.getLabelForeground() : UIManager.getColor("Label.disabledForeground");
            if (color != null) {
                component.setForeground(color);
            }
        }
        if (recursively && enabled == component.isEnabled() && component instanceof Container) {
            Container container = (Container)component;
            int subComponentCount = container.getComponentCount();
            for (int i = 0; i < subComponentCount; ++i) {
                UIUtil.setEnabled(container.getComponent(i), enabled, recursively);
            }
        }
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
    }

    @NotNull
    public static String[] splitText(String text, FontMetrics fontMetrics, int widthLimit, char separator) {
        ArrayList<String> lines = new ArrayList<String>();
        String currentLine = "";
        StringBuilder currentAtom = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String s;
            int width;
            char ch = text.charAt(i);
            currentAtom.append(ch);
            if (ch == separator) {
                currentLine = currentLine + currentAtom.toString();
                currentAtom.setLength(0);
            }
            if ((width = fontMetrics.stringWidth(s = currentLine + currentAtom.toString())) < widthLimit - fontMetrics.charWidth('w')) continue;
            if (currentLine.length() > 0) {
                lines.add(currentLine);
                currentLine = "";
                continue;
            }
            lines.add(currentAtom.toString());
            currentAtom.setLength(0);
        }
        String s = currentLine + currentAtom.toString();
        if (s.length() > 0) {
            lines.add(s);
        }
        String[] stringArray = ArrayUtil.toStringArray(lines);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/UIUtil.splitText must not return null");
        }
        return stringArray;
    }

    public static void setActionNameAndMnemonic(String text, Action action) {
        String mnemoChar;
        int mnemoPos = text.indexOf(38);
        if (mnemoPos >= 0 && mnemoPos < text.length() - 2 && (mnemoChar = text.substring(mnemoPos + 1, mnemoPos + 2).trim()).length() == 1) {
            action.putValue("MnemonicKey", mnemoChar.charAt(0));
        }
        text = text.replaceAll("&", "");
        action.putValue("Name", text);
    }

    public static Font getLabelFont(@NotNull FontSize size) {
        if (size == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.getLabelFont must not be null");
        }
        return UIUtil.getFont(size, null);
    }

    @NotNull
    public static Font getFont(@NotNull FontSize size, @Nullable Font base) {
        if (size == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.getFont must not be null");
        }
        if (base == null) {
            base = UIUtil.getLabelFont();
        }
        Font font = base.deriveFont(UIUtil.getFontSize(size));
        if (font == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/UIUtil.getFont must not return null");
        }
        return font;
    }

    public static float getFontSize(FontSize size) {
        int defSize = UIUtil.getLabelFont().getSize();
        switch (size) {
            case SMALL: {
                return Math.max((float)defSize - 2.0f, 11.0f);
            }
            case MINI: {
                return Math.max((float)defSize - 4.0f, 9.0f);
            }
        }
        return defSize;
    }

    public static Color getLabelFontColor(FontColor fontColor) {
        Color defColor = UIUtil.getLabelForeground();
        if (fontColor == FontColor.BRIGHTER) {
            return new Color(Math.min(defColor.getRed() + 50, 255), Math.min(defColor.getGreen() + 50, 255), Math.min(defColor.getBlue() + 50, 255));
        }
        return defColor;
    }

    public static Font getLabelFont() {
        return UIManager.getFont("Label.font");
    }

    public static Color getLabelBackground() {
        return UIManager.getColor("Label.background");
    }

    public static Color getLabelForeground() {
        return UIManager.getColor("Label.foreground");
    }

    public static Icon getOptionPanelWarningIcon() {
        return UIManager.getIcon("OptionPane.warningIcon");
    }

    public static Icon getOptionPanelQuestionIcon() {
        return UIUtil.getQuestionIcon();
    }

    @NotNull
    public static String removeMnemonic(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.removeMnemonic must not be null");
        }
        if (s.indexOf(38) != -1) {
            s = StringUtil.replace(s, "&", "");
        }
        if (s.indexOf(95) != -1) {
            s = StringUtil.replace(s, "_", "");
        }
        if (s.indexOf(27) != -1) {
            s = StringUtil.replace(s, String.valueOf('\u001b'), "");
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/UIUtil.removeMnemonic must not return null");
        }
        return string;
    }

    public static int getDisplayMnemonicIndex(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.getDisplayMnemonicIndex must not be null");
        }
        int idx = s.indexOf(38);
        if (idx >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(38)) {
            return idx;
        }
        idx = s.indexOf(27);
        if (idx >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(27)) {
            return idx;
        }
        return -1;
    }

    public static String replaceMnemonicAmpersand(String value) {
        if (value.indexOf(38) >= 0) {
            boolean useMacMnemonic = value.contains("&&");
            StringBuilder realValue = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\\') {
                    if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                        realValue.append('&');
                        ++i;
                        continue;
                    }
                    realValue.append(c);
                    continue;
                }
                if (c == '&') {
                    if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                        if (SystemInfo.isMac) {
                            realValue.append('\u001b');
                        }
                        ++i;
                        continue;
                    }
                    if (SystemInfo.isMac && useMacMnemonic) continue;
                    realValue.append('\u001b');
                    continue;
                }
                realValue.append(c);
            }
            return realValue.toString();
        }
        return value;
    }

    public static Color getTableHeaderBackground() {
        return UIManager.getColor("TableHeader.background");
    }

    public static Color getTreeTextForeground() {
        return UIManager.getColor("Tree.textForeground");
    }

    public static Color getTreeSelectionBackground() {
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            Color color = UIManager.getColor("Tree.selectionBackground");
            if (color != null) {
                return color;
            }
            color = UIManager.getColor("nimbusSelectionBackground");
            if (color != null) {
                return color;
            }
        }
        return UIManager.getColor("Tree.selectionBackground");
    }

    public static Color getTreeTextBackground() {
        return UIManager.getColor("Tree.textBackground");
    }

    public static Color getListSelectionForeground() {
        Color color = UIManager.getColor("List.selectionForeground");
        if (color == null) {
            return UIManager.getColor("List[Selected].textForeground");
        }
        return color;
    }

    public static Color getFieldForegroundColor() {
        return UIManager.getColor("field.foreground");
    }

    public static Color getTableSelectionBackground() {
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            Color color = UIManager.getColor("Table[Enabled+Selected].textBackground");
            if (color != null) {
                return color;
            }
            color = UIManager.getColor("nimbusSelectionBackground");
            if (color != null) {
                return color;
            }
        }
        return UIManager.getColor("Table.selectionBackground");
    }

    public static Color getActiveTextColor() {
        return UIManager.getColor("textActiveText");
    }

    public static Color getInactiveTextColor() {
        return UIManager.getColor("textInactiveText");
    }

    public static Color getSlightlyDarkerColor(Color c) {
        float[] hsl = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), new float[3]);
        return new Color(Color.HSBtoRGB(hsl[0], hsl[1], hsl[2] - 0.08f > 0.0f ? hsl[2] - 0.08f : hsl[2]));
    }

    public static Color getActiveTextFieldBackgroundColor() {
        return UIUtil.getTextFieldBackground();
    }

    public static Color getInactiveTextFieldBackgroundColor() {
        return UIManager.getColor("TextField.inactiveBackground");
    }

    public static Font getTreeFont() {
        return UIManager.getFont("Tree.font");
    }

    public static Font getListFont() {
        return UIManager.getFont("List.font");
    }

    public static Color getTreeSelectionForeground() {
        return UIManager.getColor("Tree.selectionForeground");
    }

    public static Color getTextInactiveTextColor() {
        return UIUtil.getInactiveTextColor();
    }

    public static void installPopupMenuColorAndFonts(JComponent contentPane) {
        LookAndFeel.installColorsAndFont(contentPane, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
    }

    public static void installPopupMenuBorder(JComponent contentPane) {
        LookAndFeel.installBorder(contentPane, "PopupMenu.border");
    }

    public static boolean isMotifLookAndFeel() {
        return "Motif".equals(UIManager.getLookAndFeel().getID());
    }

    public static Color getTreeSelectionBorderColor() {
        return UIManager.getColor("Tree.selectionBorderColor");
    }

    public static int getTreeRightChildIndent() {
        return UIManager.getInt("Tree.rightChildIndent");
    }

    public static int getTreeLeftChildIndent() {
        return UIManager.getInt("Tree.leftChildIndent");
    }

    public static Color getToolTipBackground() {
        return UIManager.getColor("ToolTip.background");
    }

    public static Color getToolTipForeground() {
        return UIManager.getColor("ToolTip.foreground");
    }

    public static Color getComboBoxDisabledForeground() {
        return UIManager.getColor("ComboBox.disabledForeground");
    }

    public static Color getComboBoxDisabledBackground() {
        return UIManager.getColor("ComboBox.disabledBackground");
    }

    public static Color getButtonSelectColor() {
        return UIManager.getColor("Button.select");
    }

    public static Integer getPropertyMaxGutterIconWidth(String propertyPrefix) {
        return (Integer)UIManager.get(propertyPrefix + ".maxGutterIconWidth");
    }

    public static Color getMenuItemDisabledForeground() {
        return UIManager.getColor("MenuItem.disabledForeground");
    }

    public static Object getMenuItemDisabledForegroundObject() {
        return UIManager.get("MenuItem.disabledForeground");
    }

    public static Object getTabbedPanePaintContentBorder(JComponent c) {
        return c.getClientProperty("TabbedPane.paintContentBorder");
    }

    public static boolean isMenuCrossMenuMnemonics() {
        return UIManager.getBoolean("Menu.crossMenuMnemonic");
    }

    public static Color getTableBackground() {
        return UIUtil.isUnderGTKLookAndFeel() ? UIUtil.getTreeTextBackground() : UIManager.getColor("Table.background");
    }

    public static Color getTableSelectionForeground() {
        return UIManager.getColor("Table.selectionForeground");
    }

    public static Color getTableForeground() {
        return UIManager.getColor("Table.foreground");
    }

    public static Color getTableGridColor() {
        return UIManager.getColor("Table.gridColor");
    }

    public static Color getListBackground() {
        return UIUtil.isUnderGTKLookAndFeel() ? UIUtil.getTreeTextBackground() : UIManager.getColor("List.background");
    }

    public static Color getListBackground(boolean isSelected) {
        return isSelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
    }

    public static Color getListForeground() {
        return UIManager.getColor("List.foreground");
    }

    public static Color getListForeground(boolean isSelected) {
        return isSelected ? UIUtil.getListSelectionForeground() : UIUtil.getListForeground();
    }

    public static Color getPanelBackground() {
        return UIManager.getColor("Panel.background");
    }

    public static Color getTreeForeground() {
        return UIManager.getColor("Tree.foreground");
    }

    public static Color getTableFocusCellBackground() {
        return UIManager.getColor(TABLE_FOCUS_CELL_BACKGROUND_PROPERTY);
    }

    public static Color getListSelectionBackground() {
        Color color = UIManager.getColor("List.selectionBackground");
        if (color == null) {
            return UIManager.getColor("List[Selected].textBackground");
        }
        return color;
    }

    public static Color getListUnfocusedSelectionBackground() {
        return UNFOCUSED_SELECTION_COLOR;
    }

    public static Color getTextFieldForeground() {
        return UIManager.getColor("TextField.foreground");
    }

    public static Color getTextFieldBackground() {
        return UIUtil.isUnderGTKLookAndFeel() ? UIManager.getColor("EditorPane.background") : UIManager.getColor("TextField.background");
    }

    public static Font getButtonFont() {
        return UIManager.getFont("Button.font");
    }

    public static Font getToolTipFont() {
        return UIManager.getFont("ToolTip.font");
    }

    public static Color getTabbedPaneBackground() {
        return UIManager.getColor("TabbedPane.background");
    }

    public static void setSliderIsFilled(JSlider slider, boolean value) {
        slider.putClientProperty(JSLIDER_ISFILLED, value);
    }

    public static Color getLabelTextForeground() {
        return UIManager.getColor("Label.textForeground");
    }

    public static Color getControlColor() {
        return UIManager.getColor("control");
    }

    public static Font getOptionPaneMessageFont() {
        return UIManager.getFont("OptionPane.messageFont");
    }

    public static Font getMenuFont() {
        return UIManager.getFont("Menu.font");
    }

    public static Color getSeparatorForeground() {
        return UIManager.getColor("Separator.foreground");
    }

    public static Color getSeparatorBackground() {
        return UIManager.getColor("Separator.background");
    }

    public static Color getSeparatorShadow() {
        return UIManager.getColor("Separator.shadow");
    }

    public static Color getSeparatorHighlight() {
        return UIManager.getColor("Separator.highlight");
    }

    public static Color getSeparatorColorUnderNimbus() {
        return UIManager.getColor("nimbusBlueGrey");
    }

    public static Color getSeparatorColor() {
        Color separatorColor = UIUtil.getSeparatorForeground();
        if (UIUtil.isUnderAlloyLookAndFeel()) {
            separatorColor = UIUtil.getSeparatorShadow();
        }
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            separatorColor = UIUtil.getSeparatorColorUnderNimbus();
        }
        if (UIUtil.isUnderGTKLookAndFeel()) {
            separatorColor = Gray._215;
        }
        return separatorColor;
    }

    public static Border getTableFocusCellHighlightBorder() {
        return UIManager.getBorder("Table.focusCellHighlightBorder");
    }

    public static void setLineStyleAngled(ClientPropertyHolder component) {
        component.putClientProperty("JTree.lineStyle", "Angled");
    }

    public static void setLineStyleAngled(JTree component) {
        component.putClientProperty("JTree.lineStyle", "Angled");
    }

    public static Color getTableFocusCellForeground() {
        return UIManager.getColor("Table.focusCellForeground");
    }

    public static Color getPanelBackgound() {
        return UIUtil.getPanelBackground();
    }

    public static Border getTextFieldBorder() {
        return UIManager.getBorder("TextField.border");
    }

    public static Border getButtonBorder() {
        return UIManager.getBorder("Button.border");
    }

    public static Icon getErrorIcon() {
        return UIManager.getIcon("OptionPane.errorIcon");
    }

    public static Icon getInformationIcon() {
        return UIManager.getIcon("OptionPane.informationIcon");
    }

    public static Icon getQuestionIcon() {
        return UIManager.getIcon("OptionPane.questionIcon");
    }

    public static Icon getWarningIcon() {
        return UIManager.getIcon("OptionPane.warningIcon");
    }

    public static Icon getBalloonInformationIcon() {
        return IconLoader.getIcon("/general/balloonInformation.png");
    }

    public static Icon getBalloonWarningIcon() {
        return IconLoader.getIcon("/general/balloonWarning.png");
    }

    public static Icon getBalloonErrorIcon() {
        return IconLoader.getIcon("/general/balloonError.png");
    }

    public static Icon getRadioButtonIcon() {
        return UIManager.getIcon("RadioButton.icon");
    }

    public static Icon getTreeCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    public static Icon getTreeExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    public static Border getTableHeaderCellBorder() {
        return UIManager.getBorder("TableHeader.cellBorder");
    }

    public static Color getWindowColor() {
        return UIManager.getColor("window");
    }

    public static Color getTextAreaForeground() {
        return UIManager.getColor("TextArea.foreground");
    }

    public static Color getOptionPaneBackground() {
        return UIManager.getColor("OptionPane.background");
    }

    public static boolean isUnderQuaquaLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("Quaqua");
    }

    public static boolean isUnderAlloyLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("Alloy");
    }

    public static boolean isUnderAlloyIDEALookAndFeel() {
        return UIUtil.isUnderAlloyLookAndFeel() && UIManager.getLookAndFeel().getName().contains("IDEA");
    }

    public static boolean isUnderWindowsLookAndFeel() {
        return UIManager.getLookAndFeel().getName().equals("Windows");
    }

    public static boolean isUnderWindowsClassicLookAndFeel() {
        return UIManager.getLookAndFeel().getName().equals("Windows Classic");
    }

    public static boolean isUnderMetalLookAndFeel() {
        return UIManager.getLookAndFeel().getName().equals("Metal");
    }

    public static boolean isUnderNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("Nimbus");
    }

    public static boolean isUnderAquaLookAndFeel() {
        return SystemInfo.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    public static boolean isUnderMotif() {
        return UIManager.getLookAndFeel().getName().contains("Motif");
    }

    public static boolean isUnderGTKLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("GTK");
    }

    @Nullable
    public static String getGtkThemeName() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf != null && "GTKLookAndFeel".equals(laf.getClass().getSimpleName())) {
            try {
                Method method = laf.getClass().getDeclaredMethod("getGtkThemeName", new Class[0]);
                method.setAccessible(true);
                Object theme = method.invoke((Object)laf, new Object[0]);
                if (theme != null) {
                    return theme.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isMurrineBasedTheme() {
        String gtkTheme = UIUtil.getGtkThemeName();
        return "Ambiance".equalsIgnoreCase(gtkTheme) || "Radiance".equalsIgnoreCase(gtkTheme) || "Dust".equalsIgnoreCase(gtkTheme) || "Dust Sand".equalsIgnoreCase(gtkTheme);
    }

    public static Color shade(Color c, double factor, double alphaFactor) {
        assert (factor >= 0.0) : factor;
        return new Color(Math.min((int)Math.round((double)c.getRed() * factor), 255), Math.min((int)Math.round((double)c.getGreen() * factor), 255), Math.min((int)Math.round((double)c.getBlue() * factor), 255), Math.min((int)Math.round((double)c.getAlpha() * alphaFactor), 255));
    }

    public static Color mix(Color c1, Color c2, double factor) {
        assert (0.0 <= factor && factor <= 1.0) : factor;
        double backFactor = 1.0 - factor;
        return new Color(Math.min((int)Math.round((double)c1.getRed() * backFactor + (double)c2.getRed() * factor), 255), Math.min((int)Math.round((double)c1.getGreen() * backFactor + (double)c2.getGreen() * factor), 255), Math.min((int)Math.round((double)c1.getBlue() * backFactor + (double)c2.getBlue() * factor), 255));
    }

    public static boolean isFullRowSelectionLAF() {
        return UIUtil.isUnderNimbusLookAndFeel() || UIUtil.isUnderQuaquaLookAndFeel();
    }

    public static boolean isUnderNativeMacLookAndFeel() {
        return UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderQuaquaLookAndFeel();
    }

    public static int getListCellHPadding() {
        return UIUtil.isUnderNativeMacLookAndFeel() ? 7 : 2;
    }

    public static int getListCellVPadding() {
        return 1;
    }

    public static Insets getListCellPadding() {
        return new Insets(UIUtil.getListCellVPadding(), UIUtil.getListCellHPadding(), UIUtil.getListCellVPadding(), UIUtil.getListCellHPadding());
    }

    public static Insets getListViewportPadding() {
        return UIUtil.isUnderNativeMacLookAndFeel() ? new Insets(1, 0, 1, 0) : new Insets(5, 5, 5, 5);
    }

    public static boolean isToUseDottedCellBorder() {
        return !UIUtil.isUnderNativeMacLookAndFeel();
    }

    public static void removeQuaquaVisualMarginsIn(Component component) {
        if (component instanceof JComponent) {
            Component[] children;
            JComponent jComponent = (JComponent)component;
            for (Component child : children = jComponent.getComponents()) {
                UIUtil.removeQuaquaVisualMarginsIn(child);
            }
            jComponent.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        }
    }

    public static boolean isControlKeyDown(MouseEvent mouseEvent) {
        return SystemInfo.isMac ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
    }

    public static String[] getValidFontNames(boolean familyName) {
        Font[] fonts;
        TreeSet<String> result = new TreeSet<String>();
        for (Font font : fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            try {
                if (!font.canDisplay('a') || !font.canDisplay('z') || !font.canDisplay('A') || !font.canDisplay('Z') || !font.canDisplay('0') || !font.canDisplay('1')) continue;
                result.add(familyName ? font.getFamily() : font.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ArrayUtil.toStringArray(result);
    }

    public static String[] getStandardFontSizes() {
        return new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    }

    public static void setupEnclosingDialogBounds(JComponent component) {
        component.revalidate();
        component.repaint();
        Window window = SwingUtilities.windowForComponent(component);
        if (window != null && (window.getSize().height < window.getMinimumSize().height || window.getSize().width < window.getMinimumSize().width)) {
            window.pack();
        }
    }

    public static String displayPropertiesToCSS(Font font, Color fg) {
        StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: #");
            UIUtil.appendColor(fg, rule);
            rule.append(" ; ");
        }
        rule.append(" }");
        return rule.toString();
    }

    public static void appendColor(Color color, StringBuilder sb) {
        if (color.getRed() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getRed()));
        if (color.getGreen() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getGreen()));
        if (color.getBlue() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getBlue()));
    }

    public static void drawDottedRectangle(Graphics g, int x, int y, int x1, int y1) {
        int i1;
        for (i1 = x; i1 <= x1; i1 += 2) {
            UIUtil.drawLine(g, i1, y, i1, y);
        }
        int n = i1 = i1 != x1 + 1 ? y + 2 : y + 1;
        while (i1 <= y1) {
            UIUtil.drawLine(g, x1, i1, x1, i1);
            i1 += 2;
        }
        int n2 = i1 = i1 != y1 + 1 ? x1 - 2 : x1 - 1;
        while (i1 >= x) {
            UIUtil.drawLine(g, i1, y1, i1, y1);
            i1 -= 2;
        }
        int n3 = i1 = i1 != x - 1 ? y1 - 2 : y1 - 1;
        while (i1 >= y) {
            UIUtil.drawLine(g, x, i1, x, i1);
            i1 -= 2;
        }
    }

    public static void drawBoldDottedLine(Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (SystemInfo.isMac || SystemInfo.isLinux) {
            UIUtil.drawAppleDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        } else {
            UIUtil.drawBoringDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        }
    }

    public static void drawSearchMatch(Graphics2D g, int startX, int endX, int height) {
        Color c1 = new Color(255, 234, 162);
        Color c2 = new Color(255, 208, 66);
        UIUtil.drawSearchMatch(g, startX, endX, height, c1, c2);
    }

    public static void drawSearchMatch(Graphics2D g, int startX, int endX, int height, Color c1, Color c2) {
        boolean drawRound = endX - startX > 4;
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.7f));
        g.setPaint(new GradientPaint(startX, 2.0f, c1, startX, height - 5, c2));
        g.fillRect(startX, 3, endX - startX, height - 5);
        if (drawRound) {
            g.drawLine(startX - 1, 4, startX - 1, height - 4);
            g.drawLine(endX, 4, endX, height - 4);
            g.setColor(new Color(100, 100, 100, 50));
            g.drawLine(startX - 1, 4, startX - 1, height - 4);
            g.drawLine(endX, 4, endX, height - 4);
            g.drawLine(startX, 3, endX - 1, 3);
            g.drawLine(startX, height - 3, endX - 1, height - 3);
        }
        g.setComposite(oldComposite);
    }

    public static void drawRectPickedOut(Graphics2D g, int x, int y, int w, int h) {
        g.drawLine(x + 1, y, x + w - 1, y);
        g.drawLine(x + w, y + 1, x + w, y + h - 1);
        g.drawLine(x + w - 1, y + h, x + 1, y + h);
        g.drawLine(x, y + 1, x, y + h - 1);
    }

    private static void drawBoringDottedLine(Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            UIUtil.drawLine(g, startX, lineY, endX, lineY);
            UIUtil.drawLine(g, startX, lineY + 1, endX, lineY + 1);
        }
        int step = 4;
        int startPosCorrection = startX % 4 < 3 ? 0 : 1;
        g.setColor(fgColor != null ? fgColor : oldColor);
        for (int dotXi = (startX / 4 + startPosCorrection) * 4; dotXi < endX; dotXi += 4) {
            g.drawLine(dotXi, lineY, dotXi + 1, lineY);
            g.drawLine(dotXi, lineY + 1, dotXi + 1, lineY + 1);
        }
        g.setColor(oldColor);
    }

    public static void drawGradientHToolbarBackground(Graphics g, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Gray._215, 0.0f, height, Gray._200);
        g2d.setPaint(gradientPaint);
        g2d.fillRect(0, 0, width, height);
    }

    public static void drawDoubleSpaceDottedLine(Graphics2D g, int start, int end, int xOrY, Color fgColor, boolean horizontal) {
        g.setColor(fgColor);
        for (int dot = start; dot < end; dot += 3) {
            if (horizontal) {
                g.drawLine(dot, xOrY, dot, xOrY);
                continue;
            }
            g.drawLine(xOrY, dot, xOrY, dot);
        }
    }

    private static void drawAppleDottedLine(Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        int dotX0;
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            UIUtil.drawLine(g, startX, lineY, endX, lineY);
            UIUtil.drawLine(g, startX, lineY + 1, endX, lineY + 1);
            UIUtil.drawLine(g, startX, lineY + 2, endX, lineY + 2);
        }
        int step = 4;
        int startPosCorrection = startX % 4 < 3 ? 0 : 1;
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3));
        BufferedImage image = UIUtil.getAppleDotStamp(fgColor, oldColor);
        for (int dotXi = dotX0 = (startX / 4 + startPosCorrection) * 4; dotXi < endX; dotXi += 4) {
            g.drawImage((Image)image, dotXi, lineY, null);
        }
        g.setComposite(oldComposite);
    }

    private static BufferedImage getAppleDotStamp(Color fgColor, Color oldColor) {
        Color color = fgColor != null ? fgColor : oldColor;
        BufferedImage sample = ourAppleDotSamples.get(color);
        if (sample == null) {
            sample = UIUtil.createAppleDotStamp(color);
            ourAppleDotSamples.put(color, sample);
        }
        return sample;
    }

    private static BufferedImage createAppleDotStamp(Color color) {
        BufferedImage image = new BufferedImage(3, 3, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(color);
        g.setComposite(AlphaComposite.getInstance(2, 0.2f));
        g.drawLine(0, 0, 0, 0);
        g.drawLine(2, 0, 2, 0);
        g.setComposite(AlphaComposite.getInstance(2, 0.7f));
        g.drawLine(0, 1, 2, 1);
        g.setComposite(AlphaComposite.getInstance(2, 1.0f));
        g.drawLine(1, 2, 1, 2);
        g.setComposite(AlphaComposite.getInstance(2, 0.5f));
        g.drawLine(1, 0, 1, 0);
        g.drawLine(0, 2, 0, 2);
        g.drawLine(2, 2, 2, 2);
        g.dispose();
        return image;
    }

    public static void applyRenderingHints(Graphics g) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            ((Graphics2D)g).addRenderingHints(map);
        }
    }

    public static void setupComposite(@NotNull Graphics2D g) {
        if (g == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.setupComposite must not be null");
        }
        g.setComposite(X_RENDER_ACTIVE.getValue() != false ? AlphaComposite.SrcOver : AlphaComposite.Src);
    }

    public static void dispatchAllInvocationEvents() {
        AWTEvent event;
        assert (SwingUtilities.isEventDispatchThread()) : Thread.currentThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                AWTEvent event1 = eventQueue.getNextEvent();
                if (!(event1 instanceof InvocationEvent)) continue;
                ((InvocationEvent)event1).dispatch();
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    public static void pump() {
        assert (!SwingUtilities.isEventDispatchThread());
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                queue.offer(queue);
            }
        });
        try {
            queue.take();
        }
        catch (InterruptedException e) {
            LOG.error(e);
        }
    }

    public static void addAwtListener(final AWTEventListener listener, long mask, Disposable parent) {
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, mask);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            }
        });
    }

    public static void drawVDottedLine(Graphics2D g, int lineX, int startY, int endY, @Nullable Color bgColor, Color fgColor) {
        if (bgColor != null) {
            g.setColor(bgColor);
            UIUtil.drawLine(g, lineX, startY, lineX, endY);
        }
        g.setColor(fgColor);
        for (int i = startY / 2 * 2; i < endY; i += 2) {
            g.drawRect(lineX, i, 0, 0);
        }
    }

    public static void drawHDottedLine(Graphics2D g, int startX, int endX, int lineY, @Nullable Color bgColor, Color fgColor) {
        if (bgColor != null) {
            g.setColor(bgColor);
            UIUtil.drawLine(g, startX, lineY, endX, lineY);
        }
        g.setColor(fgColor);
        for (int i = startX / 2 * 2; i < endX; i += 2) {
            g.drawRect(i, lineY, 0, 0);
        }
    }

    public static void drawDottedLine(Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, Color fgColor) {
        if (x1 == x2) {
            UIUtil.drawVDottedLine(g, x1, y1, y2, bgColor, fgColor);
        } else if (y1 == y2) {
            UIUtil.drawHDottedLine(g, x1, x2, y1, bgColor, fgColor);
        } else {
            throw new IllegalArgumentException("Only vertical or horizontal lines are supported");
        }
    }

    public static boolean isFocusAncestor(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.isFocusAncestor must not be null");
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return false;
        }
        if (owner == component) {
            return true;
        }
        return SwingUtilities.isDescendingFrom(owner, component);
    }

    public static boolean isCloseClick(MouseEvent e) {
        return UIUtil.isCloseClick(e, 501);
    }

    public static boolean isCloseClick(MouseEvent e, int effectiveType) {
        if (e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 2 || e.getButton() == 1 && e.isShiftDown();
    }

    public static boolean isActionClick(MouseEvent e) {
        return UIUtil.isActionClick(e, 501);
    }

    public static boolean isActionClick(MouseEvent e, int effectiveType) {
        return UIUtil.isActionClick(e, effectiveType, false);
    }

    public static boolean isActionClick(MouseEvent e, int effectiveType, boolean allowShift) {
        if (!allowShift && UIUtil.isCloseClick(e) || e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 1;
    }

    @NotNull
    public static Color getBgFillColor(@NotNull JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.getBgFillColor must not be null");
        }
        Component parent = UIUtil.findNearestOpaque(c);
        Color color = parent == null ? c.getBackground() : parent.getBackground();
        if (color == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/UIUtil.getBgFillColor must not return null");
        }
        return color;
    }

    @Nullable
    public static Component findNearestOpaque(JComponent c) {
        Container eachParent;
        for (eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!((Component)eachParent).isOpaque()) continue;
            return eachParent;
        }
        return eachParent;
    }

    @NonNls
    public static String getCssFontDeclaration(Font font) {
        return UIUtil.getCssFontDeclaration(font, null, null, null);
    }

    @Language(value="HTML")
    @NonNls
    public static String getCssFontDeclaration(Font font, @Nullable Color fgColor, @Nullable Color linkColor, @Nullable String liImg) {
        URL resource = liImg != null ? SystemInfo.class.getResource(liImg) : null;
        String fontFamilyAndSize = "font-family:" + font.getFamily() + "; font-size:" + font.getSize() + ";";
        String body = "body, div, td {" + fontFamilyAndSize + " " + (fgColor != null ? "color:" + ColorUtil.toHex(fgColor) : "") + "}";
        if (resource != null) {
            body = body + "ul {list-style-image: " + resource.toExternalForm() + "}";
        }
        String link = linkColor != null ? "a {" + fontFamilyAndSize + " color:" + ColorUtil.toHex(linkColor) + "}" : "";
        return "<style> " + body + " " + link + "</style>";
    }

    public static boolean isWinLafOnVista() {
        return (SystemInfo.isWindowsVista || SystemInfo.isWindows7) && "Windows".equals(UIManager.getLookAndFeel().getName());
    }

    public static boolean isStandardMenuLAF() {
        return UIUtil.isWinLafOnVista() || UIUtil.isUnderNimbusLookAndFeel() || UIUtil.isUnderGTKLookAndFeel();
    }

    public static Color getFocusedFillColor() {
        return UIUtil.toAlpha(UIUtil.getListSelectionBackground(), 100);
    }

    public static Color getFocusedBoundsColor() {
        return UIUtil.getBoundsColor();
    }

    public static Color getBoundsColor() {
        return UIUtil.getBorderColor();
    }

    public static Color getBoundsColor(boolean focused) {
        return focused ? UIUtil.getFocusedBoundsColor() : UIUtil.getBoundsColor();
    }

    public static Color toAlpha(Color color, int alpha) {
        Color actual = color != null ? color : Color.black;
        return new Color(actual.getRed(), actual.getGreen(), actual.getBlue(), alpha);
    }

    public static void requestFocus(final @NotNull JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.requestFocus must not be null");
        }
        if (c.isShowing()) {
            c.requestFocus();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    c.requestFocus();
                }
            });
        }
    }

    public static void dispose(Component c) {
        MouseWheelListener[] mouseWheelListeners;
        MouseMotionListener[] motionListeners;
        MouseListener[] mouseListeners;
        if (c == null) {
            return;
        }
        for (MouseListener each : mouseListeners = c.getMouseListeners()) {
            c.removeMouseListener(each);
        }
        for (MouseMotionListener each : motionListeners = c.getMouseMotionListeners()) {
            c.removeMouseMotionListener(each);
        }
        for (MouseWheelListener each : mouseWheelListeners = c.getMouseWheelListeners()) {
            c.removeMouseWheelListener(each);
        }
    }

    public static void disposeProgress(final JProgressBar progress) {
        if (!UIUtil.isUnderNativeMacLookAndFeel()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UIUtil.isToDispose(progress)) {
                    progress.getUI().uninstallUI(progress);
                    progress.putClientProperty("isDisposed", Boolean.TRUE);
                }
            }
        });
    }

    private static boolean isToDispose(JProgressBar progress) {
        ProgressBarUI ui = progress.getUI();
        if (ui == null) {
            return false;
        }
        if (Boolean.TYPE.equals(progress.getClientProperty("isDisposed"))) {
            return false;
        }
        try {
            Field progressBarField = ReflectionUtil.findField(ui.getClass(), JProgressBar.class, "progressBar");
            progressBarField.setAccessible(true);
            return progressBarField.get(ui) != null;
        }
        catch (NoSuchFieldException e) {
            return true;
        }
        catch (IllegalAccessException e) {
            return true;
        }
    }

    @Nullable
    public static Component findUltimateParent(Component c) {
        if (c == null) {
            return null;
        }
        Component eachParent = c;
        while (eachParent.getParent() != null) {
            eachParent = eachParent.getParent();
        }
        return eachParent;
    }

    public static void setToolkitModal(JDialog dialog) {
        try {
            Class<?> modalityType = dialog.getClass().getClassLoader().loadClass("java.awt.Dialog$ModalityType");
            Field field = modalityType.getField("TOOLKIT_MODAL");
            Object value = field.get(null);
            Method method = dialog.getClass().getMethod("setModalityType", modalityType);
            method.invoke((Object)dialog, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateDialogIcon(JDialog dialog, List<Image> images) {
        try {
            Method method = dialog.getClass().getMethod("setIconImages", List.class);
            method.invoke((Object)dialog, images);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasJdk6Dialogs() {
        try {
            UIUtil.class.getClassLoader().loadClass("java.awt.Dialog$ModalityType");
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static Color getHeaderActiveColor() {
        return ACTIVE_HEADER_COLOR;
    }

    public static Color getHeaderInactiveColor() {
        return INACTIVE_HEADER_COLOR;
    }

    public static Color getBorderColor() {
        return BORDER_COLOR;
    }

    public static Color getTitledBorderLineColor() {
        return BORDER_COLOR;
    }

    public static Font getTitledBorderFont() {
        return UIUtil.getLabelFont();
    }

    public static Font getBorderFont(@NotNull FontSize size, boolean isBold) {
        if (size == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.getBorderFont must not be null");
        }
        Font defFont = UIUtil.getTitledBorderFont();
        if (size == FontSize.SMALL) {
            defFont = defFont.deriveFont(Math.max((float)defFont.getSize() - 2.0f, 11.0f));
        }
        if (size == FontSize.MINI) {
            defFont = defFont.deriveFont(Math.max((float)defFont.getSize() - 4.0f, 9.0f));
        }
        return defFont;
    }

    public static Color getTitledBorderTitleColor() {
        return Color.BLACK;
    }

    public static Color getBorderInactiveColor() {
        return UIUtil.getBorderColor();
    }

    public static Color getBorderActiveColor() {
        return UIUtil.getBorderColor();
    }

    public static Color getBorderSeparatorColor() {
        return UIUtil.getBorderColor();
    }

    public static HTMLEditorKit getHTMLEditorKit() {
        HTMLEditorKit kit = new HTMLEditorKit();
        Font font = UIUtil.getLabelFont();
        String family = font != null ? font.getFamily() : "Tahoma";
        int size = font != null ? font.getSize() : 11;
        StyleSheet styleSheet = kit.getStyleSheet();
        styleSheet.addRule(String.format("body, div, p { font-family: %s; font-size: %s; } p { margin-top: 0; }", family, size));
        kit.setStyleSheet(styleSheet);
        return kit;
    }

    public static void removeScrollBorder(final Component c) {
        new AwtVisitor(c){

            @Override
            public boolean visit(Component component) {
                if (component instanceof JScrollPane && !UIUtil.hasNonPrimitiveParents(c, component)) {
                    JScrollPane scrollPane = (JScrollPane)component;
                    Integer keepBorderSides = (Integer)scrollPane.getClientProperty(KEEP_BORDER_SIDES);
                    if (keepBorderSides != null) {
                        if (scrollPane.getBorder() instanceof LineBorder) {
                            Color color = ((LineBorder)scrollPane.getBorder()).getLineColor();
                            scrollPane.setBorder(new SideBorder(color, keepBorderSides));
                        } else {
                            scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), keepBorderSides));
                        }
                    } else {
                        scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), 0));
                    }
                }
                return false;
            }
        };
    }

    public static boolean hasNonPrimitiveParents(Component stopParent, Component c) {
        Container eachParent = c.getParent();
        while (eachParent != null && eachParent != stopParent) {
            if (!UIUtil.isPrimitive(eachParent)) {
                return true;
            }
            eachParent = eachParent.getParent();
        }
        return false;
    }

    public static boolean isPrimitive(Component c) {
        return c instanceof JPanel || c instanceof JLayeredPane;
    }

    public static Point getCenterPoint(Dimension container, Dimension child) {
        return UIUtil.getCenterPoint(new Rectangle(new Point(), container), child);
    }

    public static Point getCenterPoint(Rectangle container, Dimension child) {
        Point result = new Point();
        Point containerLocation = container.getLocation();
        Dimension containerSize = container.getSize();
        result.x = containerLocation.x + containerSize.width / 2 - child.width / 2;
        result.y = containerLocation.y + containerSize.height / 2 - child.height / 2;
        return result;
    }

    public static String toHtml(String html) {
        return UIUtil.toHtml(html, 0);
    }

    @NonNls
    public static String toHtml(String html, int hPadding) {
        html = CLOSE_TAG_PATTERN.matcher(html).replaceAll("<$1$2></$1>");
        Font font = UIUtil.getLabelFont();
        String family = font != null ? font.getFamily() : "Tahoma";
        int size = font != null ? font.getSize() : 11;
        return "<html><style>body { font-family: " + family + "; font-size: " + size + ";} ul li {list-style-type:circle;}</style>" + UIUtil.addPadding(html, hPadding) + "</html>";
    }

    public static String addPadding(String html, int hPadding) {
        return String.format("<p style=\"margin: 0 %dpx 0 %dpx;\">%s</p>", hPadding, hPadding, html);
    }

    public static String convertSpace2Nbsp(String html) {
        StringBuilder result = new StringBuilder();
        int braces = 0;
        for (int currentPos = 0; currentPos < html.length(); ++currentPos) {
            String each = html.substring(currentPos, currentPos + 1);
            if ("<".equals(each)) {
                ++braces;
            } else if (">".equals(each)) {
                --braces;
            }
            if (" ".equals(each) && braces == 0) {
                result.append("&nbsp;");
                continue;
            }
            result.append(each);
        }
        return result.toString();
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.invokeLaterIfNeeded must not be null");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.invokeAndWaitIfNeeded must not be null");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    public static boolean isFocusProxy(@Nullable Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty(FOCUS_PROXY_KEY));
    }

    public static void setFocusProxy(JComponent c, boolean isProxy) {
        c.putClientProperty(FOCUS_PROXY_KEY, isProxy ? Boolean.TRUE : null);
    }

    public static void maybeInstall(InputMap map, String action, KeyStroke stroke) {
        if (map.get(stroke) == null) {
            map.put(stroke, action);
        }
    }

    public static void changeBackGround(Component component, Color background) {
        Color oldBackGround = component.getBackground();
        if (background == null || !background.equals(oldBackGround)) {
            component.setBackground(background);
        }
    }

    public static void initDefaultLAF(String productName) {
        UIUtil.initDefaultLAF();
    }

    public static void initDefaultLAF() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addKeyboardShortcut(JComponent target, final AbstractButton button, KeyStroke keyStroke) {
        target.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (button.isEnabled()) {
                    button.doClick();
                }
            }
        }, keyStroke, 0);
    }

    public static void installComboBoxCopyAction(JComboBox comboBox) {
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        if (!(editorComponent instanceof JTextComponent)) {
            return;
        }
        InputMap inputMap = ((JTextComponent)editorComponent).getInputMap();
        for (KeyStroke keyStroke : inputMap.allKeys()) {
            if (!"copy-to-clipboard".equals(inputMap.get(keyStroke))) continue;
            comboBox.getInputMap().put(keyStroke, "copy-to-clipboard");
        }
        comboBox.getActionMap().put("copy-to-clipboard", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str;
                Component component;
                if (!(e.getSource() instanceof JComboBox)) {
                    return;
                }
                JComboBox comboBox = (JComboBox)e.getSource();
                Object selectedItem = comboBox.getSelectedItem();
                String text = selectedItem instanceof String ? (String)selectedItem : ((component = comboBox.getRenderer().getListCellRendererComponent(new JList(), selectedItem, 0, false, false)) instanceof JLabel ? ((JLabel)component).getText() : (component != null ? ((str = component.toString()) == null || str.startsWith(component.getClass().getName() + "[") ? null : str) : null));
                if (text != null) {
                    JTextField textField = new JTextField(text);
                    textField.selectAll();
                    textField.copy();
                }
            }
        });
    }

    @Nullable
    public static ComboPopup getComboBoxPopup(JComboBox comboBox) {
        ComboBoxUI ui = comboBox.getUI();
        if (ui instanceof BasicComboBoxUI) {
            try {
                Field popup = BasicComboBoxUI.class.getDeclaredField("popup");
                popup.setAccessible(true);
                return (ComboPopup)popup.get(ui);
            }
            catch (NoSuchFieldException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return null;
    }

    public static void fixFormattedField(JFormattedTextField field) {
        if (SystemInfo.isMac) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            int commandKeyMask = toolkit.getMenuShortcutKeyMask();
            InputMap inputMap = field.getInputMap();
            KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, commandKeyMask);
            inputMap.put(copyKeyStroke, "copy-to-clipboard");
            KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, commandKeyMask);
            inputMap.put(pasteKeyStroke, "paste-from-clipboard");
            KeyStroke cutKeyStroke = KeyStroke.getKeyStroke(88, commandKeyMask);
            inputMap.put(cutKeyStroke, "cut-to-clipboard");
        }
    }

    public static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics;
    }

    public static int getSelectedButton(ButtonGroup group) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (group.isSelected(button.getModel())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void setSelectedButton(ButtonGroup group, int index) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            group.setSelected(button.getModel(), index == i);
            ++i;
        }
    }

    public static boolean isSelectionButtonDown(MouseEvent e) {
        return e.isShiftDown() || e.isControlDown() || e.isMetaDown();
    }

    public static void setComboBoxEditorBounds(int x, int y, int width, int height, JComponent editor) {
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            editor.reshape(x, y, width - 4, height - 1);
        } else {
            editor.reshape(x, y, width, height);
        }
    }

    public static int fixComboBoxHeight(int height) {
        return SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel() ? 28 : height;
    }

    @Nullable
    public static <T> T getParentOfType(Class<? extends T> cls, Component c) {
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!cls.isAssignableFrom(eachParent.getClass())) continue;
            Component t = eachParent;
            return (T)t;
        }
        return null;
    }

    public static void scrollListToVisibleIfNeeded(final @NotNull JList list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.scrollListToVisibleIfNeeded must not be null");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle cellBounds;
                Rectangle visibleRect;
                int selectedIndex = list.getSelectedIndex();
                if (selectedIndex >= 0 && !(visibleRect = list.getVisibleRect()).contains(cellBounds = list.getCellBounds(selectedIndex, selectedIndex))) {
                    list.scrollRectToVisible(cellBounds);
                }
            }
        });
    }

    @Nullable
    public static <T extends JComponent> T findComponentOfType(JComponent parent, Class<T> cls) {
        if (parent == null || cls.isAssignableFrom(parent.getClass())) {
            JComponent t = parent;
            return (T)t;
        }
        for (Component component : parent.getComponents()) {
            T comp;
            if (!(component instanceof JComponent) || (comp = UIUtil.findComponentOfType((JComponent)component, cls)) == null) continue;
            return comp;
        }
        return null;
    }

    public static <T extends JComponent> List<T> findComponentsOfType(JComponent parent, Class<T> cls) {
        ArrayList result = new ArrayList();
        UIUtil.findComponentsOfType(parent, cls, result);
        return result;
    }

    private static <T extends JComponent> void findComponentsOfType(JComponent parent, Class<T> cls, ArrayList<T> result) {
        if (parent == null) {
            return;
        }
        if (cls.isAssignableFrom(parent.getClass())) {
            JComponent t = parent;
            result.add(t);
        }
        for (Component c : parent.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            UIUtil.findComponentsOfType((JComponent)c, cls, result);
        }
    }

    @Nullable
    public static JRootPane getRootPane(Component c) {
        JRootPane root = UIUtil.getParentOfType(JRootPane.class, c);
        if (root != null) {
            return root;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            WeakReference pane;
            if (!(eachParent instanceof JComponent) || (pane = (WeakReference)((JComponent)eachParent).getClientProperty(ROOT_PANE)) == null) continue;
            return (JRootPane)pane.get();
        }
        return null;
    }

    public static void setFutureRootPane(JComponent c, JRootPane pane) {
        c.putClientProperty(ROOT_PANE, new WeakReference<JRootPane>(pane));
    }

    public static boolean isMeaninglessFocusOwner(@Nullable Component c) {
        if (c == null || !c.isShowing()) {
            return true;
        }
        return c instanceof JFrame || c instanceof JDialog || c instanceof JWindow || c instanceof JRootPane || UIUtil.isFocusProxy(c);
    }

    public static Timer createNamedTimer(final @NonNls @NotNull String name, int delay, @NotNull ActionListener listener) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.createNamedTimer must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ui/UIUtil.createNamedTimer must not be null");
        }
        return new Timer(delay, listener){

            public String toString() {
                return name;
            }
        };
    }

    public static boolean isDialogRootPane(JRootPane rootPane) {
        if (rootPane != null) {
            Object isDialog = rootPane.getClientProperty("DIALOG_ROOT_PANE");
            return isDialog instanceof Boolean && (Boolean)isDialog != false;
        }
        return false;
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(PanelWithAnchor ... panels) {
        return UIUtil.mergeComponentsWithAnchor(Arrays.asList(panels));
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(Collection<? extends PanelWithAnchor> panels) {
        JComponent tempAnchor = null;
        int maxWidth = 0;
        for (PanelWithAnchor panelWithAnchor : panels) {
            if (panelWithAnchor == null || panelWithAnchor.getAnchor() == null || maxWidth >= panelWithAnchor.getAnchor().getPreferredSize().width) continue;
            maxWidth = panelWithAnchor.getAnchor().getPreferredSize().width;
            tempAnchor = panelWithAnchor.getAnchor();
        }
        for (PanelWithAnchor panelWithAnchor : panels) {
            if (panelWithAnchor == null) continue;
            panelWithAnchor.setAnchor(tempAnchor);
        }
        return tempAnchor;
    }

    public static void setNotOpaqueRecursively(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.setNotOpaqueRecursively must not be null");
        }
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            return;
        }
        if (component.getBackground().equals(UIUtil.getPanelBackground()) || component instanceof JScrollPane || component instanceof JViewport) {
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
            }
            if (component instanceof Container) {
                for (Component c : ((Container)component).getComponents()) {
                    UIUtil.setNotOpaqueRecursively(c);
                }
            }
        }
    }

    public static void addInsets(@NotNull JComponent component, @NotNull Insets insets) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.addInsets must not be null");
        }
        if (insets == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ui/UIUtil.addInsets must not be null");
        }
        if (component == null || insets == null) {
            return;
        }
        if (component.getBorder() != null) {
            component.setBorder(new CompoundBorder(new EmptyBorder(insets), component.getBorder()));
        } else {
            component.setBorder(new EmptyBorder(insets));
        }
    }

    public static Dimension addInsets(@NotNull Dimension dimension, @NotNull Insets insets) {
        if (dimension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil.addInsets must not be null");
        }
        if (insets == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ui/UIUtil.addInsets must not be null");
        }
        Dimension ans = new Dimension(dimension);
        ans.width += insets.left;
        ans.width += insets.right;
        ans.height += insets.top;
        ans.height += insets.bottom;
        return ans;
    }

    public static void adjustWindowToMinimumSize(final Window window) {
        if (window == null) {
            return;
        }
        Dimension minSize = window.getMinimumSize();
        Dimension size = window.getSize();
        final Dimension newSize = new Dimension(Math.max(size.width, minSize.width), Math.max(size.height, minSize.height));
        if (!newSize.equals(size)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (window.isShowing()) {
                        window.setSize(newSize);
                    }
                }
            });
        }
    }

    @Nullable
    public static Color getColorAt(Icon icon, int x, int y) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 1);
        icon.paintIcon(null, image.getGraphics(), 0, 0);
        int[] pixels = new int[1];
        PixelGrabber pixelGrabber = new PixelGrabber(image, x, y, 1, 1, pixels, 0, 1);
        try {
            pixelGrabber.grabPixels();
            return new Color(pixels[0]);
        }
        catch (InterruptedException ignore) {
            return null;
        }
    }

    public static void addBorder(JComponent component, Border border) {
        if (component == null) {
            return;
        }
        if (component.getBorder() != null) {
            component.setBorder(new CompoundBorder(border, component.getBorder()));
        } else {
            component.setBorder(border);
        }
    }

    public static class TextPainter {
        private List<Pair<String, LineInfo>> myLines = new ArrayList<Pair<String, LineInfo>>();
        private boolean myDrawShadow;
        private Color myShadowColor;
        private float myLineSpacing;

        public TextPainter() {
            this.myDrawShadow = UIUtil.isUnderAquaLookAndFeel();
            this.myShadowColor = Gray._220;
            this.myLineSpacing = 1.0f;
        }

        public TextPainter(float lineSpacing) {
            this.myDrawShadow = UIUtil.isUnderAquaLookAndFeel();
            this.myShadowColor = Gray._220;
            this.myLineSpacing = lineSpacing;
        }

        public TextPainter(boolean drawShadow, Color shadowColor, float lineSpacing) {
            this.myDrawShadow = drawShadow;
            this.myShadowColor = shadowColor;
            this.myLineSpacing = lineSpacing;
        }

        public TextPainter withShadow(boolean drawShadow) {
            this.myDrawShadow = drawShadow;
            return this;
        }

        public TextPainter withShadow(boolean drawShadow, Color shadowColor) {
            this.myDrawShadow = drawShadow;
            this.myShadowColor = shadowColor;
            return this;
        }

        public TextPainter withLineSpacing(float lineSpacing) {
            this.myLineSpacing = lineSpacing;
            return this;
        }

        public TextPainter appendLine(String text) {
            if (text == null || text.length() == 0) {
                return this;
            }
            this.myLines.add(Pair.create(text, new LineInfo()));
            return this;
        }

        public TextPainter underlined(@Nullable Color color) {
            if (!this.myLines.isEmpty()) {
                LineInfo info = this.myLines.get(this.myLines.size() - 1).getSecond();
                info.underlined = true;
                info.underlineColor = color;
            }
            return this;
        }

        public TextPainter withBullet(char c) {
            if (!this.myLines.isEmpty()) {
                LineInfo info = this.myLines.get(this.myLines.size() - 1).getSecond();
                info.withBullet = true;
                info.bulletChar = c;
            }
            return this;
        }

        public TextPainter withBullet() {
            return this.withBullet('\u2022');
        }

        public TextPainter underlined() {
            return this.underlined(null);
        }

        public TextPainter smaller() {
            if (!this.myLines.isEmpty()) {
                this.myLines.get(this.myLines.size() - 1).getSecond().smaller = true;
            }
            return this;
        }

        public TextPainter center() {
            if (!this.myLines.isEmpty()) {
                this.myLines.get(this.myLines.size() - 1).getSecond().center = true;
            }
            return this;
        }

        public void draw(final @NotNull Graphics g, PairFunction<Integer, Integer, Pair<Integer, Integer>> _position) {
            if (g == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil$TextPainter.draw must not be null");
            }
            final int[] maxWidth = new int[]{0};
            final int[] height = new int[]{0};
            final int[] maxBulletWidth = new int[]{0};
            ContainerUtil.process(this.myLines, new Processor<Pair<String, LineInfo>>(){

                @Override
                public boolean process(Pair<String, LineInfo> pair) {
                    LineInfo info = pair.getSecond();
                    Font old = null;
                    if (info.smaller) {
                        old = g.getFont();
                        g.setFont(old.deriveFont((float)old.getSize() * 0.7f));
                    }
                    FontMetrics fm = g.getFontMetrics();
                    int bulletWidth = info.withBullet ? fm.stringWidth(" " + info.bulletChar) : 0;
                    maxBulletWidth[0] = Math.max(maxBulletWidth[0], bulletWidth);
                    maxWidth[0] = Math.max(fm.stringWidth(pair.getFirst() + bulletWidth), maxWidth[0]);
                    height[0] = (int)((float)height[0] + (float)(fm.getHeight() + fm.getLeading()) * TextPainter.this.myLineSpacing);
                    if (old != null) {
                        g.setFont(old);
                    }
                    return true;
                }
            });
            final Pair<Integer, Integer> position = _position.fun(maxWidth[0] + 20, height[0]);
            assert (position != null);
            final int[] yOffset = new int[]{position.getSecond()};
            ContainerUtil.process(this.myLines, new Processor<Pair<String, LineInfo>>(){

                @Override
                public boolean process(Pair<String, LineInfo> pair) {
                    LineInfo info = pair.getSecond();
                    Font old = null;
                    if (info.smaller) {
                        old = g.getFont();
                        g.setFont(old.deriveFont((float)old.getSize() * 0.7f));
                    }
                    int x = (Integer)position.getFirst() + maxBulletWidth[0] + 10;
                    FontMetrics fm = g.getFontMetrics();
                    int xOffset = x;
                    if (info.center) {
                        xOffset = x + (maxWidth[0] - fm.stringWidth(pair.getFirst())) / 2;
                    }
                    if (TextPainter.this.myDrawShadow) {
                        Color oldColor = g.getColor();
                        g.setColor(TextPainter.this.myShadowColor);
                        if (info.withBullet) {
                            g.drawString(info.bulletChar + " ", x - fm.stringWidth(" " + info.bulletChar), yOffset[0] + 1);
                        }
                        g.drawString(pair.getFirst(), xOffset, yOffset[0] + 1);
                        g.setColor(oldColor);
                    }
                    if (info.withBullet) {
                        g.drawString(info.bulletChar + " ", x - fm.stringWidth(" " + info.bulletChar), yOffset[0]);
                    }
                    g.drawString(pair.getFirst(), xOffset, yOffset[0]);
                    if (info.underlined) {
                        Color c = null;
                        if (info.underlineColor != null) {
                            c = g.getColor();
                            g.setColor(info.underlineColor);
                        }
                        g.drawLine(x - maxBulletWidth[0] - 10, yOffset[0] + fm.getDescent(), x + maxWidth[0] + 10, yOffset[0] + fm.getDescent());
                        if (c != null) {
                            g.setColor(c);
                        }
                        if (TextPainter.this.myDrawShadow) {
                            c = g.getColor();
                            g.setColor(TextPainter.this.myShadowColor);
                            g.drawLine(x - maxBulletWidth[0] - 10, yOffset[0] + fm.getDescent() + 1, x + maxWidth[0] + 10, yOffset[0] + fm.getDescent() + 1);
                            g.setColor(c);
                        }
                    }
                    yOffset[0] = (int)((float)yOffset[0] + (float)(fm.getHeight() + fm.getLeading()) * TextPainter.this.myLineSpacing);
                    if (old != null) {
                        g.setFont(old);
                    }
                    return true;
                }
            });
        }

        private static class LineInfo {
            private boolean underlined;
            private boolean withBullet;
            private char bulletChar;
            private Color underlineColor;
            private boolean smaller;
            private boolean center;

            private LineInfo() {
            }
        }
    }

    public static class MacTreeUI
    extends BasicTreeUI {
        @NonNls
        public static final String SOURCE_LIST_CLIENT_PROPERTY = "mac.ui.source.list";
        @NonNls
        public static final String STRIPED_CLIENT_PROPERTY = "mac.ui.striped";
        private static final Icon TREE_COLLAPSED_ICON = UIUtil.getTreeCollapsedIcon();
        private static final Icon TREE_EXPANDED_ICON = UIUtil.getTreeExpandedIcon();
        private static final Icon TREE_SELECTED_COLLAPSED_ICON = IconLoader.getIcon("/mac/tree_white_right_arrow.png");
        private static final Icon TREE_SELECTED_EXPANDED_ICON = IconLoader.getIcon("/mac/tree_white_down_arrow.png");
        private static final Border LIST_BACKGROUND_PAINTER = (Border)UIManager.get("List.sourceListBackgroundPainter");
        private static final Border LIST_SELECTION_BACKGROUND_PAINTER = (Border)UIManager.get("List.sourceListSelectionBackgroundPainter");
        private static final Border LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER = (Border)UIManager.get("List.sourceListFocusedSelectionBackgroundPainter");
        private boolean myWideSelection;
        private boolean myOldRepaintAllRowValue;
        private final MouseListener mySelectionListener = new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/UIUtil$MacTreeUI$1.mousePressed must not be null");
                }
                JTree tree = (JTree)e.getSource();
                if (SwingUtilities.isLeftMouseButton(e) && !e.isPopupTrigger()) {
                    if (MacTreeUI.this.isEditing(tree) && tree.getInvokesStopCellEditing() && !MacTreeUI.this.stopEditing(tree)) {
                        return;
                    }
                    TreePath pressedPath = MacTreeUI.this.getClosestPathForLocation(tree, e.getX(), e.getY());
                    if (pressedPath != null) {
                        Rectangle bounds = MacTreeUI.this.getPathBounds(tree, pressedPath);
                        if (e.getY() >= bounds.y + bounds.height) {
                            return;
                        }
                        if (bounds.contains(e.getPoint()) || MacTreeUI.this.isLocationInExpandControl(pressedPath, e.getX(), e.getY())) {
                            return;
                        }
                        if (tree.getDragEnabled() || !MacTreeUI.this.startEditing(pressedPath, e)) {
                            MacTreeUI.this.selectPathForEvent(pressedPath, e);
                        }
                    }
                }
            }
        };

        public MacTreeUI() {
            this(true);
        }

        public MacTreeUI(boolean wideSelection) {
            this.myWideSelection = wideSelection;
        }

        @Override
        protected void completeUIInstall() {
            super.completeUIInstall();
            this.myOldRepaintAllRowValue = UIManager.getBoolean("Tree.repaintWholeRow");
            UIManager.put("Tree.repaintWholeRow", true);
            this.tree.setShowsRootHandles(true);
            this.tree.addMouseListener(this.mySelectionListener);
        }

        @Override
        public void uninstallUI(JComponent c) {
            super.uninstallUI(c);
            UIManager.put("Tree.repaintWholeRow", this.myOldRepaintAllRowValue);
            c.removeMouseListener(this.mySelectionListener);
        }

        @Override
        protected void installKeyboardActions() {
            super.installKeyboardActions();
            if (Boolean.TRUE.equals(this.tree.getClientProperty("MacTreeUi.actionsInstalled"))) {
                return;
            }
            this.tree.putClientProperty("MacTreeUi.actionsInstalled", Boolean.TRUE);
            InputMap inputMap = this.tree.getInputMap(0);
            inputMap.put(KeyStroke.getKeyStroke("pressed LEFT"), "collapse_or_move_up");
            inputMap.put(KeyStroke.getKeyStroke("pressed RIGHT"), "expand");
            ActionMap actionMap = this.tree.getActionMap();
            final Action expandAction = actionMap.get("expand");
            if (expandAction != null) {
                actionMap.put("expand", new TreeUIAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreePath selectionPath;
                        JTree tree;
                        int selectionRow;
                        Object source = e.getSource();
                        if (source instanceof JTree && (selectionRow = (tree = (JTree)source).getLeadSelectionRow()) != -1 && (selectionPath = tree.getPathForRow(selectionRow)) != null) {
                            boolean leaf = tree.getModel().isLeaf(selectionPath.getLastPathComponent());
                            int toSelect = -1;
                            int toScroll = -1;
                            if (!leaf && tree.isExpanded(selectionRow)) {
                                if (selectionRow + 1 < tree.getRowCount()) {
                                    toScroll = toSelect = selectionRow + 1;
                                }
                            } else if (leaf) {
                                toScroll = selectionRow;
                            }
                            if (toSelect != -1) {
                                tree.setSelectionInterval(toSelect, toSelect);
                            }
                            if (toScroll != -1) {
                                tree.scrollRowToVisible(toScroll);
                            }
                            if (toSelect != -1 || toScroll != -1) {
                                return;
                            }
                        }
                        expandAction.actionPerformed(e);
                    }
                });
            }
            actionMap.put("collapse_or_move_up", new TreeUIAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object source = e.getSource();
                    if (source instanceof JTree) {
                        JTree tree = (JTree)source;
                        int selectionRow = tree.getLeadSelectionRow();
                        if (selectionRow == -1) {
                            return;
                        }
                        TreePath selectionPath = tree.getPathForRow(selectionRow);
                        if (selectionPath == null) {
                            return;
                        }
                        if (tree.getModel().isLeaf(selectionPath.getLastPathComponent()) || tree.isCollapsed(selectionRow)) {
                            TreePath parentPath = tree.getPathForRow(selectionRow).getParentPath();
                            if (parentPath != null && (parentPath.getParentPath() != null || tree.isRootVisible())) {
                                int parentRow = tree.getRowForPath(parentPath);
                                tree.scrollRowToVisible(parentRow);
                                tree.setSelectionInterval(parentRow, parentRow);
                            }
                        } else {
                            tree.collapseRow(selectionRow);
                        }
                    }
                }
            });
        }

        @Override
        protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        }

        @Override
        protected boolean isToggleSelectionEvent(MouseEvent e) {
            return SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown()) && !e.isPopupTrigger();
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        }

        @Override
        protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        }

        public boolean isWideSelection() {
            return this.myWideSelection;
        }

        @Override
        protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            int xOffset;
            int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
            int n = xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
            if (path != null && this.myWideSelection) {
                boolean selected = this.tree.isPathSelected(path);
                Graphics2D rowGraphics = (Graphics2D)g.create();
                rowGraphics.setClip(clipBounds);
                Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
                Color background = this.tree.getBackground();
                if (row % 2 == 0 && Boolean.TRUE.equals(this.tree.getClientProperty(STRIPED_CLIENT_PROPERTY))) {
                    background = DECORATED_ROW_BG_COLOR;
                }
                if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
                    if (selected) {
                        if (this.tree.hasFocus()) {
                            LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                        } else {
                            LIST_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                        }
                    } else {
                        rowGraphics.setColor(background);
                        rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                    }
                } else {
                    Color bg;
                    Color color = bg = this.tree.hasFocus() ? UIUtil.getTreeSelectionBackground() : UIUtil.getListUnfocusedSelectionBackground();
                    if (!selected) {
                        bg = background;
                    }
                    rowGraphics.setColor(bg);
                    rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height - 1);
                }
                if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                    this.paintExpandControl(rowGraphics, bounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                }
                super.paintRow(rowGraphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                rowGraphics.dispose();
            } else {
                super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            }
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            if (this.myWideSelection) {
                int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
                int xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
                Rectangle bounds = g.getClipBounds();
                Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
                if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
                    Graphics2D backgroundGraphics = (Graphics2D)g.create();
                    backgroundGraphics.setClip(xOffset, bounds.y, containerWidth, bounds.height);
                    LIST_BACKGROUND_PAINTER.paintBorder(this.tree, backgroundGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    backgroundGraphics.dispose();
                }
            }
            super.paint(g, c);
        }

        @Override
        protected CellRendererPane createCellRendererPane() {
            return new CellRendererPane(){

                @Override
                public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                    if (c instanceof JComponent && MacTreeUI.this.myWideSelection) {
                        ((JComponent)c).setOpaque(false);
                    }
                    super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
                }
            };
        }

        @Override
        protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            Icon collapseIcon;
            boolean isPathSelected = this.tree.getSelectionModel().isPathSelected(path);
            Icon expandIcon = isPathSelected && this.tree.hasFocus() ? TREE_SELECTED_EXPANDED_ICON : TREE_EXPANDED_ICON;
            Icon icon = collapseIcon = isPathSelected && this.tree.hasFocus() ? TREE_SELECTED_COLLAPSED_ICON : TREE_COLLAPSED_ICON;
            if (!this.isLeaf(row)) {
                this.setExpandedIcon(expandIcon);
                this.setCollapsedIcon(collapseIcon);
            }
            super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }

        private static abstract class TreeUIAction
        extends AbstractAction
        implements UIResource {
            private TreeUIAction() {
            }
        }
    }

    public static enum FontColor {
        NORMAL,
        BRIGHTER;

    }

    public static enum ComponentStyle {
        REGULAR,
        SMALL,
        MINI;

    }

    public static enum FontSize {
        NORMAL,
        SMALL,
        MINI;

    }
}

