/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ThreeStateCheckBox
extends JCheckBox {
    private State myState;
    private boolean myThirdStateEnabled = true;

    public ThreeStateCheckBox() {
        this(null, null, State.DONT_CARE);
    }

    public ThreeStateCheckBox(State initial) {
        this(null, null, initial);
    }

    public ThreeStateCheckBox(String text) {
        this(text, null, State.DONT_CARE);
    }

    public ThreeStateCheckBox(String text, State initial) {
        this(text, null, initial);
    }

    public ThreeStateCheckBox(String text, Icon icon) {
        this(text, icon, State.DONT_CARE);
    }

    public ThreeStateCheckBox(String text, Icon icon, State initial) {
        super(text, icon);
        this.setModel(new JToggleButton.ToggleButtonModel(){

            @Override
            public void setSelected(boolean selected) {
                ThreeStateCheckBox.this.myState = ThreeStateCheckBox.this.nextState();
                this.fireStateChanged();
                this.fireItemStateChanged(new ItemEvent(this, 701, this, 1));
            }

            @Override
            public boolean isSelected() {
                return ThreeStateCheckBox.this.myState == State.SELECTED;
            }
        });
        this.setState(initial);
    }

    private State nextState() {
        switch (this.myState) {
            case SELECTED: {
                return State.NOT_SELECTED;
            }
            case NOT_SELECTED: {
                if (this.myThirdStateEnabled) {
                    return State.DONT_CARE;
                }
                return State.SELECTED;
            }
        }
        return State.SELECTED;
    }

    public boolean isThirdStateEnabled() {
        return this.myThirdStateEnabled;
    }

    public void setThirdStateEnabled(boolean thirdStateEnabled) {
        this.myThirdStateEnabled = thirdStateEnabled;
    }

    @Override
    public void setSelected(boolean b) {
        this.setState(b ? State.SELECTED : State.NOT_SELECTED);
    }

    public void setState(State state) {
        this.myState = state;
        this.repaint();
    }

    public State getState() {
        return this.myState;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        switch (this.getState()) {
            case DONT_CARE: {
                Icon icon = this.getIcon();
                if (icon == null) {
                    icon = UIManager.getIcon("CheckBox.icon");
                }
                if (icon == null) break;
                Insets i = this.getInsets();
                Rectangle r = this.getBounds();
                Rectangle r1 = new Rectangle();
                r1.x = i.left;
                r1.y = i.top;
                r1.width = r.width - (i.right + r1.x);
                r1.height = r.height - (i.bottom + r1.y);
                Rectangle r2 = new Rectangle();
                Rectangle r3 = new Rectangle();
                SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), this.getText(), icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), r1, r2, r3, this.getText() == null ? 0 : this.getIconTextGap());
                g.fillRect(r2.x + r2.width / 2 - r2.width / 5, r2.y + r2.height / 2 - 1, r2.width / 3, 2);
                break;
            }
        }
    }

    public static enum State {
        SELECTED,
        NOT_SELECTED,
        DONT_CARE;

    }
}

