/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import gnu.trove.TIntDoubleHashMap;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridBag
extends GridBagConstraints {
    private int myDefaultAnchor;
    @NotNull
    private final TIntIntHashMap myDefaultColumnAnchors;
    private int myDefaultFill;
    @NotNull
    private final TIntIntHashMap myDefaultColumnFills;
    private double myDefaultWeightX;
    @NotNull
    private final TIntDoubleHashMap myDefaultColumnWeightsX;
    private double myDefaultWeightY;
    @NotNull
    private final TIntDoubleHashMap myDefaultColumnWeightsY;
    private int myDefaultPaddingX;
    @NotNull
    private final TIntIntHashMap myDefaultColumnPaddingsX;
    private int myDefaultPaddingY;
    @NotNull
    private final TIntIntHashMap myDefaultColumnPaddingsY;
    @Nullable
    private Insets myDefaultInsets;
    @NotNull
    private final TIntObjectHashMap<Insets> myDefaultColumnInsets;

    public GridBag() {
        this.myDefaultAnchor = this.anchor;
        this.myDefaultColumnAnchors = new TIntIntHashMap();
        this.myDefaultFill = this.fill;
        this.myDefaultColumnFills = new TIntIntHashMap();
        this.myDefaultWeightX = this.weightx;
        this.myDefaultColumnWeightsX = new TIntDoubleHashMap();
        this.myDefaultWeightY = this.weighty;
        this.myDefaultColumnWeightsY = new TIntDoubleHashMap();
        this.myDefaultPaddingX = this.ipadx;
        this.myDefaultColumnPaddingsX = new TIntIntHashMap();
        this.myDefaultPaddingY = this.ipady;
        this.myDefaultColumnPaddingsY = new TIntIntHashMap();
        this.myDefaultInsets = this.insets;
        this.myDefaultColumnInsets = new TIntObjectHashMap();
        this.gridy = -1;
        this.gridx = -1;
    }

    @NotNull
    public GridBag nextLine() {
        ++this.gridy;
        this.gridx = -1;
        GridBag gridBag = this.reset();
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.nextLine must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag next() {
        ++this.gridx;
        GridBag gridBag = this.reset();
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.next must not return null");
        }
        return gridBag;
    }

    public int getLine() {
        return this.gridy;
    }

    @NotNull
    public GridBag setLine(int line) {
        this.gridy = line;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setLine must not return null");
        }
        return gridBag;
    }

    public int getColumn() {
        return this.gridx;
    }

    @NotNull
    public GridBag setColumn(int cell) {
        this.gridx = cell;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setColumn must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag reset() {
        this.gridheight = 1;
        this.gridwidth = 1;
        int column = this.gridx;
        this.anchor(this.getDefaultAnchor(column));
        this.fill = this.getDefaultFill(column);
        this.weightx(this.getDefaultWeightX(column));
        this.weighty(this.getDefaultWeightY(column));
        this.padx(this.getDefaultPaddingX(column));
        this.pady(this.getDefaultPaddingY(column));
        this.insets(this.getDefaultInsets(column));
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.reset must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag anchor(int anchor) {
        this.anchor = anchor;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.anchor must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag fillCell() {
        this.fill = 1;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.fillCell must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag fillCellHorizontally() {
        this.fill = 2;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.fillCellHorizontally must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag fillCellVertically() {
        this.fill = 3;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.fillCellVertically must not return null");
        }
        return gridBag;
    }

    public GridBag fillCellNone() {
        this.fill = 0;
        return this;
    }

    @NotNull
    public GridBag weightx(double weight) {
        this.weightx = weight;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.weightx must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag weighty(double weight) {
        this.weighty = weight;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.weighty must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag coverLine() {
        this.gridwidth = 0;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.coverLine must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag coverLine(int cells) {
        this.gridwidth = cells;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.coverLine must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag coverColumn() {
        this.gridheight = 0;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.coverColumn must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag coverColumn(int cells) {
        this.gridheight = cells;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.coverColumn must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag padx(int padding) {
        this.ipadx = padding;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.padx must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag pady(int padding) {
        this.ipady = padding;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.pady must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag insets(int top, int left, int bottom, int right) {
        GridBag gridBag = this.insets(new Insets(top, left, bottom, right));
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.insets must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag insets(@Nullable Insets insets) {
        if (insets != null && (insets.top < 0 || insets.bottom < 0 || insets.left < 0 || insets.right < 0)) {
            Insets def = this.getDefaultInsets(this.gridx);
            insets = (Insets)insets.clone();
            if (insets.top < 0) {
                int n = insets.top = def == null ? 0 : def.top;
            }
            if (insets.left < 0) {
                int n = insets.left = def == null ? 0 : def.left;
            }
            if (insets.bottom < 0) {
                int n = insets.bottom = def == null ? 0 : def.bottom;
            }
            if (insets.right < 0) {
                insets.right = def == null ? 0 : def.right;
            }
        }
        this.insets = insets;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.insets must not return null");
        }
        return gridBag;
    }

    public int getDefaultAnchor() {
        return this.myDefaultAnchor;
    }

    @NotNull
    public GridBag setDefaultAnchor(int anchor) {
        this.myDefaultAnchor = anchor;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultAnchor must not return null");
        }
        return gridBag;
    }

    public int getDefaultAnchor(int column) {
        return this.myDefaultColumnAnchors.containsKey(column) ? this.myDefaultColumnAnchors.get(column) : this.getDefaultAnchor();
    }

    @NotNull
    public GridBag setDefaultAnchor(int column, int anchor) {
        if (anchor == -1) {
            this.myDefaultColumnAnchors.remove(column);
        } else {
            this.myDefaultColumnAnchors.put(column, anchor);
        }
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultAnchor must not return null");
        }
        return gridBag;
    }

    public int getDefaultFill() {
        return this.myDefaultFill;
    }

    @NotNull
    public GridBag setDefaultFill(int fill) {
        this.myDefaultFill = fill;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultFill must not return null");
        }
        return gridBag;
    }

    public int getDefaultFill(int column) {
        return this.myDefaultColumnFills.containsKey(column) ? this.myDefaultColumnFills.get(column) : this.getDefaultFill();
    }

    @NotNull
    public GridBag setDefaultFill(int column, int fill) {
        if (fill == -1) {
            this.myDefaultColumnFills.remove(column);
        } else {
            this.myDefaultColumnFills.put(column, fill);
        }
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultFill must not return null");
        }
        return gridBag;
    }

    public double getDefaultWeightX() {
        return this.myDefaultWeightX;
    }

    @NotNull
    public GridBag setDefaultWeightX(double weight) {
        this.myDefaultWeightX = weight;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultWeightX must not return null");
        }
        return gridBag;
    }

    public double getDefaultWeightX(int column) {
        return this.myDefaultColumnWeightsX.containsKey(column) ? this.myDefaultColumnWeightsX.get(column) : this.getDefaultWeightX();
    }

    @NotNull
    public GridBag setDefaultWeightX(int column, double weight) {
        if (weight == -1.0) {
            this.myDefaultColumnWeightsX.remove(column);
        } else {
            this.myDefaultColumnWeightsX.put(column, weight);
        }
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultWeightX must not return null");
        }
        return gridBag;
    }

    public double getDefaultWeightY() {
        return this.myDefaultWeightY;
    }

    @NotNull
    public GridBag setDefaultWeightY(double weight) {
        this.myDefaultWeightY = weight;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultWeightY must not return null");
        }
        return gridBag;
    }

    public double getDefaultWeightY(int column) {
        return this.myDefaultColumnWeightsY.containsKey(column) ? this.myDefaultColumnWeightsY.get(column) : this.getDefaultWeightY();
    }

    @NotNull
    public GridBag setDefaultWeightY(int column, double weight) {
        if (weight == -1.0) {
            this.myDefaultColumnWeightsY.remove(column);
        } else {
            this.myDefaultColumnWeightsY.put(column, weight);
        }
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultWeightY must not return null");
        }
        return gridBag;
    }

    public int getDefaultPaddingX() {
        return this.myDefaultPaddingX;
    }

    @NotNull
    public GridBag setDefaultPaddingX(int padding) {
        this.myDefaultPaddingX = padding;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultPaddingX must not return null");
        }
        return gridBag;
    }

    public int getDefaultPaddingX(int column) {
        return this.myDefaultColumnPaddingsX.containsKey(column) ? this.myDefaultColumnPaddingsX.get(column) : this.getDefaultPaddingX();
    }

    @NotNull
    public GridBag setDefaultPaddingX(int column, int padding) {
        if (padding == -1) {
            this.myDefaultColumnPaddingsX.remove(column);
        } else {
            this.myDefaultColumnPaddingsX.put(column, padding);
        }
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultPaddingX must not return null");
        }
        return gridBag;
    }

    public int getDefaultPaddingY() {
        return this.myDefaultPaddingY;
    }

    @NotNull
    public GridBag setDefaultPaddingY(int padding) {
        this.myDefaultPaddingY = padding;
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultPaddingY must not return null");
        }
        return gridBag;
    }

    public int getDefaultPaddingY(int column) {
        return this.myDefaultColumnPaddingsY.containsKey(column) ? this.myDefaultColumnPaddingsY.get(column) : this.getDefaultPaddingY();
    }

    @NotNull
    public GridBag setDefaultPaddingY(int column, int padding) {
        if (padding == -1) {
            this.myDefaultColumnPaddingsY.remove(column);
        } else {
            this.myDefaultColumnPaddingsY.put(column, padding);
        }
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultPaddingY must not return null");
        }
        return gridBag;
    }

    @Nullable
    public Insets getDefaultInsets() {
        return this.myDefaultInsets;
    }

    @NotNull
    public GridBag setDefaultInsets(int top, int left, int bottom, int right) {
        GridBag gridBag = this.setDefaultInsets(new Insets(top, left, bottom, right));
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultInsets must not return null");
        }
        return gridBag;
    }

    public GridBag setDefaultInsets(@Nullable Insets insets) {
        this.myDefaultInsets = insets;
        return this;
    }

    @Nullable
    public Insets getDefaultInsets(int column) {
        return this.myDefaultColumnInsets.containsKey(column) ? (Insets)this.myDefaultColumnInsets.get(column) : this.getDefaultInsets();
    }

    @NotNull
    public GridBag setDefaultInsets(int column, int top, int left, int bottom, int right) {
        GridBag gridBag = this.setDefaultInsets(column, new Insets(top, left, bottom, right));
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultInsets must not return null");
        }
        return gridBag;
    }

    @NotNull
    public GridBag setDefaultInsets(int column, @Nullable Insets insets) {
        if (insets == null) {
            this.myDefaultColumnInsets.remove(column);
        } else {
            this.myDefaultColumnInsets.put(column, (Object)insets);
        }
        GridBag gridBag = this;
        if (gridBag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/GridBag.setDefaultInsets must not return null");
        }
        return gridBag;
    }
}

