/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ListWithSelection;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ComboBoxTableCellRenderer
extends JPanel
implements TableCellRenderer {
    public static final TableCellRenderer INSTANCE = new ComboBoxTableCellRenderer();
    public static final TableCellRenderer COMBO_WHEN_SELECTED_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                value = new ListWithSelection<Object>((Collection<Object>)Arrays.asList(value));
                return INSTANCE.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    };
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.ComboBoxTableCellRenderer");
    private final JComboBox myCombo = new JComboBox();

    private ComboBoxTableCellRenderer() {
        super(new GridBagLayout());
        this.add((Component)this.myCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public JComponent getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof ListWithSelection) {
            ListWithSelection tags = (ListWithSelection)value;
            if (tags.getSelection() == null) {
                tags.selectFirst();
            }
            this.myCombo.removeAllItems();
            for (Object tag : tags) {
                this.myCombo.addItem(tag);
            }
            this.myCombo.setSelectedItem(tags.getSelection());
        } else {
            LOG.error("value " + LogUtil.objectAndClass(value) + ", at " + row + ":" + column + ", in " + table.getModel());
            this.myCombo.removeAllItems();
            this.myCombo.setSelectedIndex(-1);
        }
        return this;
    }
}

