/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class StringSearcher {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.text.StringSearcher");
    private final String myPattern;
    private final char[] myPatternArray;
    private final int myPatternLength;
    private final int[] mySearchTable;
    private final boolean myCaseSensitive;
    private final boolean myForwardDirection;
    private final boolean myJavaIdentifier;

    public int getPatternLength() {
        return this.myPatternLength;
    }

    public StringSearcher(@NotNull String pattern, boolean caseSensitive, boolean forwardDirection) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/StringSearcher.<init> must not be null");
        }
        this.mySearchTable = new int[128];
        LOG.assertTrue(pattern.length() > 0);
        this.myPattern = pattern;
        this.myCaseSensitive = caseSensitive;
        this.myForwardDirection = forwardDirection;
        this.myPatternArray = this.myCaseSensitive ? this.myPattern.toCharArray() : this.myPattern.toLowerCase().toCharArray();
        this.myPatternLength = this.myPatternArray.length;
        Arrays.fill(this.mySearchTable, -1);
        this.myJavaIdentifier = pattern.length() == 0 || Character.isJavaIdentifierPart(pattern.charAt(0)) && Character.isJavaIdentifierPart(pattern.charAt(pattern.length() - 1));
    }

    public String getPattern() {
        return this.myPattern;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isJavaIdentifier() {
        return this.myJavaIdentifier;
    }

    public boolean isForwardDirection() {
        return this.myForwardDirection;
    }

    public int scan(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/StringSearcher.scan must not be null");
        }
        return this.scan(text, 0, text.length());
    }

    public int scan(@NotNull CharSequence text, int _start, int _end) {
        int step;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/StringSearcher.scan must not be null");
        }
        LOG.assertTrue(_start <= _end, _start - _end);
        LOG.assertTrue(_end <= text.length(), text.length() - _end);
        if (this.myForwardDirection) {
            int step2;
            if (this.myPatternLength == 1) {
                return StringUtil.indexOf(text, this.myPatternArray[0], _start, _end, this.myCaseSensitive);
            }
            int end = _end - this.myPatternLength;
            for (int start = _start; start <= end; start += step2) {
                int index;
                int i = this.myPatternLength - 1;
                char lastChar = text.charAt(start + i);
                if (!this.myCaseSensitive) {
                    lastChar = StringUtil.toLowerCase(lastChar);
                }
                if (this.myPatternArray[i] == lastChar) {
                    --i;
                    while (i >= 0) {
                        char c = text.charAt(start + i);
                        if (!this.myCaseSensitive) {
                            c = StringUtil.toLowerCase(c);
                        }
                        if (this.myPatternArray[i] != c) break;
                        --i;
                    }
                    if (i < 0) {
                        return start;
                    }
                }
                int n = step2 = '\u0000' <= lastChar && lastChar < '\u0080' ? this.mySearchTable[lastChar] : 1;
                if (step2 > 0) continue;
                for (index = this.myPatternLength - 2; index >= 0 && this.myPatternArray[index] != lastChar; --index) {
                }
                this.mySearchTable[lastChar] = step2 = this.myPatternLength - index - 1;
            }
            return -1;
        }
        int end = text.length() - this.myPatternLength + 1;
        for (int start = 1; start <= end; start += step) {
            int index;
            int i = this.myPatternLength - 1;
            char lastChar = text.charAt(text.length() - (start + i));
            if (!this.myCaseSensitive) {
                lastChar = StringUtil.toLowerCase(lastChar);
            }
            if (this.myPatternArray[this.myPatternLength - 1 - i] == lastChar) {
                --i;
                while (i >= 0) {
                    char c = text.charAt(text.length() - (start + i));
                    if (!this.myCaseSensitive) {
                        c = StringUtil.toLowerCase(c);
                    }
                    if (this.myPatternArray[this.myPatternLength - 1 - i] != c) break;
                    --i;
                }
                if (i < 0) {
                    return text.length() - start - this.myPatternLength + 1;
                }
            }
            int n = step = '\u0000' <= lastChar && lastChar < '\u0080' ? this.mySearchTable[lastChar] : 1;
            if (step > 0) continue;
            for (index = this.myPatternLength - 2; index >= 0 && this.myPatternArray[this.myPatternLength - 1 - index] != lastChar; --index) {
            }
            this.mySearchTable[lastChar] = step = this.myPatternLength - index - 1;
        }
        return -1;
    }

    public int scan(char[] text, int startOffset, int endOffset) {
        int res = this.scan(new CharArrayCharSequence(text), startOffset, endOffset);
        return res >= 0 ? res : -1;
    }
}

