/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import com.intellij.util.StringBuilderSpinAllocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiteralFormatUtil {
    private static final CharFilter UNDERSCORES_FILTER = new CharFilter(){

        @Override
        public boolean accept(char ch) {
            return ch != '_';
        }
    };

    private LiteralFormatUtil() {
    }

    @NotNull
    public static String removeUnderscores(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/LiteralFormatUtil.removeUnderscores must not be null");
        }
        String string = StringUtil.strip(text, UNDERSCORES_FILTER);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/LiteralFormatUtil.removeUnderscores must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String format(@NotNull String original, @Nullable PsiType type) {
        String string;
        if (original == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/LiteralFormatUtil.format must not be null");
        }
        boolean isFP = PsiType.FLOAT.equals(type) || PsiType.DOUBLE.equals(type);
        String text = original;
        String prefix = "";
        String suffix = "";
        int groupSize = 3;
        if (text.startsWith("0x") || text.startsWith("0X") || text.startsWith("0b") || text.startsWith("0B")) {
            prefix = text.substring(0, 2);
            text = text.substring(2);
            groupSize = 4;
        }
        if (text.length() == 0) {
            string = original;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/LiteralFormatUtil.format must not return null");
            return string;
        }
        char last = text.charAt(text.length() - 1);
        if (StringUtil.containsChar("Ll", last) || isFP && StringUtil.containsChar("FfDd", last)) {
            int pos = text.length() - 1;
            suffix = text.substring(pos);
            text = text.substring(0, pos);
        }
        if (text.length() == 0) {
            string = original;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/LiteralFormatUtil.format must not return null");
            return string;
        }
        boolean hasPoint = false;
        String fractional = "";
        String exponentMark = "";
        String exponent = "";
        if (isFP) {
            int pos = StringUtil.indexOfAny(text, "0x".equals(prefix) || "0X".equals(prefix) ? "Pp" : "Ee");
            if (pos >= 0) {
                int pos2 = Math.max(StringUtil.indexOfAny(text, "+-", pos, text.length()), pos) + 1;
                exponentMark = text.substring(pos, pos2);
                exponent = text.substring(pos2);
                text = text.substring(0, pos);
            }
            if ((pos = text.indexOf(46)) >= 0) {
                hasPoint = true;
                fractional = text.substring(pos + 1);
                text = text.substring(0, pos);
            }
        }
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        buffer.append(prefix);
        LiteralFormatUtil.appendFromEnd(buffer, text, groupSize);
        if (isFP) {
            if (hasPoint) {
                buffer.append('.');
            }
            LiteralFormatUtil.appendFromStart(buffer, fractional, groupSize);
            buffer.append(exponentMark);
            LiteralFormatUtil.appendFromEnd(buffer, exponent, 3);
        }
        buffer.append(suffix);
        String string2 = buffer.toString();
        string = string2;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/util/text/LiteralFormatUtil.format must not return null");
        finally {
            StringBuilderSpinAllocator.dispose(buffer);
        }
    }

    private static void appendFromEnd(StringBuilder buffer, String original, int groupSize) {
        int pointer;
        int position = buffer.length();
        for (pointer = original.length(); pointer > groupSize; pointer -= groupSize) {
            buffer.insert(position, original.substring(pointer - groupSize, pointer));
            buffer.insert(position, '_');
        }
        if (pointer > 0) {
            buffer.insert(position, original.substring(0, pointer));
        }
    }

    private static void appendFromStart(StringBuilder buffer, String original, int groupSize) {
        int pointer = 0;
        while (pointer + groupSize < original.length()) {
            buffer.append(original.substring(pointer, pointer + groupSize));
            buffer.append('_');
            pointer += groupSize;
        }
        if (pointer < original.length()) {
            buffer.append(original.substring(pointer));
        }
    }
}

