/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.TimedComputable;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.JarMemoryLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

class JarLoader
extends Loader {
    private final URL myURL;
    private SoftReference<JarMemoryLoader> myMemoryLoader;
    private final boolean myCanLockJar;
    private static final boolean myDebugTime = false;
    private static int misses;
    private static int hits;
    private static final Logger LOG;
    private final TimedComputable<ZipFile> myZipFileRef = new TimedComputable<ZipFile>(null){

        @Override
        @NotNull
        protected ZipFile calc() {
            ZipFile zipFile;
            try {
                ZipFile zipFile2 = JarLoader.this.doGetZipFile();
                if (zipFile2 == null) {
                    throw new RuntimeException("Can't load zip file");
                }
                zipFile = zipFile2;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (zipFile == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/lang/JarLoader$1.calc must not return null");
            }
            return zipFile;
        }
    };
    @NonNls
    private static final String JAR_PROTOCOL = "jar";
    @NonNls
    private static final String FILE_PROTOCOL = "file";
    private static final long NS_THRESHOLD = 10000000L;

    JarLoader(URL url, boolean canLockJar, int index) throws IOException {
        super(new URL(JAR_PROTOCOL, "", -1, url + "!/"), index);
        this.myURL = url;
        this.myCanLockJar = canLockJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preLoadClasses() {
        ZipFile zipFile = null;
        try {
            zipFile = this.acquireZipFile();
            if (zipFile == null) {
                return;
            }
            try {
                File file = new File(zipFile.getName());
                this.myMemoryLoader = new SoftReference<JarMemoryLoader>(JarMemoryLoader.load(file, this.getBaseURL()));
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                this.releaseZipFile(zipFile);
            }
            catch (IOException ignore) {}
        }
    }

    @Nullable
    private ZipFile acquireZipFile() throws IOException {
        if (this.myCanLockJar) {
            return this.myZipFileRef.acquire();
        }
        return this.doGetZipFile();
    }

    private void releaseZipFile(ZipFile zipFile) throws IOException {
        if (this.myCanLockJar) {
            this.myZipFileRef.release();
        } else if (zipFile != null) {
            zipFile.close();
        }
    }

    @Nullable
    private ZipFile doGetZipFile() throws IOException {
        if (FILE_PROTOCOL.equals(this.myURL.getProtocol())) {
            String s = FileUtil.unquote(this.myURL.getFile());
            if (!new File(s).exists()) {
                throw new FileNotFoundException(s);
            }
            return new ZipFile(s);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void buildCache(ClasspathCache cache) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = this.acquireZipFile();
            if (zipFile == null) {
                return;
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                cache.addResourceEntry(name, this);
                cache.addNameEntry(name, this);
            }
        }
        finally {
            this.releaseZipFile(zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    Resource getResource(String name, boolean flag) {
        Resource resource;
        JarMemoryLoader loader;
        long started = 0L;
        if (this.myMemoryLoader != null && (loader = this.myMemoryLoader.get()) != null && (resource = loader.getResource(name)) != null) {
            return resource;
        }
        ZipFile file = null;
        try {
            file = this.acquireZipFile();
            if (file == null) {
                resource = null;
                return resource;
            }
            ZipEntry entry = file.getEntry(name);
            if (entry != null) {
                if (++hits % 1000 == 0 && UrlClassLoader.doDebug) {
                    UrlClassLoader.debug("Exists jar loader: misses:" + misses + ", hits:" + hits);
                }
                MyResource myResource = new MyResource(entry, new URL(this.getBaseURL(), name));
                return myResource;
            }
            if (misses % 1000 == 0 && UrlClassLoader.doDebug) {
                UrlClassLoader.debug("Missed " + name + " from jar:" + this.myURL);
            }
            ++misses;
        }
        catch (Exception e) {
            Resource resource2 = null;
            return resource2;
        }
        finally {
            try {
                this.releaseZipFile(file);
            }
            catch (IOException ignored) {}
            long doneFor = 0L;
            if (doneFor > 10000000L) {
                System.out.println(doneFor / 1000000L + " ms for jar loader get resource:" + name);
            }
        }
        return null;
    }

    @NonNls
    public String toString() {
        return "JarLoader [" + this.myURL + "]";
    }

    static {
        LOG = Logger.getInstance(JarLoader.class);
    }

    private class MyResource
    extends Resource {
        private final ZipEntry myEntry;
        private final URL myUrl;

        public MyResource(ZipEntry name, URL url) {
            this.myEntry = name;
            this.myUrl = url;
        }

        public String getName() {
            return this.myEntry.getName();
        }

        public URL getURL() {
            return this.myUrl;
        }

        public URL getCodeSourceURL() {
            return JarLoader.this.myURL;
        }

        @Nullable
        public InputStream getInputStream() throws IOException {
            final boolean[] wasReleased = new boolean[]{false};
            ZipFile file = null;
            try {
                file = JarLoader.this.acquireZipFile();
                if (file == null) {
                    JarLoader.this.releaseZipFile(file);
                    return null;
                }
                InputStream inputStream = file.getInputStream(this.myEntry);
                if (inputStream == null) {
                    JarLoader.this.releaseZipFile(file);
                    return null;
                }
                final ZipFile finalFile = file;
                return new FilterInputStream(inputStream){
                    private boolean myClosed;
                    {
                        super(x0);
                        this.myClosed = false;
                    }

                    @Override
                    public void close() throws IOException {
                        super.close();
                        if (!this.myClosed) {
                            JarLoader.this.releaseZipFile(finalFile);
                        }
                        this.myClosed = true;
                        wasReleased[0] = true;
                    }
                };
            }
            catch (IOException e) {
                e.printStackTrace();
                JarLoader.this.releaseZipFile(file);
                assert (!wasReleased[0]);
                return null;
            }
        }

        public int getContentLength() {
            return (int)this.myEntry.getSize();
        }
    }
}

