/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DirectBufferWrapper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.NonNls;

public class ReadWriteDirectBufferWrapper
extends DirectBufferWrapper {
    @NonNls
    private static final String RW = "rw";

    protected ReadWriteDirectBufferWrapper(File file, long offset, long length) {
        super(file, offset, length);
        assert (length <= Integer.MAX_VALUE) : length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer create() throws IOException {
        RandomAccessFile file = new RandomAccessFile(this.myFile, RW);
        try {
            ByteBuffer byteBuffer;
            FileChannel channel = file.getChannel();
            try {
                channel.position(this.myPosition);
                ByteBuffer buffer = ByteBuffer.allocateDirect((int)this.myLength);
                channel.read(buffer);
                byteBuffer = buffer;
            }
            catch (Throwable throwable) {
                channel.close();
                throw throwable;
            }
            channel.close();
            return byteBuffer;
        }
        finally {
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer == null) {
            return;
        }
        try {
            RandomAccessFile file = new RandomAccessFile(this.myFile, RW);
            try {
                FileChannel channel = file.getChannel();
                try {
                    channel.position(this.myPosition);
                    buffer.rewind();
                    channel.write(buffer);
                }
                finally {
                    channel.close();
                }
            }
            finally {
                file.close();
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }
}

