/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.ShareableKey;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.LimitedInputStream;
import com.intellij.util.io.MappedFileInputStream;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.ResizeableMappedFile;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PersistentEnumeratorBase<Data>
implements Forceable,
Closeable {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.util.io.PersistentEnumerator");
    protected static final int NULL_ID = 0;
    private static final int META_DATA_OFFSET = 4;
    protected static final int DATA_START = 20;
    protected final ResizeableMappedFile myStorage;
    private final ResizeableMappedFile myKeyStorage;
    private boolean myClosed;
    private boolean myDirty;
    protected final KeyDescriptor<Data> myDataDescriptor;
    private static final CacheKey ourFlyweight = new FlyweightKey();
    protected final File myFile;
    private boolean myCorrupted;
    private final MyDataIS myKeyReadStream;
    private final Version myVersion;
    private RecordBufferHandler<PersistentEnumeratorBase> myRecordHandler;
    private volatile boolean myDirtyStatusUpdateInProgress;
    private Flushable myMarkCleanCallback;
    private final boolean myDoCaching;
    protected static final PagedFileStorage.StorageLock ourLock = new PagedFileStorage.StorageLock();
    private static final int ENUMERATION_CACHE_SIZE;
    private static final SLRUMap<Object, Integer> ourEnumerationCache;

    private static CacheKey sharedKey(Object key, PersistentEnumeratorBase owner) {
        PersistentEnumeratorBase.ourFlyweight.key = key;
        PersistentEnumeratorBase.ourFlyweight.owner = owner;
        return ourFlyweight;
    }

    public static void clearCacheForTests() {
        ourEnumerationCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentEnumeratorBase(@NotNull File file, @NotNull ResizeableMappedFile storage, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @NotNull Version version, @NotNull RecordBufferHandler<? extends PersistentEnumeratorBase> recordBufferHandler, boolean doCaching) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentEnumeratorBase.<init> must not be null");
        }
        if (storage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/io/PersistentEnumeratorBase.<init> must not be null");
        }
        if (dataDescriptor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/io/PersistentEnumeratorBase.<init> must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/util/io/PersistentEnumeratorBase.<init> must not be null");
        }
        if (recordBufferHandler == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/util/io/PersistentEnumeratorBase.<init> must not be null");
        }
        this.myClosed = false;
        this.myDirty = false;
        this.myCorrupted = false;
        this.myDataDescriptor = dataDescriptor;
        this.myFile = file;
        this.myVersion = version;
        this.myRecordHandler = recordBufferHandler;
        this.myDoCaching = doCaching;
        if (!file.exists()) {
            FileUtil.delete(this.keystreamFile());
            if (!FileUtil.createIfDoesntExist(file)) {
                throw new IOException("Cannot create empty file: " + file);
            }
        }
        this.myStorage = storage;
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            int sign;
            if (this.myStorage.length() == 0L) {
                try {
                    this.markDirty(true);
                    this.putMetaData(0L);
                    this.putMetaData2(0L);
                    this.setupEmptyFile();
                }
                catch (RuntimeException e) {
                    LOG.info(e);
                    this.myStorage.close();
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw e;
                }
                catch (IOException e) {
                    LOG.info(e);
                    this.myStorage.close();
                    throw e;
                }
                catch (Exception e) {
                    LOG.info(e);
                    this.myStorage.close();
                    throw new CorruptedException(file);
                }
            }
            try {
                sign = this.myStorage.getInt(0);
            }
            catch (Exception e) {
                LOG.info(e);
                sign = this.myVersion.dirtyMagic;
            }
            if (sign != this.myVersion.correctlyClosedMagic) {
                this.myStorage.close();
                throw new CorruptedException(file);
            }
        }
        if (this.myDataDescriptor instanceof InlineKeyDescriptor) {
            this.myKeyStorage = null;
            this.myKeyReadStream = null;
        } else {
            this.myKeyStorage = new ResizeableMappedFile(this.keystreamFile(), initialSize, ourLock);
            this.myKeyReadStream = new MyDataIS(this.myKeyStorage);
        }
    }

    protected abstract void setupEmptyFile() throws IOException;

    @NotNull
    public final RecordBufferHandler<PersistentEnumeratorBase> getRecordHandler() {
        RecordBufferHandler<PersistentEnumeratorBase> recordBufferHandler = this.myRecordHandler;
        if (recordBufferHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentEnumeratorBase.getRecordHandler must not return null");
        }
        return recordBufferHandler;
    }

    public void setRecordHandler(@NotNull RecordBufferHandler<PersistentEnumeratorBase> recordHandler) {
        if (recordHandler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/PersistentEnumeratorBase.setRecordHandler must not be null");
        }
        this.myRecordHandler = recordHandler;
    }

    public void setMarkCleanCallback(Flushable markCleanCallback) {
        this.myMarkCleanCallback = markCleanCallback;
    }

    public Data getValue(int keyId, int processingKey) throws IOException {
        return this.valueOf(keyId);
    }

    protected int tryEnumerate(Data value) throws IOException {
        return this.doEnumerate(value, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doEnumerate(Data value, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        int id;
        if (this.myDoCaching && !saveNewValue) {
            SLRUMap<Object, Integer> sLRUMap = ourEnumerationCache;
            synchronized (sLRUMap) {
                Integer cachedId = ourEnumerationCache.get(PersistentEnumeratorBase.sharedKey(value, this));
                if (cachedId != null) {
                    return cachedId;
                }
            }
        }
        try {
            id = this.enumerateImpl(value, onlyCheckForExisting, saveNewValue);
        }
        catch (IOException io) {
            this.markCorrupted();
            throw io;
        }
        catch (Throwable e) {
            this.markCorrupted();
            LOG.info(e);
            throw new IOException(e);
        }
        if (this.myDoCaching && id != 0) {
            SLRUMap<Object, Integer> sLRUMap = ourEnumerationCache;
            synchronized (sLRUMap) {
                ourEnumerationCache.put(new CacheKey(value, this), id);
            }
        }
        return id;
    }

    public int enumerate(Data value) throws IOException {
        return this.doEnumerate(value, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putMetaData(long data) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            this.myStorage.putLong(4, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getMetaData() throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            return this.myStorage.getLong(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putMetaData2(long data) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            this.myStorage.putLong(12, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getMetaData2() throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            return this.myStorage.getLong(12);
        }
    }

    public boolean processAllDataObject(final Processor<Data> processor, final @Nullable DataFilter filter) throws IOException {
        return this.traverseAllRecords(new RecordsProcessor(){

            @Override
            public boolean process(int record) throws IOException {
                if (filter == null || filter.accept(record)) {
                    return processor.process(PersistentEnumeratorBase.this.valueOf(record));
                }
                return true;
            }
        });
    }

    public Collection<Data> getAllDataObjects(@Nullable DataFilter filter) throws IOException {
        ArrayList values = new ArrayList();
        this.processAllDataObject(new CommonProcessors.CollectProcessor(values), filter);
        return values;
    }

    public abstract boolean traverseAllRecords(RecordsProcessor var1) throws IOException;

    protected abstract int enumerateImpl(Data var1, boolean var2, boolean var3) throws IOException;

    protected int writeData(Data value, int hashCode) {
        try {
            int dataOff;
            this.markDirty(true);
            int n = dataOff = this.myKeyStorage != null ? (int)this.myKeyStorage.length() : ((InlineKeyDescriptor)this.myDataDescriptor).toInt(value);
            if (this.myKeyStorage != null) {
                BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(bos);
                this.myDataDescriptor.save(out, value);
                this.myKeyStorage.put(dataOff, bos.getInternalBuffer(), 0, bos.size());
            }
            return this.setupValueId(hashCode, dataOff);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected int setupValueId(int hashCode, int dataOff) {
        byte[] buf = this.myRecordHandler.getRecordBuffer(this);
        this.myRecordHandler.setupRecord(this, hashCode, dataOff, buf);
        int pos = this.myRecordHandler.recordWriteOffset(this, buf);
        this.myStorage.put(pos, buf, 0, buf.length);
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean iterateData(Processor<Data> processor) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            boolean bl;
            if (this.myKeyStorage == null) {
                throw new UnsupportedOperationException("Iteration over InlineIntegerKeyDescriptors is not supported");
            }
            this.myKeyStorage.force();
            DataInputStream keysStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(new FileInputStream(this.keystreamFile()), (int)this.myKeyStorage.length())));
            try {
                Object key;
                while (processor.process(key = this.myDataDescriptor.read(keysStream))) {
                }
                bl = false;
            }
            catch (EOFException e) {
                boolean bl2 = true;
                keysStream.close();
                return bl2;
            }
            catch (Throwable throwable) {
                keysStream.close();
                throw throwable;
            }
            keysStream.close();
            return bl;
        }
    }

    private File keystreamFile() {
        return new File(this.myFile.getPath() + ".keystream");
    }

    public synchronized Data valueOf(int idx) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            try {
                int addr = this.indexToAddr(idx);
                if (this.myKeyReadStream == null) {
                    return (Data)((InlineKeyDescriptor)this.myDataDescriptor).fromInt(addr);
                }
                this.myKeyReadStream.setup(addr, this.myKeyStorage.length());
                return (Data)this.myDataDescriptor.read(this.myKeyReadStream);
            }
            catch (IOException io) {
                this.markCorrupted();
                throw io;
            }
            catch (Throwable e) {
                this.markCorrupted();
                throw new RuntimeException(e);
            }
        }
    }

    int reenumerate(Data key) throws IOException {
        if (!this.canReEnumerate()) {
            throw new IncorrectOperationException();
        }
        return this.doEnumerate(key, false, true);
    }

    boolean canReEnumerate() {
        return false;
    }

    protected abstract int indexToAddr(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            if (!this.myClosed) {
                this.myClosed = true;
                this.doClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws IOException {
        try {
            if (this.myKeyStorage != null) {
                this.myKeyStorage.close();
            }
            this.flush();
        }
        finally {
            this.myStorage.close();
        }
    }

    public synchronized boolean isClosed() {
        return this.myClosed;
    }

    @Override
    public synchronized boolean isDirty() {
        return this.myDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flush() throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            if (this.myStorage.isDirty() || this.isDirty()) {
                this.doFlush();
            }
        }
    }

    protected void doFlush() throws IOException {
        this.markDirty(false);
        this.myStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void force() {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            try {
                if (this.myKeyStorage != null) {
                    this.myKeyStorage.force();
                }
                this.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void markDirty(boolean dirty) throws IOException {
        if (dirty && this.myDirty && !this.myDirtyStatusUpdateInProgress) {
            return;
        }
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            if (this.myDirty) {
                if (!dirty) {
                    this.myDirtyStatusUpdateInProgress = true;
                    if (this.myMarkCleanCallback != null) {
                        this.myMarkCleanCallback.flush();
                    }
                    if (!this.myCorrupted) {
                        this.myStorage.putInt(0, this.myVersion.correctlyClosedMagic);
                        this.myDirty = false;
                    }
                    this.myDirtyStatusUpdateInProgress = false;
                }
            } else if (dirty) {
                this.myDirtyStatusUpdateInProgress = true;
                this.myStorage.putInt(0, this.myVersion.dirtyMagic);
                this.myDirtyStatusUpdateInProgress = false;
                this.myDirty = true;
            }
        }
    }

    protected synchronized void markCorrupted() {
        if (!this.myCorrupted) {
            this.myCorrupted = true;
            try {
                this.markDirty(true);
                this.force();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        String property = System.getProperty("idea.enumerationCacheSize");
        ENUMERATION_CACHE_SIZE = property == null ? 8192 : Integer.valueOf(property);
        ourEnumerationCache = new SLRUMap(ENUMERATION_CACHE_SIZE, ENUMERATION_CACHE_SIZE);
    }

    private static class FlyweightKey
    extends CacheKey {
        public FlyweightKey() {
            super(null, null);
        }

        @Override
        public ShareableKey getStableCopy() {
            return new CacheKey(this.key, this.owner);
        }
    }

    private static class MyBufferedIS
    extends BufferedInputStream {
        public MyBufferedIS(InputStream in) {
            super(in, 512);
        }

        public void setup(long pos, long limit) {
            this.pos = 0;
            this.count = 0;
            ((MappedFileInputStream)this.in).setup(pos, limit);
        }
    }

    private static class MyDataIS
    extends DataInputStream {
        private MyDataIS(ResizeableMappedFile raf) {
            super(new MyBufferedIS(new MappedFileInputStream(raf, 0L, 0L)));
        }

        public void setup(long pos, long limit) {
            ((MyBufferedIS)this.in).setup(pos, limit);
        }
    }

    public static abstract class RecordsProcessor {
        private int myKey;

        public abstract boolean process(int var1) throws IOException;

        void setCurrentKey(int key) {
            this.myKey = key;
        }

        int getCurrentKey() {
            return this.myKey;
        }
    }

    public static interface DataFilter {
        public boolean accept(int var1);
    }

    public static class CorruptedException
    extends IOException {
        public CorruptedException(File file) {
            super("PersistentEnumerator storage corrupted " + file.getPath());
        }
    }

    private static class CacheKey
    implements ShareableKey {
        public PersistentEnumeratorBase owner;
        public Object key;

        private CacheKey(Object key, PersistentEnumeratorBase owner) {
            this.key = key;
            this.owner = owner;
        }

        @Override
        public ShareableKey getStableCopy() {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.key.equals(cacheKey.key)) {
                return false;
            }
            return this.owner.equals(cacheKey.owner);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    public static abstract class RecordBufferHandler<T extends PersistentEnumeratorBase> {
        abstract int recordWriteOffset(T var1, byte[] var2);

        @NotNull
        abstract byte[] getRecordBuffer(T var1);

        abstract void setupRecord(T var1, int var2, int var3, byte[] var4);
    }

    public static class Version {
        private final int correctlyClosedMagic;
        private final int dirtyMagic;

        public Version(int _correctlyClosedMagic, int _dirtyMagic) {
            this.correctlyClosedMagic = _correctlyClosedMagic;
            this.dirtyMagic = _dirtyMagic;
            assert (this.correctlyClosedMagic != this.dirtyMagic);
        }
    }
}

