/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.Semaphore;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public abstract class OutputReader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.OutputReader");
    private final Reader myReader;
    private volatile boolean isStopped;
    private final Semaphore myReadFullySemaphore;
    private final Future<?> myFinishedFuture;
    private final char[] myBuffer;
    private boolean skipLF;

    public OutputReader(@NotNull Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/OutputReader.<init> must not be null");
        }
        this.isStopped = false;
        this.myReadFullySemaphore = new Semaphore();
        this.myBuffer = new char[8192];
        this.skipLF = false;
        this.myReader = reader;
        this.myFinishedFuture = this.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                OutputReader.this.doRun();
            }
        });
    }

    protected abstract Future<?> executeOnPooledThread(Runnable var1);

    private void doRun() {
        try {
            while (true) {
                boolean read;
                if (!(read = this.readAvailable())) {
                    this.myReadFullySemaphore.up();
                }
                if (this.isStopped) {
                    this.myReader.close();
                    break;
                }
                Thread.sleep(read ? 1L : 5L);
            }
        }
        catch (InterruptedException ignore) {
        }
        catch (IOException e) {
            LOG.info(e);
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    private synchronized boolean readAvailable() throws IOException {
        int n;
        char[] buffer = this.myBuffer;
        StringBuilder token = new StringBuilder();
        boolean read = false;
        while (this.myReader.ready() && (n = this.myReader.read(buffer)) > 0) {
            read = true;
            for (int i = 0; i < n; ++i) {
                char c = buffer[i];
                if (this.skipLF && c != '\n') {
                    token.append('\r');
                }
                if (c == '\r') {
                    this.skipLF = true;
                } else {
                    this.skipLF = false;
                    token.append(c);
                }
                if (c != '\n') continue;
                this.onTextAvailable(token.toString());
                token.setLength(0);
            }
        }
        if (token.length() != 0) {
            this.onTextAvailable(token.toString());
            token.setLength(0);
        }
        return read;
    }

    protected abstract void onTextAvailable(@NotNull String var1);

    public void readFully() throws InterruptedException {
        this.myReadFullySemaphore.down();
        while (!this.myReadFullySemaphore.waitForUnsafe(10L)) {
            if (!this.isStopped) continue;
            this.waitFor();
            return;
        }
    }

    public void stop() {
        this.isStopped = true;
    }

    public void waitFor() throws InterruptedException {
        try {
            this.myFinishedFuture.get();
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
    }
}

