/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.ByteBufferWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class DirectBufferWrapper
extends ByteBufferWrapper {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.util.io.DirectBufferWrapper");
    private volatile ByteBuffer myBuffer;

    protected DirectBufferWrapper(File file, long offset, long length) {
        super(file, offset, length);
    }

    @Override
    public ByteBuffer getCachedBuffer() {
        return this.myBuffer;
    }

    @Override
    public ByteBuffer getBuffer() throws IOException {
        ByteBuffer buffer = this.myBuffer;
        if (buffer == null) {
            this.myBuffer = buffer = this.create();
        }
        return buffer;
    }

    protected abstract ByteBuffer create() throws IOException;

    @Override
    public void unmap() {
        this.flush();
        this.myBuffer = null;
    }
}

