/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ReadOnlyMappedBufferWrapper;
import com.intellij.util.io.ReadWriteDirectBufferWrapper;
import com.intellij.util.io.ReadWriteMappedBufferWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.Nullable;

public abstract class ByteBufferWrapper {
    public static final boolean NO_MMAP = "true".equals(System.getProperty("idea.io.use.direct"));
    protected final File myFile;
    protected final long myPosition;
    protected final long myLength;

    protected ByteBufferWrapper(File file, long offset, long length) {
        this.myFile = file;
        this.myPosition = offset;
        this.myLength = length;
    }

    @Nullable
    public abstract ByteBuffer getCachedBuffer();

    public abstract ByteBuffer getBuffer() throws IOException;

    public abstract void unmap();

    public abstract void flush();

    public void dispose() {
        this.unmap();
    }

    public static ByteBufferWrapper readWrite(File file, int offset, int length) {
        return NO_MMAP ? new ReadWriteDirectBufferWrapper(file, offset, length) : new ReadWriteMappedBufferWrapper(file, offset, length);
    }

    public static ByteBufferWrapper readOnly(File file, int offset) {
        return new ReadOnlyMappedBufferWrapper(file, offset);
    }
}

