/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.IntHashEntry;
import com.intellij.util.containers.IntSegment;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StripedLockIntObjectConcurrentHashMap<V>
extends IntSegment<V> {
    static int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public StripedLockIntObjectConcurrentHashMap(int initialCapacity, float loadFactor) {
        super(StripedLockIntObjectConcurrentHashMap.getInitCap(initialCapacity, loadFactor), loadFactor);
    }

    private static int getInitCap(int initialCapacity, float loadFactor) {
        int cap;
        if (loadFactor <= 0.0f || initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        for (cap = 1; cap < initialCapacity; cap <<= 1) {
        }
        return cap;
    }

    public StripedLockIntObjectConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public StripedLockIntObjectConcurrentHashMap() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int size() {
        return this.count;
    }

    public V put(int key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.put(key, value, false);
    }

    public V putIfAbsent(int key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.put(key, value, true);
    }

    public V remove(int key) {
        return (V)this.remove(key, null);
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    static final class SimpleEntry<V>
    implements IntEntry<V> {
        int key;
        V value;

        public SimpleEntry(IntEntry<V> e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleEntry)) {
                return false;
            }
            SimpleEntry e = (SimpleEntry)o;
            int o2 = e.getKey();
            return this.key == o2 && this.eq(this.value, e.getValue());
        }

        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return StripedLockIntObjectConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return StripedLockIntObjectConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            StripedLockIntObjectConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList();
            for (Object k : this) {
                c.add(k);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList();
            for (Object k : this) {
                c.add(k);
            }
            return c.toArray(a);
        }
    }

    static interface IntEntry<V> {
        public int getKey();

        public V getValue();

        public V setValue(V var1);
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }

        @Override
        public V nextElement() {
            return this.nextEntry().value;
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex = 0;
        int nextTableIndex = -1;
        IntHashEntry[] currentTable;
        IntHashEntry<V> nextEntry;
        IntHashEntry<V> lastReturned;

        HashIterator() {
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                StripedLockIntObjectConcurrentHashMap seg = StripedLockIntObjectConcurrentHashMap.this;
                --this.nextSegmentIndex;
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j = this.currentTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        IntHashEntry<V> nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            StripedLockIntObjectConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }
}

