/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers._CHMSegment;
import gnu.trove.TObjectHashingStrategy;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StripedLockConcurrentHashMap<K, V>
extends _CHMSegment<K, V>
implements ConcurrentMap<K, V> {
    static int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static <K, V> StripedLockConcurrentHashMap<K, V> createWithStrategy(final @NotNull TObjectHashingStrategy<K> hashingStrategy, int initialCapacity) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.createWithStrategy must not be null");
        }
        return new StripedLockConcurrentHashMap<K, V>(initialCapacity){

            @Override
            protected TObjectHashingStrategy<K> getHashingStrategy() {
                return hashingStrategy;
            }
        };
    }

    public StripedLockConcurrentHashMap(int initialCapacity) {
        super(StripedLockConcurrentHashMap.getInitCap(initialCapacity, 0.75f));
    }

    private static int getInitCap(int initialCapacity, float loadFactor) {
        int cap;
        if (loadFactor <= 0.0f || initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        for (cap = 1; cap < initialCapacity; cap <<= 1) {
        }
        return cap;
    }

    public StripedLockConcurrentHashMap() {
        this(DEFAULT_INITIAL_CAPACITY);
    }

    public StripedLockConcurrentHashMap(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.<init> must not be null");
        }
        this(Math.max((int)((float)t.size() / 0.75f) + 1, 11));
        this.putAll(t);
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.get must not be null");
        }
        Object kKey = key;
        int hash = this.getHashingStrategy().computeHashCode(kKey);
        return this.get(kKey, hash);
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.containsKey must not be null");
        }
        Object kKey = key;
        int hash = this.getHashingStrategy().computeHashCode(kKey);
        return this.containsKey(kKey, hash);
    }

    public boolean contains(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.contains must not be null");
        }
        return this.containsValue(value);
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.put must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.put must not be null");
        }
        int hash = this.getHashingStrategy().computeHashCode(key);
        return this.put(key, hash, value, false);
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.putIfAbsent must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.putIfAbsent must not be null");
        }
        int hash = this.getHashingStrategy().computeHashCode(key);
        return this.put(key, hash, value, true);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.putAll must not be null");
        }
        for (Map.Entry<K, V> e : t.entrySet()) {
            V value = e.getValue();
            if (value == null) continue;
            this.put(e.getKey(), value);
        }
    }

    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.remove must not be null");
        }
        Object kKey = key;
        int hash = this.getHashingStrategy().computeHashCode(kKey);
        return this.remove(kKey, hash, null);
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.remove must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.remove must not be null");
        }
        Object kKey = key;
        int hash = this.getHashingStrategy().computeHashCode(kKey);
        return this.remove(kKey, hash, value) != null;
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.replace must not be null");
        }
        if (oldValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.replace must not be null");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.replace must not be null");
        }
        int hash = this.getHashingStrategy().computeHashCode(key);
        return this.replace(key, hash, oldValue, newValue);
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.replace must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap.replace must not be null");
        }
        int hash = this.getHashingStrategy().computeHashCode(key);
        return this.replace(key, hash, value);
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    static class CanonicalHashingStrategy<K>
    implements TObjectHashingStrategy<K> {
        private static final CanonicalHashingStrategy INSTANCE = new CanonicalHashingStrategy();

        CanonicalHashingStrategy() {
        }

        static <K> CanonicalHashingStrategy<K> getInstance() {
            return INSTANCE;
        }

        public int computeHashCode(K object) {
            int h = object.hashCode();
            return h;
        }

        public boolean equals(@NotNull K o1, @NotNull K o2) {
            if (o1 == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap$CanonicalHashingStrategy.equals must not be null");
            }
            if (o2 == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap$CanonicalHashingStrategy.equals must not be null");
            }
            return o1.equals(o2);
        }
    }

    final class SimpleEntry
    implements Map.Entry<K, V> {
        final K key;
        V value;

        public SimpleEntry(Map.Entry<K, V> e) {
            if (e == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap$SimpleEntry.<init> must not be null");
            }
            this.key = e.getKey();
            this.value = e.getValue();
        }

        @Override
        @NotNull
        public K getKey() {
            Object k = this.key;
            if (k == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/StripedLockConcurrentHashMap$SimpleEntry.getKey must not return null");
            }
            return k;
        }

        @Override
        @NotNull
        public V getValue() {
            Object v = this.value;
            if (v == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/StripedLockConcurrentHashMap$SimpleEntry.getValue must not return null");
            }
            return v;
        }

        @Override
        public V setValue(@NotNull V value) {
            if (value == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap$SimpleEntry.setValue must not be null");
            }
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object o2 = e.getKey();
            return StripedLockConcurrentHashMap.this.getHashingStrategy().equals(this.key, o2) && this.value.equals(e.getValue());
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = StripedLockConcurrentHashMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return StripedLockConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return StripedLockConcurrentHashMap.this.size();
        }

        @Override
        public void clear() {
            StripedLockConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<SimpleEntry> c = new ArrayList<SimpleEntry>(this.size());
            for (Map.Entry i : this) {
                c.add(new SimpleEntry(i));
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList<SimpleEntry> c = new ArrayList<SimpleEntry>(this.size());
            for (Map.Entry i : this) {
                c.add(new SimpleEntry(i));
            }
            return c.toArray(a);
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return StripedLockConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return StripedLockConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            StripedLockConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList();
            for (Object k : this) {
                c.add(k);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList();
            for (Object k : this) {
                c.add(k);
            }
            return c.toArray(a);
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return StripedLockConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return StripedLockConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return StripedLockConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            StripedLockConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList();
            for (Object k : this) {
                c.add(k);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList();
            for (Object k : this) {
                c.add(k);
            }
            return c.toArray(a);
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Map.Entry<K, V>,
    Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        @NotNull
        public Map.Entry<K, V> next() {
            this.nextEntry();
            EntryIterator entryIterator = this;
            if (entryIterator == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/StripedLockConcurrentHashMap$EntryIterator.next must not return null");
            }
            return entryIterator;
        }

        @Override
        @NotNull
        public K getKey() {
            if (this.lastReturned == null) {
                throw new IllegalStateException("Entry was removed");
            }
            Object k = this.lastReturned.key;
            if (k == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/StripedLockConcurrentHashMap$EntryIterator.getKey must not return null");
            }
            return k;
        }

        @Override
        @Nullable(value="null means the entry has just been removed")
        public V getValue() {
            if (this.lastReturned == null) {
                throw new IllegalStateException("Entry was removed");
            }
            return StripedLockConcurrentHashMap.this.get(this.lastReturned.key);
        }

        @Override
        public V setValue(@NotNull V value) {
            if (value == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StripedLockConcurrentHashMap$EntryIterator.setValue must not be null");
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Entry was removed");
            }
            return StripedLockConcurrentHashMap.this.put(this.lastReturned.key, value);
        }

        @Override
        public boolean equals(Object o) {
            if (this.lastReturned == null) {
                return super.equals(o);
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object o1 = this.getKey();
            Object o2 = e.getKey();
            return StripedLockConcurrentHashMap.this.getHashingStrategy().equals(o1, o2) && this.getValue().equals(e.getValue());
        }

        @Override
        public int hashCode() {
            if (this.lastReturned == null) {
                return super.hashCode();
            }
            Object k = this.getKey();
            Object v = this.getValue();
            return k.hashCode() ^ v.hashCode();
        }

        public String toString() {
            if (this.lastReturned == null) {
                return super.toString();
            }
            return this.getKey() + "=" + this.getValue();
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator() {
        }

        @Override
        @NotNull
        public V next() {
            Object v = this.nextEntry().value;
            if (v == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/StripedLockConcurrentHashMap$ValueIterator.next must not return null");
            }
            return v;
        }

        @Override
        @NotNull
        public V nextElement() {
            Object v = this.nextEntry().value;
            if (v == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/StripedLockConcurrentHashMap$ValueIterator.nextElement must not return null");
            }
            return v;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator() {
        }

        @Override
        @NotNull
        public K next() {
            Object k = this.nextEntry().key;
            if (k == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/StripedLockConcurrentHashMap$KeyIterator.next must not return null");
            }
            return k;
        }

        @Override
        @NotNull
        public K nextElement() {
            Object k = this.nextEntry().key;
            if (k == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/StripedLockConcurrentHashMap$KeyIterator.nextElement must not return null");
            }
            return k;
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex = 0;
        int nextTableIndex = -1;
        _CHMSegment.HashEntry[] currentTable;
        _CHMSegment.HashEntry<K, V> nextEntry;
        _CHMSegment.HashEntry<K, V> lastReturned;

        HashIterator() {
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                StripedLockConcurrentHashMap seg = StripedLockConcurrentHashMap.this;
                --this.nextSegmentIndex;
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j = this.currentTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        _CHMSegment.HashEntry<K, V> nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            StripedLockConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }
}

