/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.reference.SoftReference;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class SoftHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private Map<Key<K>, V> myMap;
    private final ReferenceQueue<K> myReferenceQueue = new ReferenceQueue();
    private final HardKey<K> myHardKeyInstance = new HardKey<Object>(null);
    private Set<Map.Entry<K, V>> entrySet;

    private void processQueue() {
        SoftKey wk;
        while ((wk = (SoftKey)this.myReferenceQueue.poll()) != null) {
            this.myMap.remove(wk);
        }
    }

    public SoftHashMap(int initialCapacity, float loadFactor) {
        this.myMap = new THashMap(initialCapacity, loadFactor);
    }

    public SoftHashMap(int initialCapacity) {
        this.myMap = new THashMap(initialCapacity);
    }

    public SoftHashMap() {
        this.myMap = new THashMap();
    }

    public SoftHashMap(final TObjectHashingStrategy<K> hashingStrategy) {
        this.myMap = new THashMap(new TObjectHashingStrategy<Key<K>>(){

            public int computeHashCode(Key<K> object) {
                return hashingStrategy.computeHashCode(object.get());
            }

            public boolean equals(Key<K> o1, Key<K> o2) {
                return hashingStrategy.equals(o1.get(), o2.get());
            }
        });
    }

    public SoftHashMap(Map<? extends K, ? extends V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.myMap.containsKey(null);
        }
        this.myHardKeyInstance.set(key);
        boolean result = this.myMap.containsKey(this.myHardKeyInstance);
        this.myHardKeyInstance.set(null);
        return result;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.myMap.get(null);
        }
        this.myHardKeyInstance.set(key);
        V result = this.myMap.get(this.myHardKeyInstance);
        this.myHardKeyInstance.set(null);
        return result;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        SoftKey keyWrapper = SoftKey.create(key, this.myReferenceQueue);
        return this.myMap.put(keyWrapper, value);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        if (key == null) {
            return this.myMap.remove(null);
        }
        this.myHardKeyInstance.set(key);
        V result = this.myMap.remove(this.myHardKeyInstance);
        this.myHardKeyInstance.set(null);
        return result;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        Set<Map.Entry<Key<K>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = SoftHashMap.this.myMap.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Iterator<Map.Entry<Key<K>, V>> hashIterator;
                Entry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        Key wk = ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object k2 = wk.get();
                            k = k2;
                            if (k2 == null) continue;
                        }
                        this.next = new Entry(ent, k);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            SoftHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            SoftHashMap.this.myHardKeyInstance.set(o);
            HardKey key = SoftHashMap.this.myHardKeyInstance;
            Object hv = SoftHashMap.this.myMap.get(key);
            boolean bl = hv == null ? ev == null && SoftHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
            if (toRemove) {
                SoftHashMap.this.myMap.remove(key);
            }
            SoftHashMap.this.myHardKeyInstance.set(null);
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry ent : this.hashEntrySet) {
                SoftKey wk = (SoftKey)ent.getKey();
                if (wk == null) continue;
                Object v = ent.getValue();
                h += wk.hashCode() ^ (v == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;

        Entry(Map.Entry<?, V> ent, K key) {
            this.ent = ent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.ent.setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Comparing.equal(this.key, e.getKey()) && Comparing.equal(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
    }

    private static class HardKey<T>
    implements Key<T> {
        private T myObject;
        private int myHash;

        public HardKey(T object) {
            this.set(object);
        }

        @Override
        public T get() {
            return this.myObject;
        }

        public void set(T object) {
            this.myObject = object;
            this.myHash = object == null ? 0 : object.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            T t = this.get();
            Object u = ((Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }

        public String toString() {
            return "SoftHashMap.HardKey(" + this.get() + ")";
        }
    }

    private static class SoftKey<T>
    extends SoftReference<T>
    implements Key<T> {
        private final int myHash;

        private SoftKey(T k, ReferenceQueue<? super T> q) {
            super(k, q);
            this.myHash = k.hashCode();
        }

        private static <V> SoftKey<V> create(V k, ReferenceQueue<? super V> q) {
            return k != null ? new SoftKey<V>(k, q) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }

        public String toString() {
            return "SoftHashMap.SoftKey(" + this.get() + ")";
        }
    }

    private static interface Key<T> {
        public T get();
    }
}

