/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MostlySingularMultiMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 2784448345881807109L;
    private final Map<K, Object> myMap = new THashMap();

    public void add(K key, V value) {
        Object current = this.myMap.get(key);
        if (current == null) {
            this.myMap.put(key, value);
        } else if (current instanceof Object[]) {
            Object[] curArr = (Object[])current;
            Object[] newArr = ArrayUtil.append(curArr, value, ArrayUtil.OBJECT_ARRAY_FACTORY);
            this.myMap.put(key, newArr);
        } else {
            this.myMap.put(key, new Object[]{current, value});
        }
    }

    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public boolean processForKey(K key, Processor<V> p) {
        return this.processValue(p, this.myMap.get(key));
    }

    private boolean processValue(Processor<V> p, Object v) {
        if (v instanceof Object[]) {
            for (Object o : (Object[])v) {
                if (p.process(o)) continue;
                return false;
            }
        } else if (v != null) {
            return p.process(v);
        }
        return true;
    }

    public boolean processAllValues(Processor<V> p) {
        for (Object v : this.myMap.values()) {
            if (this.processValue(p, v)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.myMap.size();
    }

    public int valuesForKey(K key) {
        Object current = this.myMap.get(key);
        if (current == null) {
            return 0;
        }
        if (current instanceof Object[]) {
            return ((Object[])current).length;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Iterable<V> get(K name) {
        Collection<Object> collection;
        Object value = this.myMap.get(name);
        if (value == null) {
            collection = Collections.emptyList();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/MostlySingularMultiMap.get must not return null");
            return collection;
        }
        if (value instanceof Object[]) {
            collection = Arrays.asList((Object[])value);
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/MostlySingularMultiMap.get must not return null");
            return collection;
        }
        collection = Collections.singleton(value);
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/util/containers/MostlySingularMultiMap.get must not return null");
    }

    public String toString() {
        return "{" + StringUtil.join(this.myMap.entrySet(), new Function<Map.Entry<K, Object>, String>(){

            @Override
            public String fun(Map.Entry<K, Object> entry) {
                Object value = entry.getValue();
                String s = (value instanceof Object[] ? Arrays.asList((Object[])value) : Arrays.asList(value)).toString();
                return entry.getKey() + ": " + s;
            }
        }, "; ") + "}";
    }
}

