/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.intellij.util.containers.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class ConcurrentSLRUMap<K, V> {
    protected final ConcurrentMap<K, V> myProtectedQueue;
    protected final ConcurrentMap<K, V> myProbationalQueue;
    private final AtomicInteger probationalHits = new AtomicInteger();
    private final AtomicInteger protectedHits = new AtomicInteger();
    private final AtomicInteger misses = new AtomicInteger();

    public ConcurrentSLRUMap(int protectedQueueSize, int probationalQueueSize) {
        this.myProtectedQueue = CacheBuilder.newBuilder().concurrencyLevel(4).removalListener(new RemovalListener<K, V>(){

            public void onRemoval(RemovalNotification<K, V> notification) {
                ConcurrentSLRUMap.this.myProbationalQueue.put(notification.getKey(), notification.getValue());
            }
        }).initialCapacity(10).maximumSize((long)protectedQueueSize).build().asMap();
        this.myProbationalQueue = CacheBuilder.newBuilder().concurrencyLevel(4).removalListener(new RemovalListener<K, V>(){

            public void onRemoval(RemovalNotification<K, V> notification) {
                ConcurrentSLRUMap.this.onDropFromCache(notification.getKey(), notification.getValue());
            }
        }).initialCapacity(10).maximumSize((long)probationalQueueSize).build().asMap();
    }

    @Nullable
    public V get(K key) {
        Object value = this.myProtectedQueue.get(key);
        if (value != null) {
            this.protectedHits.incrementAndGet();
            return value;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            this.probationalHits.incrementAndGet();
            this.myProtectedQueue.put(key, value);
            return value;
        }
        this.misses.incrementAndGet();
        return null;
    }

    public void put(K key, V value) {
        Object oldValue = this.myProtectedQueue.remove(key);
        if (oldValue != null) {
            this.onDropFromCache(key, oldValue);
        }
        if ((oldValue = this.myProbationalQueue.put(key, value)) != null) {
            this.onDropFromCache(key, oldValue);
        }
    }

    protected void onDropFromCache(K key, V value) {
    }

    public boolean remove(K key) {
        Object value = this.myProtectedQueue.remove(key);
        if (value != null) {
            this.onDropFromCache(key, value);
            return true;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            this.onDropFromCache(key, value);
            return true;
        }
        return false;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        HashSet set = new HashSet(this.myProtectedQueue.entrySet());
        set.addAll(this.myProbationalQueue.entrySet());
        return set;
    }

    public void clear() {
        for (Map.Entry entry : this.myProtectedQueue.entrySet()) {
            this.onDropFromCache(entry.getKey(), entry.getValue());
        }
        this.myProtectedQueue.clear();
        for (Map.Entry entry : this.myProbationalQueue.entrySet()) {
            this.onDropFromCache(entry.getKey(), entry.getValue());
        }
        this.myProbationalQueue.clear();
    }
}

