/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Nullable;

public class FutureResult<T>
implements Future<T> {
    private final Semaphore mySema = new Semaphore(0);
    private volatile Ref<Pair<Object, Boolean>> myValue;

    public void reset() {
        this.mySema.drainPermits();
        this.myValue = null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.myValue != null;
    }

    public void set(@Nullable T result) {
        assert (this.myValue == null);
        this.myValue = Ref.create(Pair.create(result, true));
        this.mySema.release();
    }

    public void setException(Throwable e) {
        assert (this.myValue == null);
        this.myValue = Ref.create(Pair.create(e, false));
        this.mySema.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.mySema.acquire();
        try {
            T t = this.doGet();
            return t;
        }
        finally {
            this.mySema.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.mySema.tryAcquire(timeout, unit)) {
            throw new TimeoutException();
        }
        try {
            T t = this.doGet();
            return t;
        }
        finally {
            this.mySema.release();
        }
    }

    private T doGet() throws ExecutionException {
        Pair<Object, Boolean> pair = this.myValue.get();
        if (!((Boolean)pair.second).booleanValue()) {
            throw new ExecutionException(((Throwable)pair.first).getMessage(), (Throwable)pair.first);
        }
        return (T)pair.first;
    }
}

