/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Future<T>> invokeAll(@NotNull Collection<Callable<T>> tasks, ExecutorService executorService) throws Throwable {
        if (tasks == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.invokeAll must not be null");
        }
        if (executorService == null) {
            for (Callable<T> task : tasks) {
                task.call();
            }
            return null;
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> callable : tasks) {
                Future<T> future = executorService.submit(callable);
                futures.add(future);
            }
            for (Future future : futures) {
                ((Runnable)((Object)future)).run();
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) continue;
                    throw cause;
                }
            }
            done = true;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(false);
                }
            }
        }
        return futures;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <K, V> V cacheOrGet(@NotNull ConcurrentMap<K, V> map, @NotNull K key, @NotNull V defaultValue) {
        Object v;
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.cacheOrGet must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.cacheOrGet must not be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.cacheOrGet must not be null");
        }
        Object v2 = map.get(key);
        if (v2 != null) {
            v = v2;
            if (v == null) throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.cacheOrGet must not return null");
            return v;
        }
        V prev = map.putIfAbsent(key, defaultValue);
        v = prev == null ? defaultValue : prev;
        if (v != null) return v;
        throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.cacheOrGet must not return null");
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NotNull @NonNls String threadFactoryName) {
        if (threadFactoryName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.newSingleThreadExecutor must not be null");
        }
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor(threadFactoryName, 5);
        if (threadPoolExecutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.newSingleThreadExecutor must not return null");
        }
        return threadPoolExecutor;
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(final @NotNull String threadFactoryName, final int threadPriority) {
        if (threadFactoryName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.newSingleThreadExecutor must not be null");
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, threadFactoryName);
                thread.setDaemon(true);
                thread.setPriority(threadPriority);
                return thread;
            }
        });
        if (threadPoolExecutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.newSingleThreadExecutor must not return null");
        }
        return threadPoolExecutor;
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NotNull @NonNls String threadFactoryName) {
        if (threadFactoryName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.newSingleScheduledThreadExecutor must not be null");
        }
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = ConcurrencyUtil.newSingleScheduledThreadExecutor(threadFactoryName, 5);
        if (scheduledThreadPoolExecutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.newSingleScheduledThreadExecutor must not return null");
        }
        return scheduledThreadPoolExecutor;
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(final @NotNull String threadFactoryName, final int threadPriority) {
        if (threadFactoryName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.newSingleScheduledThreadExecutor must not be null");
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, threadFactoryName);
                thread.setDaemon(true);
                thread.setPriority(threadPriority);
                return thread;
            }
        });
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = executor;
        if (scheduledThreadPoolExecutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.newSingleScheduledThreadExecutor must not return null");
        }
        return scheduledThreadPoolExecutor;
    }
}

