/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.mac.foundation.FoundationLibrary;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.containers.HashMap;
import com.sun.jna.Callback;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Foundation {
    private static final FoundationLibrary myFoundationLibrary;
    static Callback ourRunnableCallback;
    private static Map<String, RunnableInfo> ourMainThreadRunnables;
    private static long ourCurrentRunnableCount;
    private static final Object RUNNABLE_LOCK;

    public static void init() {
    }

    private Foundation() {
    }

    public static ID getObjcClass(String className) {
        return myFoundationLibrary.objc_getClass(className);
    }

    public static ID getProtocol(String name) {
        return myFoundationLibrary.objc_getProtocol(name);
    }

    public static Pointer createSelector(String s) {
        return myFoundationLibrary.sel_registerName(s);
    }

    public static ID invoke(ID id, Pointer selector, Object ... args) {
        return myFoundationLibrary.objc_msgSend(id, selector, args);
    }

    public static ID invoke(String cls, String selector, Object ... args) {
        return Foundation.invoke(Foundation.getObjcClass(cls), Foundation.createSelector(selector), args);
    }

    public static ID invoke(ID id, String selector, Object ... args) {
        return Foundation.invoke(id, Foundation.createSelector(selector), args);
    }

    public static ID allocateObjcClassPair(ID superCls, String name) {
        return myFoundationLibrary.objc_allocateClassPair(superCls, name, 0);
    }

    public static void registerObjcClassPair(ID cls) {
        myFoundationLibrary.objc_registerClassPair(cls);
    }

    public static boolean isClassRespondsToSelector(ID cls, Pointer selectorName) {
        return myFoundationLibrary.class_respondsToSelector(cls, selectorName);
    }

    public static boolean addMethod(ID cls, Pointer selectorName, Callback impl, String types) {
        return myFoundationLibrary.class_addMethod(cls, selectorName, impl, types);
    }

    public static boolean addProtocol(ID aClass, ID protocol) {
        return myFoundationLibrary.class_addProtocol(aClass, protocol);
    }

    public static boolean addMethodByID(ID cls, Pointer selectorName, ID impl, String types) {
        return myFoundationLibrary.class_addMethod(cls, selectorName, impl, types);
    }

    public static boolean isMetaClass(ID cls) {
        return myFoundationLibrary.class_isMetaClass(cls);
    }

    @Nullable
    public static String stringFromSelector(Pointer selector) {
        ID id = myFoundationLibrary.NSStringFromSelector(selector);
        if (id.intValue() > 0) {
            return Foundation.toStringViaUTF8(id);
        }
        return null;
    }

    public static Pointer getClass(Pointer clazz) {
        return myFoundationLibrary.objc_getClass(clazz);
    }

    public static String fullUserName() {
        return Foundation.toStringViaUTF8(myFoundationLibrary.NSFullUserName());
    }

    public static ID class_replaceMethod(ID cls, Pointer selector, Callback impl, String types) {
        return myFoundationLibrary.class_replaceMethod(cls, selector, impl, types);
    }

    public static ID getMetaClass(String className) {
        return myFoundationLibrary.objc_getMetaClass(className);
    }

    public static boolean isPackageAtPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/mac/foundation/Foundation.isPackageAtPath must not be null");
        }
        ID workspace = Foundation.invoke("NSWorkspace", "sharedWorkspace", new Object[0]);
        ID result = Foundation.invoke(workspace, Foundation.createSelector("isFilePackageAtPath:"), new Object[]{Foundation.nsString(path)});
        return result.intValue() == 1;
    }

    public static boolean isPackageAtPath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/mac/foundation/Foundation.isPackageAtPath must not be null");
        }
        if (!file.isDirectory()) {
            return false;
        }
        return Foundation.isPackageAtPath(file.getPath());
    }

    public static ID nsString(String s) {
        try {
            if (s.length() == 0) {
                return Foundation.invoke("NSString", "string", new Object[0]);
            }
            byte[] utf16Bytes = s.getBytes("UTF-16LE");
            return Foundation.invoke(Foundation.invoke("NSString", "alloc", new Object[0]), "initWithBytes:length:encoding:", utf16Bytes, utf16Bytes.length, myFoundationLibrary.CFStringConvertEncodingToNSStringEncoding(0x14000100));
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException(x);
        }
    }

    @Nullable
    public static String toStringViaUTF8(ID cfString) {
        if (cfString.intValue() == 0) {
            return null;
        }
        int lengthInChars = myFoundationLibrary.CFStringGetLength(cfString);
        int potentialLengthInBytes = 3 * lengthInChars + 1;
        byte[] buffer = new byte[potentialLengthInBytes];
        byte ok = myFoundationLibrary.CFStringGetCString(cfString, buffer, buffer.length, 0x8000100);
        if (ok == 0) {
            throw new RuntimeException("Could not convert string");
        }
        return Native.toString((byte[])buffer);
    }

    @Nullable
    public static String getEncodingName(long nsStringEncoding) {
        int cfEncoding = myFoundationLibrary.CFStringConvertNSStringEncodingToEncoding(nsStringEncoding);
        ID pointer = myFoundationLibrary.CFStringConvertEncodingToIANACharSetName(cfEncoding);
        return Foundation.toStringViaUTF8(pointer);
    }

    public static long getEncodingCode(@Nullable String encodingName) {
        if (StringUtil.isEmptyOrSpaces(encodingName)) {
            return -1L;
        }
        ID converted = Foundation.nsString(encodingName);
        int cfEncoding = myFoundationLibrary.CFStringConvertIANACharSetNameToEncoding(converted);
        if (cfEncoding == -1) {
            return -1L;
        }
        return myFoundationLibrary.CFStringConvertEncodingToNSStringEncoding(cfEncoding);
    }

    public static void cfRetain(ID id) {
        myFoundationLibrary.CFRetain(id);
    }

    public static void cfRelease(ID ... ids) {
        for (ID id : ids) {
            if (id == null) continue;
            myFoundationLibrary.CFRelease(id);
        }
    }

    public static boolean isMainThread() {
        return Foundation.invoke("NSThread", "isMainThread", new Object[0]).intValue() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeOnMainThread(Runnable runnable, boolean withAutoreleasePool, boolean waitUntilDone) {
        Foundation.initRunnableSupport();
        Object object = RUNNABLE_LOCK;
        synchronized (object) {
            ourMainThreadRunnables.put(String.valueOf(++ourCurrentRunnableCount), new RunnableInfo(runnable, withAutoreleasePool));
        }
        ID ideaRunnable = Foundation.getObjcClass("IdeaRunnable");
        ID runnableObject = Foundation.invoke(Foundation.invoke(ideaRunnable, "alloc", new Object[0]), "init", new Object[0]);
        Foundation.invoke(runnableObject, "performSelectorOnMainThread:withObject:waitUntilDone:", new Object[]{Foundation.createSelector("run:"), Foundation.nsString(String.valueOf(ourCurrentRunnableCount)), waitUntilDone});
        Foundation.invoke(runnableObject, "release", new Object[0]);
    }

    private static void initRunnableSupport() {
        if (ourRunnableCallback == null) {
            ID runnableClass = Foundation.allocateObjcClassPair(Foundation.getObjcClass("NSObject"), "IdeaRunnable");
            Foundation.registerObjcClassPair(runnableClass);
            Callback callback = new Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void callback(ID self, String selector, ID keyObject) {
                    RunnableInfo info;
                    String key = Foundation.toStringViaUTF8(keyObject);
                    Object object = RUNNABLE_LOCK;
                    synchronized (object) {
                        info = (RunnableInfo)ourMainThreadRunnables.remove(key);
                    }
                    if (info == null) {
                        return;
                    }
                    ID pool = null;
                    try {
                        if (info.myUseAutoreleasePool) {
                            pool = Foundation.invoke("NSAutoreleasePool", "new", new Object[0]);
                        }
                        info.myRunnable.run();
                    }
                    finally {
                        if (pool != null) {
                            Foundation.invoke(pool, "release", new Object[0]);
                        }
                    }
                }
            };
            if (!Foundation.addMethod(runnableClass, Foundation.createSelector("run:"), callback, "v@:*")) {
                throw new RuntimeException("Unable to add method to objective-c runnableClass class!");
            }
            ourRunnableCallback = callback;
        }
    }

    static {
        System.setProperty("jna.encoding", "UTF8");
        HashMap foundationOptions = new HashMap();
        myFoundationLibrary = (FoundationLibrary)Native.loadLibrary((String)"Foundation", FoundationLibrary.class, foundationOptions);
        ourMainThreadRunnables = new HashMap<String, RunnableInfo>();
        ourCurrentRunnableCount = 0L;
        RUNNABLE_LOCK = new Object();
    }

    public static class NSAutoreleasePool {
        private ID myDelegate = Foundation.invoke(Foundation.invoke("NSAutoreleasePool", "alloc", new Object[0]), "init", new Object[0]);

        public void drain() {
            Foundation.invoke(this.myDelegate, "drain", new Object[0]);
        }
    }

    public static class NSArray {
        private ID myDelegate;

        public NSArray(ID delegate) {
            this.myDelegate = delegate;
        }

        public int count() {
            return Foundation.invoke(this.myDelegate, "count", new Object[0]).intValue();
        }

        public ID at(int index) {
            return Foundation.invoke(this.myDelegate, "objectAtIndex:", index);
        }
    }

    public static class NSDictionary {
        private ID myDelegate;

        public NSDictionary(ID delegate) {
            this.myDelegate = delegate;
        }

        public ID get(ID key) {
            return Foundation.invoke(this.myDelegate, "objectForKey:", new Object[]{key});
        }

        public ID get(String key) {
            return this.get(Foundation.nsString(key));
        }

        public int count() {
            return Foundation.invoke(this.myDelegate, "count", new Object[0]).intValue();
        }
    }

    static class RunnableInfo {
        Runnable myRunnable;
        boolean myUseAutoreleasePool;

        RunnableInfo(Runnable runnable, boolean useAutoreleasePool) {
            this.myRunnable = runnable;
            this.myUseAutoreleasePool = useAutoreleasePool;
        }
    }
}

