/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.SwingActionWrapper;
import com.intellij.util.ui.ItemRemovable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class TableUtil {
    private TableUtil() {
    }

    public static List<Object[]> removeSelectedItems(JTable table) {
        return TableUtil.removeSelectedItems(table, null);
    }

    public static void selectRows(JTable table, int[] viewRows) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.clearSelection();
        int count = table.getRowCount();
        for (int row : viewRows) {
            if (row < 0 || row >= count) continue;
            selectionModel.addSelectionInterval(row, row);
        }
    }

    public static void scrollSelectionToVisible(JTable table) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        int maxColumnSelectionIndex = Math.max(0, table.getColumnModel().getSelectionModel().getMinSelectionIndex());
        int minColumnSelectionIndex = Math.max(0, table.getColumnModel().getSelectionModel().getMaxSelectionIndex());
        if (maxSelectionIndex == -1) {
            return;
        }
        Rectangle minCellRect = table.getCellRect(minSelectionIndex, minColumnSelectionIndex, false);
        Rectangle maxCellRect = table.getCellRect(maxSelectionIndex, maxColumnSelectionIndex, false);
        Point selectPoint = minCellRect.getLocation();
        int allHeight = maxCellRect.y + maxCellRect.height - minCellRect.y;
        allHeight = Math.min(allHeight, table.getVisibleRect().height);
        table.scrollRectToVisible(new Rectangle(selectPoint, new Dimension(minCellRect.width / 2, allHeight)));
    }

    public static List<Object[]> removeSelectedItems(JTable table, ItemChecker applyable) {
        TableModel model;
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
        if (!((model = table.getModel()) instanceof ItemRemovable)) {
            throw new RuntimeException("model must be instance of ItemRemovable");
        }
        ListSelectionModel selectionModel = table.getSelectionModel();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        if (minSelectionIndex == -1) {
            return new ArrayList<Object[]>(0);
        }
        LinkedList<Object[]> removedItems = new LinkedList<Object[]>();
        int columnCount = model.getColumnCount();
        for (int idx = table.getRowCount() - 1; idx >= 0; --idx) {
            if (!selectionModel.isSelectedIndex(idx) || applyable != null && !applyable.isOperationApplyable(model, idx)) continue;
            Object[] row = new Object[columnCount];
            for (int column = 0; column < columnCount; ++column) {
                row[column] = model.getValueAt(idx, column);
            }
            removedItems.add(0, row);
            ((ItemRemovable)((Object)model)).removeRow(idx);
        }
        int count = model.getRowCount();
        if (count == 0) {
            table.clearSelection();
        } else if (table.getSelectedRow() == -1) {
            if (minSelectionIndex >= model.getRowCount()) {
                selectionModel.setSelectionInterval(model.getRowCount() - 1, model.getRowCount() - 1);
            } else {
                selectionModel.setSelectionInterval(minSelectionIndex, minSelectionIndex);
            }
        }
        return removedItems;
    }

    public static int moveSelectedItemsUp(JTable table) {
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
        TableModel model = table.getModel();
        ListSelectionModel selectionModel = table.getSelectionModel();
        int counter = 0;
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (!selectionModel.isSelectedIndex(row)) continue;
            ++counter;
            for (int column = 0; column < model.getColumnCount(); ++column) {
                Object temp = model.getValueAt(row, column);
                model.setValueAt(model.getValueAt(row - 1, column), row, column);
                model.setValueAt(temp, row - 1, column);
            }
            selectionModel.removeSelectionInterval(row, row);
            selectionModel.addSelectionInterval(row - 1, row - 1);
        }
        Rectangle cellRect = table.getCellRect(selectionModel.getMinSelectionIndex(), 0, true);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
        table.repaint();
        return counter;
    }

    public static int moveSelectedItemsDown(JTable table) {
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
        TableModel model = table.getModel();
        ListSelectionModel selectionModel = table.getSelectionModel();
        int counter = 0;
        for (int row = model.getRowCount() - 1; row >= 0; --row) {
            if (!selectionModel.isSelectedIndex(row)) continue;
            ++counter;
            for (int column = 0; column < model.getColumnCount(); ++column) {
                Object temp = model.getValueAt(row, column);
                model.setValueAt(model.getValueAt(row + 1, column), row, column);
                model.setValueAt(temp, row + 1, column);
            }
            selectionModel.removeSelectionInterval(row, row);
            selectionModel.addSelectionInterval(row + 1, row + 1);
        }
        Rectangle cellRect = table.getCellRect(selectionModel.getMaxSelectionIndex(), 0, true);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
        table.repaint();
        return counter;
    }

    public static void editCellAt(JTable table, int row, int column) {
        Component component;
        if (table.editCellAt(row, column) && (component = table.getEditorComponent()) != null) {
            component.requestFocus();
        }
    }

    public static void stopEditing(JTable table) {
        if (table.isEditing()) {
            TableCellEditor editor;
            TableCellEditor cellEditor = table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            int row = table.getSelectedRow();
            int column = table.getSelectedColumn();
            if (row >= 0 && column >= 0 && (editor = table.getCellEditor(row, column)) != null) {
                editor.stopCellEditing();
            }
        }
    }

    public static void ensureSelectionExists(JTable table) {
        if (table.getSelectedRow() != -1 || table.getRowCount() == 0) {
            return;
        }
        table.setRowSelectionInterval(0, 0);
    }

    public static void configureAllowedCellSelection(JTable table, Condition<Point> cellCondition) {
        for (String keyStroke : new String[]{"ENTER", "TAB", "shift TAB", "RIGHT", "LEFT", "UP", "DOWN"}) {
            Object key = SwingActionWrapper.getKeyForActionMap(table, KeyStroke.getKeyStroke(keyStroke));
            if (key == null) continue;
            new MyFocusAction(table, cellCondition, key);
        }
    }

    public static class MyFocusAction
    extends SwingActionWrapper<JTable> {
        private final Condition<Point> myCellCondition;

        public MyFocusAction(JTable table, Condition<Point> cellCondition, Object key) {
            super(table, key);
            this.myCellCondition = cellCondition;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)this.getComponent();
            int originalRow = table.getSelectedRow();
            int originalColumn = table.getSelectedColumn();
            this.getDelegate().actionPerformed(e);
            Point coord = new Point(table.getSelectedColumn(), table.getSelectedRow());
            while (!this.myCellCondition.value(coord)) {
                this.getDelegate().actionPerformed(e);
                if (coord.y == table.getSelectedRow() && coord.x == table.getSelectedColumn()) {
                    table.changeSelection(originalRow, originalColumn, false, false);
                    break;
                }
                coord.y = table.getSelectedRow();
                coord.x = table.getSelectedColumn();
                if (coord.y != originalRow || coord.x != originalColumn) continue;
                break;
            }
        }
    }

    public static interface ItemChecker {
        public boolean isOperationApplyable(TableModel var1, int var2);
    }
}

