/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.Colored;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorUtil {
    private ColorUtil() {
    }

    private static int shift(int colorComponent, double d) {
        int n = (int)((double)colorComponent * d);
        return n > 255 ? 255 : (n < 0 ? 0 : n);
    }

    public static Color shift(Color c, double d) {
        return new Color(ColorUtil.shift(c.getRed(), d), ColorUtil.shift(c.getGreen(), d), ColorUtil.shift(c.getBlue(), d), c.getAlpha());
    }

    public static Color withAlpha(Color c, double a) {
        return ColorUtil.toAlpha(c, (int)(255.0 * a));
    }

    public static Color toAlpha(Color color, int a) {
        Color c = color != null ? color : Color.black;
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
    }

    public static Color withAlphaAdjustingDarkness(Color c, double d) {
        return ColorUtil.shift(ColorUtil.withAlpha(c, d), d);
    }

    public static String toHex(@NotNull Color c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/ColorUtil.toHex must not be null");
        }
        String R = Integer.toHexString(c.getRed());
        String G = Integer.toHexString(c.getGreen());
        String B = Integer.toHexString(c.getBlue());
        return (R.length() < 2 ? "0" : "") + R + (G.length() < 2 ? "0" : "") + G + (B.length() < 2 ? "0" : "") + B;
    }

    public static Color fromHex(String str) {
        if (str.startsWith("#")) {
            str = str.substring(1);
        }
        if (str.length() == 3) {
            return new Color(17 * Integer.valueOf(String.valueOf(str.charAt(0)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(1)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(2)), 16));
        }
        if (str.length() == 6) {
            return Color.decode("0x" + str);
        }
        throw new IllegalArgumentException("Should be String of 3 or 6 chars length.");
    }

    @Nullable
    public static Color fromHex(String str, @Nullable Color defaultValue) {
        try {
            return ColorUtil.fromHex(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Nullable
    public static Color getColor(@NotNull Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/ColorUtil.getColor must not be null");
        }
        Colored annotation = cls.getAnnotation(Colored.class);
        if (annotation instanceof Colored) {
            return ColorUtil.fromHex(annotation.color(), null);
        }
        return null;
    }

    public static boolean isDark(@NotNull Color c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/ColorUtil.isDark must not be null");
        }
        return 1.0 - (0.299 * (double)c.getRed() + 0.587 * (double)c.getGreen() + 0.114 * (double)c.getBlue()) / 255.0 >= 0.5;
    }
}

