/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.SubstitutedFileType;
import org.jetbrains.annotations.Nullable;

public class StubTreeBuilder {
    private static final Key<StubElement> stubElementKey = Key.create("stub.tree.for.file.content");

    private StubTreeBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static StubElement buildStubTree(FileContent inputData) {
        StubElement data = inputData.getUserData(stubElementKey);
        if (data != null) {
            return data;
        }
        FileContent fileContent = inputData;
        synchronized (fileContent) {
            data = inputData.getUserData(stubElementKey);
            if (data != null) {
                return data;
            }
            FileType fileType = inputData.getFileType();
            if (fileType.isBinary()) {
                BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
                assert (builder != null);
                data = builder.buildStubTree(inputData.getFile(), inputData.getContent(), inputData.getProject());
            } else {
                LanguageFileType filetype = (LanguageFileType)fileType;
                Language l = filetype.getLanguage();
                IFileElementType type = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l)).getFileNodeType();
                PsiFile psi = inputData.getPsiFile();
                CharSequence contentAsText = inputData.getContentAsText();
                psi.putUserData(StubTreeLoader.FILE_TEXT_CONTENT_KEY, contentAsText);
                try {
                    if (type instanceof IStubFileElementType) {
                        data = ((IStubFileElementType)type).getBuilder().buildStubTree(psi);
                    } else if (filetype instanceof SubstitutedFileType) {
                        SubstitutedFileType substituted = (SubstitutedFileType)filetype;
                        LanguageFileType original = (LanguageFileType)substituted.getOriginalFileType();
                        IFileElementType originalType = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(original.getLanguage())).getFileNodeType();
                        data = ((IStubFileElementType)originalType).getBuilder().buildStubTree(psi);
                    }
                }
                finally {
                    psi.putUserData(StubTreeLoader.FILE_TEXT_CONTENT_KEY, null);
                }
            }
            inputData.putUserData(stubElementKey, data);
            return data;
        }
    }
}

