/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiNameValuePairImpl
extends CompositePsiElement
implements PsiNameValuePair {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl");
    private volatile String myCachedName = null;
    private volatile PsiIdentifier myCachedNameIdentifier = null;
    private volatile PsiAnnotationMemberValue myCachedValue = null;
    private volatile boolean myNameCached = false;

    @Override
    public void clearCaches() {
        this.myNameCached = false;
        this.myCachedName = null;
        this.myCachedNameIdentifier = null;
        this.myCachedValue = null;
        super.clearCaches();
    }

    public PsiNameValuePairImpl() {
        super(JavaElementType.NAME_VALUE_PAIR);
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier cachedNameIdentifier = this.myCachedNameIdentifier;
        if (!this.myNameCached) {
            this.myCachedNameIdentifier = cachedNameIdentifier = (PsiIdentifier)this.findChildByRoleAsPsiElement(9);
            this.myCachedName = cachedNameIdentifier == null ? null : cachedNameIdentifier.getText();
            this.myNameCached = true;
        }
        return cachedNameIdentifier;
    }

    @Override
    public String getName() {
        String cachedName = this.myCachedName;
        if (!this.myNameCached) {
            PsiIdentifier identifier;
            this.myCachedNameIdentifier = identifier = (PsiIdentifier)this.findChildByRoleAsPsiElement(9);
            cachedName = identifier == null ? null : identifier.getText();
            this.myCachedName = cachedName;
            this.myNameCached = true;
        }
        return cachedName;
    }

    @Override
    public PsiAnnotationMemberValue getValue() {
        PsiAnnotationMemberValue cachedValue = this.myCachedValue;
        if (cachedValue == null) {
            this.myCachedValue = cachedValue = (PsiAnnotationMemberValue)this.findChildByRoleAsPsiElement(249);
        }
        return cachedValue;
    }

    @Override
    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl.setValue must not be null");
        }
        this.getValue().replace(newValue);
        PsiAnnotationMemberValue psiAnnotationMemberValue = this.getValue();
        if (psiAnnotationMemberValue == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl.setValue must not return null");
        }
        return psiAnnotationMemberValue;
    }

    @Override
    public int getChildRole(ASTNode child) {
        if (ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(child.getElementType())) {
            return 249;
        }
        if (child.getElementType() == JavaTokenType.IDENTIFIER) {
            return 9;
        }
        if (child.getElementType() == JavaTokenType.EQ) {
            return 63;
        }
        return 0;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        if (role == 9) {
            return this.findChildByType(JavaTokenType.IDENTIFIER);
        }
        if (role == 249) {
            return this.findChildByType(ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET);
        }
        if (role == 63) {
            return this.findChildByType(JavaTokenType.EQ);
        }
        return null;
    }

    @Override
    public String toString() {
        return "PsiNameValuePair";
    }

    @Override
    public PsiReference getReference() {
        return new PsiReference(){

            @Nullable
            private PsiClass getReferencedClass() {
                LOG.assertTrue(PsiNameValuePairImpl.this.getParent() instanceof PsiAnnotationParameterList && PsiNameValuePairImpl.this.getParent().getParent() instanceof PsiAnnotation);
                PsiAnnotation annotation = (PsiAnnotation)PsiNameValuePairImpl.this.getParent().getParent();
                PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
                if (nameRef == null) {
                    return null;
                }
                PsiElement target = nameRef.resolve();
                return target instanceof PsiClass ? (PsiClass)target : null;
            }

            @Override
            public PsiElement getElement() {
                PsiIdentifier nameIdentifier = PsiNameValuePairImpl.this.getNameIdentifier();
                if (nameIdentifier != null) {
                    return nameIdentifier;
                }
                return PsiNameValuePairImpl.this;
            }

            @Override
            public TextRange getRangeInElement() {
                PsiIdentifier id = PsiNameValuePairImpl.this.getNameIdentifier();
                if (id != null) {
                    return new TextRange(0, id.getTextLength());
                }
                return TextRange.EMPTY_RANGE;
            }

            @Override
            public PsiElement resolve() {
                PsiClass refClass = this.getReferencedClass();
                if (refClass == null) {
                    return null;
                }
                String name = PsiNameValuePairImpl.this.getName();
                if (name == null) {
                    name = "value";
                }
                MethodSignature signature = MethodSignatureUtil.createMethodSignature(name, PsiType.EMPTY_ARRAY, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
                return MethodSignatureUtil.findMethodBySignature(refClass, signature, false);
            }

            @Override
            @NotNull
            public String getCanonicalText() {
                String name = PsiNameValuePairImpl.this.getName();
                String string = name != null ? name : "value";
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1.getCanonicalText must not return null");
                }
                return string;
            }

            @Override
            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                PsiIdentifier nameIdentifier = PsiNameValuePairImpl.this.getNameIdentifier();
                if (nameIdentifier != null) {
                    PsiImplUtil.setName(nameIdentifier, newElementName);
                } else if (ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(PsiNameValuePairImpl.this.getFirstChildNode().getElementType())) {
                    PsiElementFactory factory = JavaPsiFacade.getInstance(PsiNameValuePairImpl.this.getProject()).getElementFactory();
                    nameIdentifier = factory.createIdentifier(newElementName);
                    PsiNameValuePairImpl.this.addBefore(nameIdentifier, SourceTreeToPsiMap.treeElementToPsi(PsiNameValuePairImpl.this.getFirstChildNode()));
                }
                return PsiNameValuePairImpl.this;
            }

            @Override
            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1.bindToElement must not be null");
                }
                throw new IncorrectOperationException("Not implemented");
            }

            @Override
            public boolean isReferenceTo(PsiElement element) {
                return element instanceof PsiMethod && element.equals(this.resolve());
            }

            @Override
            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1.getVariants must not return null");
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            @Override
            public boolean isSoft() {
                return false;
            }
        };
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitNameValuePair(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        TreeElement treeElement = super.addInternal(first, last, anchor, before);
        if (first == last && first.getElementType() == JavaTokenType.IDENTIFIER) {
            LeafElement eq = Factory.createSingleLeafElement(JavaTokenType.EQ, "=", 0, 1, treeCharTab, this.getManager());
            super.addInternal(eq, eq, first, Boolean.FALSE);
        }
        return treeElement;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode sign;
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl.deleteChildInternal must not be null");
        }
        super.deleteChildInternal(child);
        if (child.getElementType() == JavaTokenType.IDENTIFIER && (sign = this.findChildByRole(63)) != null) {
            super.deleteChildInternal(sign);
        }
    }
}

