/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ConstraintType;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import com.intellij.psi.impl.source.resolve.ResolveVariableUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiResolveHelperImpl
implements PsiResolveHelper {
    static final RecursionGuard ourGuard = RecursionManager.createGuard("typeArgInference");
    private final PsiManager myManager;
    private static final Pair<PsiType, ConstraintType> FAILED_INFERENCE = new Pair<PsiPrimitiveType, ConstraintType>(PsiType.NULL, ConstraintType.EQUALS);

    public PsiResolveHelperImpl(PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public JavaResolveResult resolveConstructor(PsiClassType classType, PsiExpressionList argumentList, PsiElement place) {
        JavaResolveResult[] result = this.multiResolveConstructor(classType, argumentList, place);
        JavaResolveResult javaResolveResult = result.length == 1 ? result[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.resolveConstructor must not return null");
        }
        return javaResolveResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult[] multiResolveConstructor(PsiClassType type, PsiExpressionList argumentList, PsiElement place) {
        MethodResolverProcessor processor;
        JavaResolveResult[] javaResolveResultArray;
        PsiClassType.ClassResolveResult classResolveResult = type.resolveGenerics();
        PsiClass aClass = classResolveResult.getElement();
        if (aClass == null) {
            javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            if (JavaResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.multiResolveConstructor must not return null");
            return javaResolveResultArray;
        }
        PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
        if (argumentList.getParent() instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymous = (PsiAnonymousClass)argumentList.getParent();
            processor = new MethodResolverProcessor(anonymous, argumentList, place);
            aClass = anonymous.getBaseClassType().resolve();
            if (aClass == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
                if (JavaResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.multiResolveConstructor must not return null");
                return javaResolveResultArray;
            }
            substitutor = substitutor.putAll(TypeConversionUtil.getSuperClassSubstitutor(aClass, anonymous, substitutor));
        } else {
            processor = new MethodResolverProcessor(aClass, argumentList, place);
        }
        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor);
        for (PsiMethod constructor : aClass.getConstructors()) {
            if (!processor.execute(constructor, state)) break;
        }
        javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray != null) return javaResolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.multiResolveConstructor must not return null");
    }

    @Override
    public PsiClass resolveReferencedClass(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.resolveReferencedClass must not be null");
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            return ResolveClassUtil.resolveClass(ref);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public PsiVariable resolveReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.resolveReferencedVariable must not be null");
        }
        return this.resolveVar(referenceText, context, null);
    }

    @Override
    public PsiVariable resolveAccessibleReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.resolveAccessibleReferencedVariable must not be null");
        }
        boolean[] problemWithAccess = new boolean[1];
        PsiVariable variable = this.resolveVar(referenceText, context, problemWithAccess);
        return problemWithAccess[0] ? null : variable;
    }

    @Nullable
    private PsiVariable resolveVar(String referenceText, PsiElement context, boolean[] problemWithAccess) {
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            return ResolveVariableUtil.resolveVariable(ref, problemWithAccess, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.isAccessible must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.isAccessible must not be null");
        }
        return this.isAccessible(member, member.getModifierList(), place, accessObjectClass, null);
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member, PsiModifierList modifierList, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, PsiElement currentFileResolveScope) {
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.isAccessible must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.isAccessible must not be null");
        }
        return JavaResolveUtil.isAccessible(member, member.getContainingClass(), modifierList, place, accessObjectClass, currentFileResolveScope);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public CandidateInfo[] getReferencedMethodCandidates(PsiCallExpression expr, boolean dummyImplicitConstructor) {
        CandidateInfo[] candidateInfoArray;
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(expr);
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, expr, dummyImplicitConstructor);
        }
        catch (MethodProcessorSetupFailedException e) {
            candidateInfoArray = CandidateInfo.EMPTY_ARRAY;
            if (CandidateInfo.EMPTY_ARRAY != null) return candidateInfoArray;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.getReferencedMethodCandidates must not return null");
        }
        CandidateInfo[] candidateInfoArray2 = processor.getCandidates();
        candidateInfoArray = candidateInfoArray2;
        if (candidateInfoArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.getReferencedMethodCandidates must not return null");
        return candidateInfoArray;
    }

    private static Pair<PsiType, ConstraintType> inferTypeForMethodTypeParameterInner(PsiTypeParameter typeParameter, PsiParameter[] parameters, PsiExpression[] arguments, PsiSubstitutor partialSubstitutor, PsiElement parent, ParameterTypeInferencePolicy policy) {
        Pair<PsiType, ConstraintType> constraint;
        PsiType wildcardToCapture = null;
        PsiType lowerBound = PsiType.NULL;
        PsiType upperBound = PsiType.NULL;
        if (parameters.length > 0) {
            block5: for (int j = 0; j < arguments.length; ++j) {
                Pair<PsiType, ConstraintType> currentSubstitution;
                PsiExpression argument = arguments[j];
                if (argument instanceof PsiMethodCallExpression && ourGuard.currentStack().contains(argument)) continue;
                PsiParameter parameter = parameters[Math.min(j, parameters.length - 1)];
                if (j >= parameters.length && !parameter.isVarArgs()) break;
                PsiType parameterType = parameter.getType();
                PsiType argumentType = argument.getType();
                if (argumentType == null) continue;
                if (parameterType instanceof PsiEllipsisType) {
                    parameterType = ((PsiEllipsisType)parameterType).getComponentType();
                    if (arguments.length == parameters.length && argumentType instanceof PsiArrayType && !(((PsiArrayType)argumentType).getComponentType() instanceof PsiPrimitiveType)) {
                        argumentType = ((PsiArrayType)argumentType).getComponentType();
                    }
                }
                if ((currentSubstitution = PsiResolveHelperImpl.getSubstitutionForTypeParameterConstraint(typeParameter, parameterType, argumentType, true, PsiUtil.getLanguageLevel(argument))) == null) continue;
                if (currentSubstitution == FAILED_INFERENCE) {
                    return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                }
                ConstraintType constraintType = currentSubstitution.getSecond();
                PsiType type = currentSubstitution.getFirst();
                if (type == null) {
                    return new Pair<Object, ConstraintType>(null, ConstraintType.EQUALS);
                }
                switch (constraintType) {
                    case EQUALS: {
                        if (!(type instanceof PsiWildcardType)) {
                            return currentSubstitution;
                        }
                        if (wildcardToCapture != null) {
                            return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                        }
                        wildcardToCapture = (PsiWildcardType)type;
                        continue block5;
                    }
                    case SUPERTYPE: {
                        if (PsiType.NULL.equals(lowerBound)) {
                            lowerBound = type;
                            continue block5;
                        }
                        if (((Object)lowerBound).equals(type) || (lowerBound = GenericsUtil.getLeastUpperBound(lowerBound, type, typeParameter.getManager())) != null) continue block5;
                        return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                    }
                    case SUBTYPE: {
                        if (!PsiType.NULL.equals(upperBound) && !TypeConversionUtil.isAssignable(upperBound, type)) continue block5;
                        upperBound = type;
                    }
                }
            }
        }
        if (wildcardToCapture != null) {
            if (lowerBound != PsiType.NULL) {
                if (!wildcardToCapture.isAssignableFrom(lowerBound)) {
                    return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                }
                if (((PsiWildcardType)wildcardToCapture).isSuper()) {
                    return new Pair<PsiType, ConstraintType>(wildcardToCapture, ConstraintType.SUPERTYPE);
                }
                lowerBound = GenericsUtil.getLeastUpperBound(lowerBound, wildcardToCapture, typeParameter.getManager());
            } else {
                if (upperBound != PsiType.NULL && !upperBound.isAssignableFrom(wildcardToCapture)) {
                    return PsiResolveHelperImpl.getFailedInferenceConstraint(typeParameter);
                }
                return new Pair<PsiType, ConstraintType>(wildcardToCapture, ConstraintType.EQUALS);
            }
        }
        if (lowerBound != PsiType.NULL) {
            return new Pair<PsiType, ConstraintType>(lowerBound, ConstraintType.EQUALS);
        }
        if (parent != null && (constraint = PsiResolveHelperImpl.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent, policy)) != null) {
            if (constraint.getSecond() != ConstraintType.SUBTYPE) {
                return constraint;
            }
            if (upperBound != PsiType.NULL) {
                return new Pair<PsiType, ConstraintType>(upperBound, ConstraintType.SUBTYPE);
            }
            return constraint;
        }
        if (upperBound != PsiType.NULL) {
            return new Pair<PsiType, ConstraintType>(upperBound, ConstraintType.SUBTYPE);
        }
        return null;
    }

    private static Pair<PsiType, ConstraintType> getFailedInferenceConstraint(PsiTypeParameter typeParameter) {
        return new Pair<PsiType, ConstraintType>(JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter), ConstraintType.EQUALS);
    }

    @Override
    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, PsiElement parent, ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeForMethodTypeParameter must not be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeForMethodTypeParameter must not be null");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeForMethodTypeParameter must not be null");
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeForMethodTypeParameter must not be null");
        }
        Pair<PsiType, ConstraintType> constraint = PsiResolveHelperImpl.inferTypeForMethodTypeParameterInner(typeParameter, parameters, arguments, partialSubstitutor, parent, policy);
        if (constraint == null) {
            return PsiType.NULL;
        }
        return constraint.getFirst();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, ParameterTypeInferencePolicy policy) {
        PsiSubstitutor psiSubstitutor;
        PsiTypeParameter typeParameter;
        if (typeParameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeArguments must not be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeArguments must not be null");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeArguments must not be null");
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeArguments must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeArguments must not be null");
        }
        PsiType[] substitutions = new PsiType[typeParameters.length];
        Pair[] constraints = new Pair[typeParameters.length];
        for (int i = 0; i < typeParameters.length; ++i) {
            Pair<PsiType, ConstraintType> constraint;
            constraints[i] = constraint = PsiResolveHelperImpl.inferTypeForMethodTypeParameterInner(typeParameters[i], parameters, arguments, partialSubstitutor, null, policy);
            if (constraint == null || constraint.getSecond() == ConstraintType.SUBTYPE) continue;
            substitutions[i] = constraint.getFirst();
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(parent);
        PsiManager manager = parent.getManager();
        int i = 0;
        while (true) {
            block24: {
                void var13_14;
                block25: {
                    block23: {
                        if (i >= typeParameters.length) break block23;
                        typeParameter = typeParameters[i];
                        if (substitutions[i] != null) break block24;
                        PsiPrimitiveType psiPrimitiveType = PsiType.NULL;
                        break block25;
                    }
                    for (i = 0; i < typeParameters.length; ++i) {
                        typeParameter = typeParameters[i];
                        PsiType psiType = substitutions[i];
                        if (psiType == PsiType.NULL) continue;
                        partialSubstitutor = partialSubstitutor.put(typeParameter, psiType);
                    }
                    break;
                }
                block3: for (int j = 0; j < typeParameters.length; ++j) {
                    PsiClassType[] bounds;
                    if (i == j) continue;
                    PsiTypeParameter other = typeParameters[j];
                    PsiType otherSubstitution = substitutions[j];
                    if (otherSubstitution == null) continue;
                    for (PsiClassType bound : bounds = other.getExtendsListTypes()) {
                        void var13_16;
                        PsiType substitutedBound = partialSubstitutor.substitute(bound);
                        Pair<PsiType, ConstraintType> currentConstraint = PsiResolveHelperImpl.getSubstitutionForTypeParameterConstraint(typeParameter, substitutedBound, otherSubstitution, true, languageLevel);
                        if (currentConstraint == null) continue;
                        PsiType currentSubstitution = currentConstraint.getFirst();
                        ConstraintType currentConstraintType = currentConstraint.getSecond();
                        if (currentConstraintType == ConstraintType.EQUALS) {
                            PsiType psiType = currentSubstitution;
                            break block3;
                        }
                        if (currentConstraintType != ConstraintType.SUPERTYPE) continue;
                        if (PsiType.NULL.equals(var13_16)) {
                            PsiType psiType = currentSubstitution;
                            continue;
                        }
                        PsiType psiType = GenericsUtil.getLeastUpperBound((PsiType)var13_16, currentSubstitution, manager);
                    }
                }
                if (var13_14 != PsiType.NULL) {
                    substitutions[i] = var13_14;
                }
            }
            ++i;
        }
        for (i = 0; i < typeParameters.length; ++i) {
            void var13_25;
            Pair<PsiType, ConstraintType> otherConstraint;
            typeParameter = typeParameters[i];
            PsiType psiType = substitutions[i];
            if (psiType != null) continue;
            Pair<PsiType, ConstraintType> constraint = constraints[i];
            if (constraint == null) {
                constraint = PsiResolveHelperImpl.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent, policy);
            } else if (constraint.getSecond() == ConstraintType.SUBTYPE && (otherConstraint = PsiResolveHelperImpl.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent, policy)) != null && (otherConstraint.getSecond() == ConstraintType.EQUALS || otherConstraint.getSecond() == ConstraintType.SUPERTYPE)) {
                constraint = otherConstraint;
            }
            if (constraint != null) {
                PsiType psiType2 = constraint.getFirst();
            }
            if (var13_25 == null) {
                PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
                psiSubstitutor = factory.createRawSubstitutor(partialSubstitutor, typeParameters);
                if (psiSubstitutor == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeArguments must not return null");
                return psiSubstitutor;
            }
            if (var13_25 == PsiType.NULL) continue;
            partialSubstitutor = partialSubstitutor.put(typeParameter, (PsiType)var13_25);
        }
        psiSubstitutor = partialSubstitutor;
        if (psiSubstitutor != null) return psiSubstitutor;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeArguments must not return null");
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeArguments must not be null");
        }
        if (leftTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeArguments must not be null");
        }
        if (rightTypes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeArguments must not be null");
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeArguments must not be null");
        }
        if (leftTypes.length != rightTypes.length) {
            throw new IllegalArgumentException("Types must be of the same length");
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter typeParameter : typeParameters) {
            PsiType substitution = PsiType.NULL;
            PsiType lowerBound = PsiType.NULL;
            for (int i1 = 0; i1 < leftTypes.length; ++i1) {
                PsiType leftType = leftTypes[i1];
                PsiType rightType = rightTypes[i1];
                Pair<PsiType, ConstraintType> constraint = PsiResolveHelperImpl.getSubstitutionForTypeParameterConstraint(typeParameter, leftType, rightType, true, languageLevel);
                if (constraint == null) continue;
                ConstraintType constraintType = constraint.getSecond();
                PsiType current = constraint.getFirst();
                if (constraintType == ConstraintType.EQUALS) {
                    substitution = current;
                    break;
                }
                if (constraintType == ConstraintType.SUBTYPE) {
                    if (PsiType.NULL.equals(substitution)) {
                        substitution = current;
                        continue;
                    }
                    substitution = GenericsUtil.getLeastUpperBound(substitution, current, typeParameter.getManager());
                    continue;
                }
                lowerBound = PsiType.NULL.equals(lowerBound) ? current : GenericsUtil.getLeastUpperBound(lowerBound, current, typeParameter.getManager());
            }
            if (PsiType.NULL.equals(substitution)) {
                substitution = lowerBound;
            }
            if (substitution == PsiType.NULL) continue;
            substitutor = substitutor.put(typeParameter, substitution);
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl.inferTypeArguments must not return null");
        }
        return psiSubstitutor;
    }

    @Nullable
    private static Pair<PsiType, ConstraintType> processArgType(PsiType arg, ConstraintType constraintType, boolean captureWildcard) {
        if (arg instanceof PsiWildcardType && !captureWildcard) {
            return FAILED_INFERENCE;
        }
        if (arg != PsiType.NULL) {
            return new Pair<PsiType, ConstraintType>(arg, constraintType);
        }
        return null;
    }

    private static Pair<PsiType, ConstraintType> inferMethodTypeParameterFromParent(PsiTypeParameter typeParameter, PsiSubstitutor substitutor, PsiElement parent, ParameterTypeInferencePolicy policy) {
        PsiTypeParameterListOwner owner = typeParameter.getOwner();
        Pair<PsiType, ConstraintType> substitution = null;
        if (owner instanceof PsiMethod && parent instanceof PsiCallExpression) {
            PsiCallExpression methodCall = (PsiCallExpression)parent;
            substitution = PsiResolveHelperImpl.inferMethodTypeParameterFromParent(PsiResolveHelperImpl.skipParenthesizedExprUp(methodCall.getParent()), methodCall, typeParameter, substitutor, policy);
        }
        return substitution;
    }

    @Override
    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        Pair<PsiType, ConstraintType> constraint = PsiResolveHelperImpl.getSubstitutionForTypeParameterConstraint(typeParam, param, arg, isContraVariantPosition, languageLevel);
        return constraint == null ? PsiType.NULL : constraint.getFirst();
    }

    @Nullable
    public static Pair<PsiType, ConstraintType> getSubstitutionForTypeParameterConstraint(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return PsiResolveHelperImpl.getSubstitutionForTypeParameterConstraint(typeParam, ((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), isContraVariantPosition, languageLevel);
        }
        if (!(param instanceof PsiClassType)) {
            return null;
        }
        PsiManager manager = typeParam.getManager();
        if (arg instanceof PsiPrimitiveType && (arg = ((PsiPrimitiveType)arg).getBoxedType(typeParam)) == null) {
            return null;
        }
        PsiClassType.ClassResolveResult paramResult = ((PsiClassType)param).resolveGenerics();
        PsiClass paramClass = (PsiClass)paramResult.getElement();
        if (typeParam == paramClass) {
            if (arg == null || arg.getDeepComponentType() instanceof PsiPrimitiveType || arg instanceof PsiIntersectionType || PsiUtil.resolveClassInType(arg) != null) {
                PsiType bound = PsiResolveHelperImpl.intersectAllExtends(typeParam, arg);
                return new Pair<PsiType, ConstraintType>(bound, ConstraintType.SUPERTYPE);
            }
            return null;
        }
        if (paramClass == null) {
            return null;
        }
        if (!(arg instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult argResult = ((PsiClassType)arg).resolveGenerics();
        PsiClass argClass = (PsiClass)argResult.getElement();
        if (argClass == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        PsiClassType patternType = factory.createType(typeParam);
        if (isContraVariantPosition) {
            PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor(paramClass, argClass, argResult.getSubstitutor());
            if (substitutor == null) {
                return null;
            }
            arg = factory.createType(paramClass, substitutor, languageLevel);
        } else {
            PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor(argClass, paramClass, paramResult.getSubstitutor());
            if (substitutor == null) {
                return null;
            }
            param = factory.createType(argClass, substitutor, languageLevel);
        }
        return PsiResolveHelperImpl.getSubstitutionForTypeParameterInner(param, arg, patternType, ConstraintType.SUPERTYPE, 0);
    }

    private static PsiType intersectAllExtends(PsiTypeParameter typeParam, PsiType arg) {
        if (arg == null) {
            return null;
        }
        PsiClassType[] superTypes = typeParam.getSuperTypes();
        PsiType[] erasureTypes = new PsiType[superTypes.length];
        for (int i = 0; i < superTypes.length; ++i) {
            erasureTypes[i] = TypeConversionUtil.erasure(superTypes[i]);
        }
        PsiType[] types = ArrayUtil.append(erasureTypes, arg, PsiType.class);
        assert (types.length != 0);
        return PsiIntersectionType.createIntersection(types);
    }

    @Nullable
    private static Pair<PsiType, ConstraintType> getSubstitutionForTypeParameterInner(PsiType param, PsiType arg, PsiType patternType, ConstraintType constraintType, int depth) {
        if (arg instanceof PsiCapturedWildcardType) {
            arg = ((PsiCapturedWildcardType)arg).getWildcard();
        }
        if (patternType.equals(param)) {
            return PsiResolveHelperImpl.processArgType(arg, constraintType, depth < 2);
        }
        if (param instanceof PsiWildcardType) {
            PsiClassType.ClassResolveResult argResult;
            PsiClass argClass;
            PsiClassType.ClassResolveResult boundResult;
            PsiClass boundClass;
            Pair<PsiType, ConstraintType> res;
            ConstraintType constrType;
            PsiWildcardType wildcardParam = (PsiWildcardType)param;
            PsiType paramBound = wildcardParam.getBound();
            if (paramBound == null) {
                return null;
            }
            ConstraintType constraintType2 = constrType = wildcardParam.isExtends() ? ConstraintType.SUPERTYPE : ConstraintType.SUBTYPE;
            if (arg instanceof PsiWildcardType) {
                if (((PsiWildcardType)arg).isExtends() == wildcardParam.isExtends() && ((PsiWildcardType)arg).isBounded() == wildcardParam.isBounded() && (res = PsiResolveHelperImpl.getSubstitutionForTypeParameterInner(paramBound, ((PsiWildcardType)arg).getBound(), patternType, constrType, depth)) != null) {
                    return res;
                }
            } else if (patternType.equals(paramBound)) {
                res = PsiResolveHelperImpl.getSubstitutionForTypeParameterInner(paramBound, arg, patternType, constrType, depth);
                if (res != null) {
                    return res;
                }
            } else if (paramBound instanceof PsiArrayType && arg instanceof PsiArrayType) {
                res = PsiResolveHelperImpl.getSubstitutionForTypeParameterInner(((PsiArrayType)paramBound).getComponentType(), ((PsiArrayType)arg).getComponentType(), patternType, constrType, depth);
                if (res != null) {
                    return res;
                }
            } else if (paramBound instanceof PsiClassType && arg instanceof PsiClassType && (boundClass = (boundResult = ((PsiClassType)paramBound).resolveGenerics()).getElement()) != null && (argClass = (argResult = ((PsiClassType)arg).resolveGenerics()).getElement()) != null) {
                Pair<PsiType, ConstraintType> res2;
                PsiType substituted;
                PsiSubstitutor superSubstitutor;
                if (wildcardParam.isExtends()) {
                    superSubstitutor = TypeConversionUtil.getClassSubstitutor(boundClass, argClass, argResult.getSubstitutor());
                    if (superSubstitutor != null) {
                        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(boundClass)) {
                            substituted = superSubstitutor.substitute(typeParameter);
                            if (substituted == null || (res2 = PsiResolveHelperImpl.getSubstitutionForTypeParameterInner(boundResult.getSubstitutor().substitute(typeParameter), substituted, patternType, ConstraintType.EQUALS, depth + 1)) == null) continue;
                            return res2;
                        }
                    }
                } else {
                    superSubstitutor = TypeConversionUtil.getClassSubstitutor(argClass, boundClass, boundResult.getSubstitutor());
                    if (superSubstitutor != null) {
                        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(argClass)) {
                            substituted = argResult.getSubstitutor().substitute(typeParameter);
                            if (substituted == null || (res2 = PsiResolveHelperImpl.getSubstitutionForTypeParameterInner(superSubstitutor.substitute(typeParameter), substituted, patternType, ConstraintType.EQUALS, depth + 1)) == null) continue;
                            return res2;
                        }
                    }
                }
            }
        }
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return PsiResolveHelperImpl.getSubstitutionForTypeParameterInner(((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), patternType, constraintType, depth);
        }
        if (param instanceof PsiClassType && arg instanceof PsiClassType) {
            PsiClassType.ClassResolveResult paramResult = ((PsiClassType)param).resolveGenerics();
            PsiClass paramClass = paramResult.getElement();
            if (paramClass == null) {
                return null;
            }
            PsiClassType.ClassResolveResult argResult = ((PsiClassType)arg).resolveGenerics();
            PsiClass argClass = argResult.getElement();
            if (argClass != paramClass) {
                return null;
            }
            Pair<PsiType, ConstraintType> wildcardCaptured = null;
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(paramClass)) {
                PsiType argType;
                PsiType paramType = paramResult.getSubstitutor().substitute(typeParameter);
                Pair<PsiType, ConstraintType> res = PsiResolveHelperImpl.getSubstitutionForTypeParameterInner(paramType, argType = argResult.getSubstitutor().substituteWithBoundsPromotion(typeParameter), patternType, ConstraintType.EQUALS, depth + 1);
                if (res == null) continue;
                PsiType type = res.getFirst();
                if (!(type instanceof PsiWildcardType)) {
                    return res;
                }
                if (wildcardCaptured != null) {
                    return FAILED_INFERENCE;
                }
                wildcardCaptured = res;
            }
            return wildcardCaptured;
        }
        return null;
    }

    private static Pair<PsiType, ConstraintType> inferMethodTypeParameterFromParent(PsiElement parent, PsiCallExpression methodCall, PsiTypeParameter typeParameter, PsiSubstitutor substitutor, ParameterTypeInferencePolicy policy) {
        PsiElement pParent;
        Pair<PsiType, ConstraintType> constraint = null;
        PsiType expectedType = null;
        if (parent instanceof PsiVariable) {
            if (methodCall.equals(PsiResolveHelperImpl.skipParenthesizedExprDown(((PsiVariable)parent).getInitializer()))) {
                expectedType = ((PsiVariable)parent).getType();
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            if (methodCall.equals(PsiResolveHelperImpl.skipParenthesizedExprDown(((PsiAssignmentExpression)parent).getRExpression()))) {
                expectedType = ((PsiAssignmentExpression)parent).getLExpression().getType();
            }
        } else if (parent instanceof PsiReturnStatement) {
            PsiMethod method = PsiTreeUtil.getParentOfType(parent, PsiMethod.class);
            if (method != null) {
                expectedType = method.getReturnType();
            }
        } else if (parent instanceof PsiExpressionList && (pParent = parent.getParent()) instanceof PsiCallExpression && parent.equals(((PsiCallExpression)pParent).getArgumentList())) {
            constraint = policy.inferTypeConstraintFromCallContext(methodCall, (PsiExpressionList)parent, (PsiCallExpression)pParent, typeParameter);
        }
        PsiManager manager = typeParameter.getManager();
        GlobalSearchScope scope = parent.getResolveScope();
        PsiType returnType = null;
        if (constraint == null) {
            PsiType guess;
            if (expectedType == null) {
                expectedType = policy.getDefaultExpectedType(methodCall);
            }
            if ((constraint = PsiResolveHelperImpl.getSubstitutionForTypeParameterConstraint(typeParameter, returnType = ((PsiMethod)typeParameter.getOwner()).getReturnType(), expectedType, false, PsiUtil.getLanguageLevel(parent))) != null && (guess = constraint.getFirst()) != null && !guess.equals(PsiType.NULL) && constraint.getSecond() == ConstraintType.SUPERTYPE && guess instanceof PsiIntersectionType) {
                for (PsiType conjuct : ((PsiIntersectionType)guess).getConjuncts()) {
                    if (conjuct.isAssignableFrom(expectedType)) continue;
                    return FAILED_INFERENCE;
                }
            }
        }
        if (constraint == null) {
            PsiSubstitutor finalSubstitutor = substitutor.put(typeParameter, null);
            PsiClassType[] superTypes = typeParameter.getSuperTypes();
            if (superTypes.length == 0) {
                return null;
            }
            PsiType superType = finalSubstitutor.substitute(superTypes[0]);
            if (superType == null) {
                superType = PsiType.getJavaLangObject(manager, scope);
            }
            if (superType == null) {
                return null;
            }
            return policy.getInferredTypeWithNoConstraint(manager, superType);
        }
        PsiType guess = (PsiType)constraint.getFirst();
        guess = policy.adjustInferredType(manager, guess, (ConstraintType)((Object)constraint.getSecond()));
        if (returnType instanceof PsiClassType && typeParameter.equals(((PsiClassType)returnType).resolve())) {
            PsiClassType[] extendsTypes = typeParameter.getExtendsListTypes();
            PsiSubstitutor newSubstitutor = substitutor.put(typeParameter, guess);
            for (PsiClassType extendsType1 : extendsTypes) {
                PsiType extendsType = newSubstitutor.substitute(extendsType1);
                if (guess == null || extendsType.isAssignableFrom(guess)) continue;
                if (!guess.isAssignableFrom(extendsType)) break;
                guess = extendsType;
                newSubstitutor = substitutor.put(typeParameter, guess);
            }
        }
        Pair<PsiType, ConstraintType> result = new Pair<PsiType, ConstraintType>(guess, constraint.getSecond());
        return result;
    }

    @Nullable
    private static PsiExpression skipParenthesizedExprDown(PsiExpression initializer) {
        while (initializer instanceof PsiParenthesizedExpression) {
            initializer = ((PsiParenthesizedExpression)initializer).getExpression();
        }
        return initializer;
    }

    private static PsiElement skipParenthesizedExprUp(PsiElement parent) {
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        return parent;
    }
}

