/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.StaticImportResolveProcessor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiImportStaticReferenceElementImpl
extends CompositePsiElement
implements PsiImportStaticReferenceElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiImportStaticReferenceElementImpl");
    private volatile String myCanonicalText;

    public PsiImportStaticReferenceElementImpl() {
        super(JavaElementType.IMPORT_STATIC_REFERENCE);
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.findChildByRole(53);
        if (refName != null) {
            return refName.getStartOffset();
        }
        return super.getTextOffset();
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCanonicalText = null;
    }

    @Override
    public final ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 53: {
                if (this.getLastChildNode().getElementType() == JavaTokenType.IDENTIFIER) {
                    return this.getLastChildNode();
                }
                return null;
            }
            case 54: {
                if (this.getFirstChildNode().getElementType() == JavaElementType.JAVA_CODE_REFERENCE) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 55: 
        }
        return this.findChildByType(JavaTokenType.DOT);
    }

    @Override
    public final int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        return 0;
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByRoleAsPsiElement(53);
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl.getTypeParameters must not return null");
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiJavaCodeReferenceElement getClassReference() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiImportStaticStatement bindToTargetClass(PsiClass aClass) throws IncorrectOperationException {
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            throw new IncorrectOperationException();
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        CompositeElement newRef = (CompositeElement)parserFacade.createReferenceFromText(qualifiedName, null).getNode();
        if (this.getQualifier() != null) {
            this.replaceChildInternal(this.findChildByRole(54), newRef);
            return (PsiImportStaticStatement)this.getParent();
        }
        LeafElement dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, SharedImplUtil.findCharTableByTree(newRef), this.getManager());
        newRef.rawInsertAfterMe(dot);
        CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
        dot.rawInsertAfterMe(errorElement);
        CompositeElement parentComposite = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(this.getParent());
        parentComposite.addInternal(newRef, errorElement, this, Boolean.TRUE);
        parentComposite.deleteChildInternal(this);
        return (PsiImportStaticStatement)SourceTreeToPsiMap.treeElementToPsi(parentComposite);
    }

    @Override
    public boolean isQualified() {
        return this.findChildByRole(54) != null;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public String getReferenceName() {
        ASTNode childByRole = this.findChildByRole(53);
        if (childByRole == null) {
            return "";
        }
        return childByRole.getText();
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    public TextRange getRangeInElement() {
        TreeElement nameChild = (TreeElement)this.findChildByRole(53);
        if (nameChild == null) {
            return new TextRange(0, this.getTextLength());
        }
        int startOffset = nameChild.getStartOffsetInParent();
        return new TextRange(startOffset, startOffset + nameChild.getTextLength());
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String canonicalText = this.myCanonicalText;
        if (canonicalText == null) {
            this.myCanonicalText = canonicalText = this.calcCanonicalText();
        }
        String string = canonicalText;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl.getCanonicalText must not return null");
        }
        return string;
    }

    private String calcCanonicalText() {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.getQualifier();
        if (referenceElement == null) {
            return this.getReferenceName();
        }
        return referenceElement.getCanonicalText() + "." + this.getReferenceName();
    }

    @Override
    public String toString() {
        return "PsiImportStaticReferenceElement:" + this.getText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult;
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            javaResolveResult = results[0];
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl.advancedResolve must not return null");
            return javaResolveResult;
        }
        javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult != null) return javaResolveResult;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl.advancedResolve must not return null");
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveCache resolveCache = ResolveCache.getInstance(this.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, OurGenericsResolver.INSTANCE, true, incompleteCode);
        JavaResolveResult[] javaResolveResultArray = results instanceof JavaResolveResult[] ? (JavaResolveResult[])results : JavaResolveResult.EMPTY_ARRAY;
        if (javaResolveResultArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl.multiResolve must not return null");
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        String name = this.getReferenceName();
        return name != null && element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName()) && element.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl.bindToElement must not be null");
        }
        if (!(element instanceof PsiMember) || !(element instanceof PsiNamedElement) || ((PsiNamedElement)element).getName() == null) {
            throw new IncorrectOperationException();
        }
        if (!((PsiModifierListOwner)element).hasModifierProperty("static")) {
            if (element instanceof PsiClass && ((PsiClass)element).getContainingClass() == null) {
                return this.replaceWithRegularImport((PsiClass)element);
            }
            throw new IncorrectOperationException();
        }
        PsiClass containingClass = ((PsiMember)element).getContainingClass();
        if (containingClass == null) {
            throw new IncorrectOperationException();
        }
        PsiElement qualifier = this.getQualifier();
        if (qualifier == null) {
            throw new IncorrectOperationException();
        }
        ((PsiReference)((Object)qualifier)).bindToElement(containingClass);
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createIdentifier(((PsiNamedElement)element).getName());
        oldIdentifier.replace(identifier);
        return this;
    }

    private PsiElement replaceWithRegularImport(PsiClass psiClass) throws IncorrectOperationException {
        PsiImportStaticStatement baseStatement = PsiTreeUtil.getParentOfType(this.getElement(), PsiImportStaticStatement.class);
        PsiImportStatement statement = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createImportStatement(psiClass);
        statement = (PsiImportStatement)baseStatement.replace(statement);
        PsiJavaCodeReferenceElement reference = statement.getImportReference();
        assert (reference != null);
        return reference;
    }

    @Override
    public void processVariants(PsiScopeProcessor processor) {
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)new ClassFilter(PsiModifierListOwner.class), processor);
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl.getVariants must not return null");
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportStaticReferenceElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantResolver<PsiImportStaticReferenceElementImpl> {
        private static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        @Override
        public JavaResolveResult[] resolve(PsiImportStaticReferenceElementImpl referenceElement, boolean incompleteCode) {
            PsiElement qualifier = referenceElement.getQualifier();
            if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
                return JavaResolveResult.EMPTY_ARRAY;
            }
            PsiElement target = ((PsiJavaCodeReferenceElement)qualifier).resolve();
            if (!(target instanceof PsiClass)) {
                return JavaResolveResult.EMPTY_ARRAY;
            }
            StaticImportResolveProcessor processor = new StaticImportResolveProcessor(referenceElement);
            target.processDeclarations(processor, ResolveState.initial(), referenceElement, referenceElement);
            return processor.getResults();
        }
    }
}

