/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.ide.caches.FileContent;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.TextBlock;
import com.intellij.psi.impl.cache.impl.CacheUtil;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.source.IdentityCharTable;
import com.intellij.psi.impl.source.PsiElementArrayConstructor;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PatchedSoftReference;
import com.intellij.util.PatchedWeakReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiFileImpl
extends ElementBase
implements PsiFileEx,
PsiFileWithStubSupport,
Queryable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiFileImpl");
    private IElementType myElementType;
    protected IElementType myContentElementType;
    protected PsiFile myOriginalFile;
    private final FileViewProvider myViewProvider;
    private static final Key<Document> HARD_REFERENCE_TO_DOCUMENT = new Key("HARD_REFERENCE_TO_DOCUMENT");
    private final Object myStubLock;
    private SoftReference<StubTree> myStub;
    protected final PsiManagerEx myManager;
    private volatile Object myTreeElementPointer;
    public static final Key<Boolean> BUILDING_STUB = new Key("Don't use stubs mark!");
    private static final Comparator<PsiFile> FILE_BY_LANGUAGE_ID = new Comparator<PsiFile>(){

        @Override
        public int compare(PsiFile o1, PsiFile o2) {
            return o1.getLanguage().getID().compareTo(o2.getLanguage().getID());
        }
    };
    private static final Key<StubTree> STUB_TREE_IN_PARSED_TREE = new Key("STUB_TREE_IN_PARSED_TREE");

    protected PsiFileImpl(@NotNull IElementType elementType, IElementType contentElementType, @NotNull FileViewProvider provider) {
        if (elementType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.<init> must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.<init> must not be null");
        }
        this(provider);
        this.init(elementType, contentElementType);
    }

    protected PsiFileImpl(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.<init> must not be null");
        }
        this.myOriginalFile = null;
        this.myStubLock = new Object();
        this.myManager = (PsiManagerEx)provider.getManager();
        this.myViewProvider = provider;
    }

    public void setContentElementType(IElementType contentElementType) {
        this.myContentElementType = contentElementType;
    }

    public IElementType getContentElementType() {
        return this.myContentElementType;
    }

    protected void init(@NotNull IElementType elementType, IElementType contentElementType) {
        if (elementType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.init must not be null");
        }
        this.myElementType = elementType;
        this.myContentElementType = contentElementType;
    }

    public TreeElement createContentLeafElement(CharSequence leafText) {
        if (this.myContentElementType instanceof ILazyParseableElementType) {
            return ASTFactory.lazy((ILazyParseableElementType)this.myContentElementType, leafText);
        }
        return ASTFactory.leaf(this.myContentElementType, leafText);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileElement getTreeElement() {
        FileElement noLockAttempt = (FileElement)this._getTreeElement();
        if (noLockAttempt != null) {
            return noLockAttempt;
        }
        Object object = this.myStubLock;
        synchronized (object) {
            return this.getTreeElementNoLock();
        }
    }

    public FileElement getTreeElementNoLock() {
        ASTNode node = this._getTreeElement();
        if (node == null && !this.getViewProvider().isPhysical()) {
            node = this.loadTreeElement();
            this.setTreeElement(node);
        }
        return (FileElement)node;
    }

    protected boolean isKeepTreeElementByHardReference() {
        return !this.getViewProvider().isEventSystemEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASTNode _getTreeElement() {
        Object pointer = this.myTreeElementPointer;
        if (pointer instanceof FileElement) {
            return (FileElement)pointer;
        }
        if (pointer instanceof Reference) {
            FileElement treeElement = (FileElement)((Reference)pointer).get();
            if (treeElement != null) {
                return treeElement;
            }
            Object object = this.myStubLock;
            synchronized (object) {
                if (this.myTreeElementPointer == pointer) {
                    this.myTreeElementPointer = null;
                }
            }
        }
        return null;
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    @Override
    public boolean isValid() {
        VirtualFile vFile = this.getViewProvider().getVirtualFile();
        if (!vFile.isValid()) {
            return false;
        }
        if (!this.getViewProvider().isPhysical()) {
            return true;
        }
        return this.isPsiUpToDate(vFile);
    }

    protected boolean isPsiUpToDate(VirtualFile vFile) {
        FileViewProvider provider = this.myManager.findViewProvider(vFile);
        return provider.getPsi(this.getLanguage()) == this || provider.getPsi(provider.getBaseLanguage()) == this;
    }

    @Override
    public boolean isContentsLoaded() {
        return this._getTreeElement() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileElement loadTreeElement() {
        FileElement treeElement;
        Object object = this.myStubLock;
        synchronized (object) {
            treeElement = (FileElement)this._getTreeElement();
            if (treeElement != null) {
                return treeElement;
            }
            FileViewProvider viewProvider = this.getViewProvider();
            if (viewProvider.isPhysical() && this.myManager.isAssertOnFileLoading(viewProvider.getVirtualFile())) {
                LOG.error("Access to tree elements not allowed in tests. path='" + viewProvider.getVirtualFile().getPresentableUrl() + "'");
            }
            Document document = viewProvider.isEventSystemEnabled() ? viewProvider.getDocument() : null;
            treeElement = this.createFileElement(viewProvider.getContents());
            if (document != null) {
                treeElement.putUserData(HARD_REFERENCE_TO_DOCUMENT, document);
            }
            treeElement.setPsi(this);
            StubTree stub = this.derefStub();
            if (stub != null) {
                Iterator<StubElement<?>> stubs = stub.getPlainList().iterator();
                stubs.next();
                this.switchFromStubToAST(treeElement, stubs);
                this.myStub = null;
            }
            this.setTreeElement(treeElement);
            if (LOG.isDebugEnabled() && this.getViewProvider().isPhysical()) {
                LOG.debug("Loaded text for file " + this.getViewProvider().getVirtualFile().getPresentableUrl());
            }
        }
        if (this.getViewProvider().isEventSystemEnabled() && this.isPhysical()) {
            VirtualFile vFile = this.getViewProvider().getVirtualFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(vFile);
            if (document != null) {
                TextBlock.get(this).clear();
            }
        }
        return treeElement;
    }

    @Override
    public ASTNode findTreeForStub(StubTree tree, StubElement<?> stub) {
        Iterator<StubElement<?>> stubs = tree.getPlainList().iterator();
        StubElement<?> root = stubs.next();
        FileElement ast = this.calcTreeElement();
        if (root == stub) {
            return ast;
        }
        return PsiFileImpl.findTreeForStub(ast, stubs, stub);
    }

    @Nullable
    private static ASTNode findTreeForStub(ASTNode tree, Iterator<StubElement<?>> stubs, StubElement stub) {
        StubElement<?> curStub;
        IElementType type = tree.getElementType();
        if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(tree) && (curStub = stubs.next()) == stub) {
            return tree;
        }
        for (ASTNode node : tree.getChildren(null)) {
            ASTNode treeForStub = PsiFileImpl.findTreeForStub(node, stubs, stub);
            if (treeForStub == null) continue;
            return treeForStub;
        }
        return null;
    }

    private void switchFromStubToAST(ASTNode root, final Iterator<StubElement<?>> stubs) {
        IElementType contentElementType = this.getContentElementType();
        if (!(contentElementType instanceof IStubFileElementType)) {
            VirtualFile vFile = this.getVirtualFile();
            throw new AssertionError((Object)("A stub in a non-stub file '" + vFile + "'; isValid()=" + (vFile != null ? Boolean.valueOf(vFile.isValid()) : "null") + " type: " + contentElementType + "; content:<<<\n" + StringUtil.first(this.getViewProvider().getContents(), 200, true) + "\n>>>; stubs=" + ContainerUtil.collect(stubs)));
        }
        final StubBuilder builder = ((IStubFileElementType)contentElementType).getBuilder();
        ((TreeElement)root).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            protected void visitNode(TreeElement tree) {
                IElementType type = tree.getElementType();
                CompositeElement treeParent = tree.getTreeParent();
                if (treeParent != null && builder.skipChildProcessingWhenBuildingStubs(treeParent, type)) {
                    return;
                }
                if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(tree)) {
                    if (!stubs.hasNext()) {
                        PsiFileImpl.this.rebuildStub();
                        LOG.error("Stub list in " + PsiFileImpl.this.getName() + " has fewer elements than PSI. Last AST element: " + tree.getElementType() + " " + tree);
                        this.stopWalking();
                        return;
                    }
                    StubElement stub = (StubElement)stubs.next();
                    if (stub.getStubType() != tree.getElementType()) {
                        PsiFileImpl.this.rebuildStub();
                        LOG.error("Stub and PSI element type mismatch in " + PsiFileImpl.this.getName() + ": stub " + stub + ", AST " + tree.getElementType() + "; " + tree);
                        this.stopWalking();
                        return;
                    }
                    Object psi = stub.getPsi();
                    ((CompositeElement)tree).setPsi((PsiElement)psi);
                    StubBasedPsiElementBase base = (StubBasedPsiElementBase)psi;
                    base.setNode(tree);
                    base.setStub(null);
                }
                super.visitNode(tree);
            }
        });
    }

    protected FileElement createFileElement(CharSequence docText) {
        FileElement treeElement;
        TreeElement contentLeaf = this.createContentLeafElement(docText);
        if (contentLeaf instanceof FileElement) {
            treeElement = (FileElement)contentLeaf;
        } else {
            CompositeElement xxx = ASTFactory.composite(this.myElementType);
            assert (xxx instanceof FileElement) : "BUMM";
            treeElement = (FileElement)xxx;
            treeElement.rawAddChildrenWithoutNotifications(contentLeaf);
        }
        if (CacheUtil.isCopy(this)) {
            treeElement.setCharTable(IdentityCharTable.INSTANCE);
        }
        return treeElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadContent() {
        LOG.assertTrue(this.getTreeElement() != null);
        this.clearCaches();
        this.myViewProvider.beforeContentsSynchronized();
        this.setTreeElement(null);
        Object object = this.myStubLock;
        synchronized (object) {
            this.myStub = null;
        }
    }

    public void clearCaches() {
    }

    @Override
    public String getText() {
        return ((Object)this.getViewProvider().getContents()).toString();
    }

    @Override
    public int getTextLength() {
        ASTNode tree = this._getTreeElement();
        if (tree != null) {
            return tree.getTextLength();
        }
        return this.getViewProvider().getContents().length();
    }

    @Override
    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling(this);
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling(this);
    }

    @Override
    public long getModificationStamp() {
        return this.getViewProvider().getModificationStamp();
    }

    @Override
    public void subtreeChanged() {
        this.doClearCaches();
        this.getViewProvider().rootChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClearCaches() {
        FileElement tree = this.getTreeElement();
        if (tree != null) {
            this.myTreeElementPointer = tree;
            tree.clearCaches();
        }
        Object object = this.myStubLock;
        synchronized (object) {
            this.myStub = null;
            if (tree != null) {
                tree.putUserData(STUB_TREE_IN_PARSED_TREE, null);
            }
        }
        this.clearCaches();
    }

    @Override
    protected PsiFileImpl clone() {
        FileViewProvider viewProvider = this.getViewProvider();
        FileViewProvider providerCopy = viewProvider.clone();
        Language language = this.getLanguage();
        if (providerCopy == null) {
            throw new AssertionError((Object)("Unable to clone the view provider: " + viewProvider + "; " + language));
        }
        PsiFileImpl clone = (PsiFileImpl)providerCopy.getPsi(language);
        assert (clone != null) : "Cannot find psi file with: " + language + "." + " Original viewprovider: " + viewProvider + "; languages: " + viewProvider.getLanguages() + "; copied viewprovider: " + providerCopy + "; languages: " + providerCopy.getLanguages() + "; Original virtual file: " + this.getVirtualFile() + "; copied virtual file: " + providerCopy.getVirtualFile() + "; its .getOriginal(): " + (providerCopy.getVirtualFile() instanceof LightVirtualFile ? ((LightVirtualFile)providerCopy.getVirtualFile()).getOriginalFile() : null);
        this.copyCopyableDataTo(clone);
        if (this.getTreeElement() != null) {
            FileElement treeClone = (FileElement)this.calcTreeElement().clone();
            clone.myTreeElementPointer = treeClone;
            treeClone.setPsi(clone);
        }
        if (viewProvider.isEventSystemEnabled()) {
            clone.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone.myOriginalFile = this.myOriginalFile;
        }
        return clone;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getViewProvider().getVirtualFile().getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getName must not return null");
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.setName must not be null");
        }
        this.checkSetName(name);
        this.doClearCaches();
        return PsiFileImplUtil.setName(this, name);
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    @Override
    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable() && !CacheUtil.isCopy(this);
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    @Nullable
    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getViewProvider().getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFileImpl psiFileImpl = this;
        if (psiFileImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getContainingFile must not return null");
        }
        return psiFileImpl;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile psiFile = this.myOriginalFile == null ? this : this.myOriginalFile;
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getOriginalFile must not return null");
        }
        return psiFile;
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.setOriginalFile must not be null");
        }
        this.myOriginalFile = originalFile.getOriginalFile();
    }

    @Override
    @NotNull
    public PsiFile[] getPsiRoots() {
        FileViewProvider viewProvider = this.getViewProvider();
        Set<Language> languages = viewProvider.getLanguages();
        PsiFile[] roots = new PsiFile[languages.size()];
        int i = 0;
        for (Language language : languages) {
            PsiFile psi = viewProvider.getPsi(language);
            if (psi == null) {
                LOG.error("PSI is null for " + language + "; in file: " + this);
            }
            roots[i++] = psi;
        }
        if (roots.length > 1) {
            Arrays.sort(roots, FILE_BY_LANGUAGE_ID);
        }
        if (roots == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getPsiRoots must not return null");
        }
        return roots;
    }

    @Override
    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getLanguage must not return null");
        }
        return language;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getViewProvider must not return null");
        }
        return fileViewProvider;
    }

    public void setTreeElementPointer(FileElement element) {
        this.myTreeElementPointer = element;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return this.getViewProvider().findElementAt(offset);
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return this.getViewProvider().findReferenceAt(offset);
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = CharArrayUtil.fromSequenceStrict(this.getViewProvider().getContents());
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.textToCharArray must not return null");
        }
        return cArray;
    }

    @NotNull
    public <T> T[] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            result.add(child);
        }
        Object[] objectArray = result.toArray((Object[])Array.newInstance(aClass, result.size()));
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.findChildrenByClass must not return null");
        }
        return objectArray;
    }

    @Nullable
    public <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public boolean isTemplateDataFile() {
        return false;
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void onContentReload() {
        this.subtreeChanged();
        if (this.isContentsLoaded()) {
            this.unloadContent();
        }
    }

    @Override
    public PsiFile cacheCopy(FileContent content) {
        CharSequence text;
        if (this.isContentsLoaded()) {
            return this;
        }
        if (content == null) {
            Document document = FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
            text = document.getCharsSequence();
        } else {
            text = CacheUtil.getContentText(content);
        }
        FileType fileType = this.getFileType();
        String name = this.getName();
        PsiFile fileCopy = PsiFileFactory.getInstance(this.getProject()).createFileFromText(name, fileType, text, this.getModificationStamp(), false, false);
        fileCopy.putUserData(CacheUtil.CACHE_COPY_KEY, Boolean.TRUE);
        ((PsiFileImpl)fileCopy).setOriginalFile(this);
        return fileCopy;
    }

    @Nullable
    public StubElement getStub() {
        StubTree stubHolder = this.getStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (Boolean.TRUE.equals(this.getUserData(BUILDING_STUB))) {
            return null;
        }
        StubTree derefd = this.derefStub();
        if (derefd != null) {
            return derefd;
        }
        if (this.getTreeElementNoLock() != null) {
            return null;
        }
        VirtualFile vFile = this.getVirtualFile();
        if (!(vFile instanceof VirtualFileWithId)) {
            return null;
        }
        StubTree stubHolder = StubTreeLoader.getInstance().readOrBuild(this.getProject(), vFile);
        if (stubHolder == null) {
            return null;
        }
        IElementType contentElementType = this.getContentElementType();
        if (!(contentElementType instanceof IStubFileElementType)) {
            FileViewProvider viewProvider = this.getViewProvider();
            throw new AssertionError((Object)("A stub in a non-stub file '" + vFile + "'; isValid()=" + vFile.isValid() + "; IndexStamp=" + StubTreeLoader.getInstance().getStubTreeTimestamp(vFile) + "; Type: " + contentElementType + "; " + "Psi roots: " + viewProvider.getAllFiles() + "; " + " StubUpdatingIndex.canHaveStub(vFile)=" + StubTreeLoader.getInstance().canHaveStub(vFile) + " content:<<<\n" + StringUtil.first(viewProvider.getContents(), 200, true) + "\n>>>; stubs=" + stubHolder.getPlainList()));
        }
        Object object = this.myStubLock;
        synchronized (object) {
            if (this.getTreeElementNoLock() != null) {
                return null;
            }
            StubTree derefdOnLock = this.derefStub();
            if (derefdOnLock != null) {
                return derefdOnLock;
            }
            this.myStub = new SoftReference<StubTree>(stubHolder);
            StubBase base = (StubBase)((Object)stubHolder.getRoot());
            base.setPsi(this);
            base.putUserData(STUB_TREE_IN_PARSED_TREE, stubHolder);
            return stubHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private StubTree derefStub() {
        if (this.myStub == null) {
            return null;
        }
        Object object = this.myStubLock;
        synchronized (object) {
            return this.myStub != null ? (StubTree)this.myStub.get() : null;
        }
    }

    protected PsiFileImpl cloneImpl(FileElement treeElementClone) {
        PsiFileImpl clone = (PsiFileImpl)super.clone();
        clone.myTreeElementPointer = treeElementClone;
        treeElementClone.setPsi(clone);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTreeElement(ASTNode treeElement) {
        Object newPointer = treeElement == null ? null : (this.isKeepTreeElementByHardReference() ? treeElement : (this.myManager.isBatchFilesProcessingMode() ? new PatchedWeakReference<ASTNode>(treeElement) : new PatchedSoftReference<ASTNode>(treeElement)));
        Object object = this.myStubLock;
        synchronized (object) {
            this.myTreeElementPointer = newPointer;
        }
    }

    public Object getStubLock() {
        return this.myStubLock;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    public PsiElement getNavigationElement() {
        return this;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileElement calcTreeElement() {
        FileElement treeElement = this.getTreeElement();
        if (treeElement != null) {
            return treeElement;
        }
        Object object = this.myStubLock;
        synchronized (object) {
            treeElement = this.getTreeElement();
            if (treeElement != null) {
                return treeElement;
            }
            return this.loadTreeElement();
        }
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.calcTreeElement().getChildrenAsPsiElements(null, PsiElementArrayConstructor.PSI_ELEMENT_ARRAY_CONSTRUCTOR);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.calcTreeElement());
    }

    @Override
    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.calcTreeElement());
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.acceptChildren must not be null");
        }
        SharedImplUtil.acceptChildren(visitor, this.calcTreeElement());
    }

    @Override
    public int getStartOffsetInParent() {
        return this.calcTreeElement().getStartOffsetInParent();
    }

    @Override
    public int getTextOffset() {
        return this.calcTreeElement().getTextOffset();
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.textMatches must not be null");
        }
        return this.calcTreeElement().textMatches(text);
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.textMatches must not be null");
        }
        return this.calcTreeElement().textMatches(element);
    }

    @Override
    public boolean textContains(char c) {
        return this.calcTreeElement().textContains(c);
    }

    @Override
    public final PsiElement copy() {
        return this.clone();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.add must not be null");
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, null, null);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.addBefore must not be null");
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.addAfter must not be null");
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.checkAdd must not be null");
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, null, null);
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.addRangeBefore must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.addRangeBefore must not be null");
        }
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        if (first == null) {
            LOG.assertTrue(last == null);
            return;
        }
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        FileElement treeElement = this.calcTreeElement();
        LOG.assertTrue(firstElement.getTreeParent() == treeElement);
        LOG.assertTrue(lastElement.getTreeParent() == treeElement);
        CodeEditUtil.removeChildren(treeElement, firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.replace must not be null");
        }
        FileElement treeElement = this.calcTreeElement();
        return SharedImplUtil.doReplace(this, treeElement, newElement);
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.processDeclarations must not be null");
        }
        return true;
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Override
            public String getPresentableText() {
                return PsiFileImpl.this.getName();
            }

            @Override
            public String getLocationString() {
                PsiDirectory psiDirectory = PsiFileImpl.this.getParent();
                if (psiDirectory != null) {
                    return psiDirectory.getVirtualFile().getPresentableUrl();
                }
                return null;
            }

            @Override
            public Icon getIcon(boolean open) {
                return PsiFileImpl.this.getIcon(open ? 4 : 8);
            }
        };
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().getDescriptor(this).navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFileImpl.getProject must not return null");
        }
        return project;
    }

    @Override
    public FileASTNode getNode() {
        return this.calcTreeElement();
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubTree calcStubTree() {
        Object object = this.myStubLock;
        synchronized (object) {
            FileElement fileElement = this.calcTreeElement();
            StubTree tree = fileElement.getUserData(STUB_TREE_IN_PARSED_TREE);
            if (tree == null) {
                IElementType contentElementType = this.getContentElementType();
                if (!(contentElementType instanceof IStubFileElementType)) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("ContentElementType: ").append(contentElementType).append("; file: ").append(this);
                    builder.append("\n\t").append("Boolean.TRUE.equals(getUserData(BUILDING_STUB)) = ").append(Boolean.TRUE.equals(this.getUserData(BUILDING_STUB)));
                    builder.append("\n\t").append("getTreeElementNoLock() = ").append(this.getTreeElementNoLock());
                    VirtualFile vFile = this.getVirtualFile();
                    builder.append("\n\t").append("vFile instanceof VirtualFileWithId = ").append(vFile instanceof VirtualFileWithId);
                    builder.append("\n\t").append("StubUpdatingIndex.canHaveStub(vFile) = ").append(StubTreeLoader.getInstance().canHaveStub(vFile));
                    LOG.error(builder.toString());
                }
                StubElement currentStubTree = ((IStubFileElementType)contentElementType).getBuilder().buildStubTree(this);
                tree = new StubTree((PsiFileStub)currentStubTree);
                this.bindFakeStubsToTree(tree);
                fileElement.putUserData(STUB_TREE_IN_PARSED_TREE, tree);
            }
            return tree;
        }
    }

    private void bindFakeStubsToTree(StubTree stubTree) {
        PsiFileImpl file = this;
        Iterator<StubElement<?>> stubs = stubTree.getPlainList().iterator();
        stubs.next();
        FileElement fileRoot = file.getTreeElement();
        assert (fileRoot != null);
        this.bindStubs(fileRoot, stubs, ((IStubFileElementType)this.getContentElementType()).getBuilder());
    }

    private void bindStubs(ASTNode tree, final Iterator<StubElement<?>> stubs, final StubBuilder builder) {
        ((TreeElement)tree).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            protected void visitNode(TreeElement root) {
                CompositeElement parent = root.getTreeParent();
                IElementType parentType = parent == null ? null : parent.getElementType();
                IElementType type = root.getElementType();
                if (parentType != null && builder.skipChildProcessingWhenBuildingStubs(parent, type)) {
                    return;
                }
                if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(root)) {
                    StubElement stub;
                    StubElement stubElement = stub = stubs.hasNext() ? (StubElement)stubs.next() : null;
                    if (stub == null || stub.getStubType() != type) {
                        PsiFileImpl.this.rebuildStub();
                        assert (false) : "Stub and PSI element type mismatch in " + PsiFileImpl.this.getName() + ": stub:" + stub + ", AST:" + type;
                    }
                    ((StubBase)stub).setPsi(root.getPsi());
                }
                super.visitNode(root);
            }
        });
    }

    private void rebuildStub() {
        final VirtualFile vFile = this.getVirtualFile();
        if (vFile != null && vFile.isValid()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
                    if (doc != null) {
                        FileDocumentManager.getInstance().saveDocument(doc);
                    }
                }
            }, ModalityState.NON_MODAL);
            StubTreeLoader.getInstance().rebuildStubTree(vFile);
        }
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFileImpl.putInfo must not be null");
        }
        PsiFileImpl.putInfo(this, info);
    }

    public static void putInfo(PsiFile psiFile, Map<String, String> info) {
        info.put("fileName", psiFile.getName());
        info.put("fileType", psiFile.getFileType().toString());
    }

    @Override
    public String toString() {
        return this.myElementType.toString();
    }
}

