/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.PatchedSoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAnnotationMethodImpl
extends PsiMethodImpl
implements PsiAnnotationMethod {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiAnnotationMethodImpl");
    private PatchedSoftReference<PsiAnnotationMemberValue> myCachedDefaultValue = null;

    public PsiAnnotationMethodImpl(PsiMethodStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANNOTATION_METHOD);
    }

    public PsiAnnotationMethodImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiAnnotationMethodImpl.hasModifierProperty must not be null");
        }
        return "abstract".equals(name) || "public".equals(name) || super.hasModifierProperty(name);
    }

    @Override
    protected void dropCached() {
        this.myCachedDefaultValue = null;
    }

    @Override
    public PsiAnnotationMemberValue getDefaultValue() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            PsiAnnotationMemberValue value;
            String text = stub.getDefaultValueText();
            if (StringUtil.isEmpty(text)) {
                return null;
            }
            if (this.myCachedDefaultValue != null && (value = (PsiAnnotationMemberValue)this.myCachedDefaultValue.get()) != null) {
                return value;
            }
            String annoText = "@interface _Dummy_ { Class foo() default " + text + "; }";
            PsiJavaFile file = (PsiJavaFile)PsiFileFactory.getInstance(this.getProject()).createFileFromText("a.java", annoText);
            PsiAnnotationMemberValue value2 = ((PsiAnnotationMethod)file.getClasses()[0].getMethods()[0]).getDefaultValue();
            this.myCachedDefaultValue = new PatchedSoftReference<PsiAnnotationMemberValue>(value2);
            return value2;
        }
        this.myCachedDefaultValue = null;
        ASTNode node = this.getNode().findChildByRole(248);
        if (node == null) {
            return null;
        }
        return (PsiAnnotationMemberValue)node.getPsi();
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiAnnotationMethod:" + this.getName();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiAnnotationMethodImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationMethod(this);
        } else {
            visitor.visitElement(this);
        }
    }
}

