/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.impl.ASTNodeBuilder;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.SourceUtil;
import com.intellij.psi.stubs.LightStubBuilder;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;

public class JavaLightStubBuilder
extends LightStubBuilder {
    static int totalMethods;
    static int nonexpandedMethods;

    @Override
    protected StubElement createStubForFile(PsiFile file, LighterAST tree) {
        LighterASTNode ref;
        if (!(file instanceof PsiJavaFile)) {
            return super.createStubForFile(file, tree);
        }
        String refText = "";
        LighterASTNode pkg = LightTreeUtil.firstChildOfType(tree, tree.getRoot(), JavaElementType.PACKAGE_STATEMENT);
        if (pkg != null && (ref = LightTreeUtil.firstChildOfType(tree, pkg, JavaElementType.JAVA_CODE_REFERENCE)) != null) {
            refText = SourceUtil.getTextSkipWhiteSpaceAndComments(tree, ref);
        }
        return new PsiJavaFileStubImpl((PsiJavaFile)file, StringRef.fromString(refText), false);
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(IElementType nodeType, IElementType childType) {
        return childType == JavaElementType.PARAMETER && nodeType != JavaElementType.PARAMETER_LIST;
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(LightStubBuilder builder, LighterAST tree, LighterASTNode parent, LighterASTNode child) {
        if (child.getTokenType() == JavaElementType.CODE_BLOCK && child instanceof ASTNodeBuilder.ASTUnparsedNodeMarker) {
            ++totalMethods;
            ASTNodeBuilder.ASTUnparsedNodeMarker nodeMarker = (ASTNodeBuilder.ASTUnparsedNodeMarker)((Object)child);
            ASTNodeBuilder nodeBuilder = nodeMarker.getBuilder();
            int endLexemIndex = nodeMarker.getEndLexemIndex();
            boolean seenNew = false;
            for (int i = nodeMarker.getStartLexemIndex(); i < endLexemIndex; ++i) {
                IElementType type = nodeBuilder.getElementType(i);
                if (type == JavaTokenType.NEW_KEYWORD) {
                    seenNew = true;
                    continue;
                }
                if (seenNew && type == JavaTokenType.LBRACE) {
                    return false;
                }
                if (seenNew && type == JavaTokenType.SEMICOLON) {
                    seenNew = false;
                    continue;
                }
                if (type != JavaTokenType.AT && type != JavaTokenType.CLASS_KEYWORD && type != JavaTokenType.INTERFACE_KEYWORD && type != JavaTokenType.ENUM_KEYWORD) continue;
                return false;
            }
            ++nonexpandedMethods;
            return true;
        }
        return false;
    }
}

