/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.parser.FileParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.JavaLightStubBuilder;
import com.intellij.psi.impl.source.tree.java.JavaFileElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.LightStubBuilder;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.io.StringRef;
import java.io.IOException;

public class JavaFileElementType
extends ILightStubFileElementType<PsiJavaFileStub> {
    public static final int STUB_VERSION = 9;

    public JavaFileElementType() {
        super("java.FILE", JavaLanguage.INSTANCE);
    }

    @Override
    public LightStubBuilder getBuilder() {
        return new JavaLightStubBuilder();
    }

    @Override
    public int getStubVersion() {
        return 9;
    }

    @Override
    public boolean shouldBuildStubFor(VirtualFile file) {
        VirtualFile dir = file.getParent();
        return dir == null || dir.getUserData(LanguageLevel.KEY) != null;
    }

    @Override
    public ASTNode createNode(CharSequence text) {
        return new JavaFileElement(text);
    }

    @Override
    public FlyweightCapableTreeStructure<LighterASTNode> parseContentsLight(ASTNode chameleon) {
        PsiBuilder builder = JavaParserUtil.createBuilder(chameleon);
        this.doParse(builder);
        return builder.getLightTree();
    }

    @Override
    public ASTNode parseContents(ASTNode chameleon) {
        PsiBuilder builder = JavaParserUtil.createBuilder(chameleon);
        this.doParse(builder);
        return builder.getTreeBuilt().getFirstChildNode();
    }

    private void doParse(PsiBuilder builder) {
        PsiBuilder.Marker root = builder.mark();
        FileParser.INSTANCE.parse(builder);
        root.done(this);
    }

    @Override
    public String getExternalId() {
        return "java.FILE";
    }

    @Override
    public void serialize(PsiJavaFileStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeBoolean(stub.isCompiled());
        dataStream.writeName(stub.getPackageName());
    }

    @Override
    public PsiJavaFileStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        boolean compiled = dataStream.readBoolean();
        StringRef packName = dataStream.readName();
        return new PsiJavaFileStubImpl(null, packName, compiled);
    }

    @Override
    public void indexStub(PsiJavaFileStub stub, IndexSink sink) {
    }
}

