/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsTypeParameterImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ClsTypeParameterReferenceImpl
extends ClsElementImpl
implements PsiJavaCodeReferenceElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsTypeParameterReferenceImpl");
    private final PsiElement myParent;
    private final String myName;

    public ClsTypeParameterReferenceImpl(PsiElement parent, String name) {
        this.myParent = parent;
        this.myName = name;
    }

    @Override
    public void processVariants(PsiScopeProcessor processor) {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.myName;
    }

    @Override
    public String getReferenceName() {
        return this.myName;
    }

    @Override
    public PsiElement resolve() {
        LOG.assertTrue(this.myParent.isValid());
        PsiElement parent = this.myParent;
        while (!(parent instanceof PsiFile)) {
            PsiTypeParameterList parameterList = null;
            if (parent instanceof PsiClass) {
                parameterList = ((PsiClass)parent).getTypeParameterList();
            } else if (parent instanceof PsiMethod) {
                parameterList = ((PsiMethod)parent).getTypeParameterList();
            }
            if (parameterList != null) {
                PsiTypeParameter[] parameters;
                for (PsiTypeParameter parameter : parameters = parameterList.getTypeParameters()) {
                    if (!this.myName.equals(parameter.getName())) continue;
                    return parameter;
                }
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        CandidateInfo candidateInfo = new CandidateInfo(this.resolve(), PsiSubstitutor.EMPTY);
        if (candidateInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsTypeParameterReferenceImpl.advancedResolve must not return null");
        }
        return candidateInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            javaResolveResultArray = new JavaResolveResult[]{result};
            if (javaResolveResultArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsTypeParameterReferenceImpl.multiResolve must not return null");
            return javaResolveResultArray;
        }
        javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
        if (JavaResolveResult.EMPTY_ARRAY != null) return javaResolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsTypeParameterReferenceImpl.multiResolve must not return null");
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsTypeParameterReferenceImpl.getTypeParameters must not return null");
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsTypeParameterReferenceImpl.getCanonicalText must not return null");
        }
        return string;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof ClsTypeParameterImpl)) {
            return false;
        }
        return element == this.resolve();
    }

    @Override
    public String getText() {
        return this.myName;
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsTypeParameterReferenceImpl.getChildren must not return null");
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsTypeParameterReferenceImpl.bindToElement must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for references to compiled code");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        buffer.append(this.getCanonicalText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsTypeParameterReferenceImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, ElementType.JAVA_CODE_REFERENCE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsTypeParameterReferenceImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    @Override
    public TextRange getRangeInElement() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getTextRange() : new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }
}

