/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.ide.caches.FileContent;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.ClsFileDecompiledPsiFileProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsPackageStatementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsFileImpl
extends ClsRepositoryPsiElement<PsiClassHolderFileStub>
implements PsiJavaFile,
PsiFileWithStubSupport,
PsiFileEx,
Queryable,
PsiClassOwnerEx,
PsiCompiledFile {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsFileImpl");
    private static final MirrorLock MIRROR_LOCK = new MirrorLock();
    private static final Key<Document> DOCUMENT_IN_MIRROR_KEY = Key.create("DOCUMENT_IN_MIRROR_KEY");
    private final PsiManagerImpl myManager;
    private final boolean myIsForDecompiling;
    private final FileViewProvider myViewProvider;
    private volatile SoftReference<StubTree> myStub;
    private TreeElement myMirrorFileElement;
    private volatile ClsPackageStatementImpl myPackageStatement;
    private boolean myIsPhysical;
    private final Object lock;

    private ClsFileImpl(@NotNull PsiManagerImpl manager, @NotNull FileViewProvider viewProvider, boolean forDecompiling) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFileImpl.<init> must not be null");
        }
        if (viewProvider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFileImpl.<init> must not be null");
        }
        super(null);
        this.myPackageStatement = null;
        this.myIsPhysical = true;
        this.lock = new Object();
        this.myManager = manager;
        JavaElementType.CLASS.getIndex();
        this.myIsForDecompiling = forDecompiling;
        this.myViewProvider = viewProvider;
    }

    public ClsFileImpl(PsiManagerImpl manager, FileViewProvider viewProvider) {
        this(manager, viewProvider, false);
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getVirtualFile must not return null");
        }
        return virtualFile;
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Override
    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException(this);
        }
        return this;
    }

    @Override
    public boolean isValid() {
        if (this.myIsForDecompiling) {
            return true;
        }
        VirtualFile vFile = this.getVirtualFile();
        return vFile.isValid();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getVirtualFile().getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getClasses();
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClassHolderFileStub fileStub = this.getStub();
        PsiClass[] psiClassArray = fileStub != null ? fileStub.getClasses() : PsiClass.EMPTY_ARRAY;
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getClasses must not return null");
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        this.getStub();
        ClsPackageStatementImpl statement = this.myPackageStatement;
        if (statement == null) {
            statement = new ClsPackageStatementImpl(this);
        }
        return statement.getPackageName() != null ? statement : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiPackageStatement statement = this.getPackageStatement();
        String string = statement == null ? "" : statement.getPackageName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getPackageName must not return null");
        }
        return string;
    }

    @Override
    public void setPackageName(String packageName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot set package name for compiled files");
    }

    @Override
    public PsiImportList getImportList() {
        return null;
    }

    @Override
    public boolean importClass(PsiClass aClass) {
        throw new UnsupportedOperationException("Cannot add imports to compiled classes");
    }

    @Override
    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getOnDemandImports must not return null");
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getSingleClassImports must not return null");
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getImplicitlyImportedPackages must not return null");
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> getClassNames() {
        return Collections.singleton(this.getVirtualFile().getNameWithoutExtension());
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getImplicitlyImportedPackageReferences must not return null");
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        return null;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        List<StubElement> stubs = this.getStub().getChildrenStubs();
        LanguageLevel languageLevel = stubs.size() > 0 ? ((PsiClassStub)stubs.get(0)).getLanguageLevel() : LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getLanguageLevel must not return null");
        }
        return languageLevel;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFileImpl.setName must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        PsiClass[] classes;
        buffer.append(PsiBundle.message("psi.decompiled.text.header", new Object[0]));
        ClsFileImpl.goNextLine(indentLevel, buffer);
        ClsFileImpl.goNextLine(indentLevel, buffer);
        PsiPackageStatement packageStatement = this.getPackageStatement();
        if (packageStatement != null) {
            ((ClsElementImpl)((Object)packageStatement)).appendMirrorText(0, buffer);
            ClsFileImpl.goNextLine(indentLevel, buffer);
            ClsFileImpl.goNextLine(indentLevel, buffer);
        }
        if ((classes = this.getClasses()).length > 0) {
            PsiClass aClass = classes[0];
            ((ClsElementImpl)((Object)aClass)).appendMirrorText(0, buffer);
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFileImpl.setMirror must not be null");
        }
        PsiElement mirrorFile = SourceTreeToPsiMap.treeElementToPsi(element);
        if (mirrorFile instanceof PsiJavaFile) {
            Object[] classes;
            PsiPackageStatement packageStatementMirror = ((PsiJavaFile)mirrorFile).getPackageStatement();
            PsiPackageStatement packageStatement = this.getPackageStatement();
            if (packageStatementMirror != null && packageStatement != null) {
                ((ClsElementImpl)((Object)packageStatement)).setMirror((TreeElement)packageStatementMirror.getNode());
            }
            if ((classes = this.getClasses()).length != 1 || JavaPsiFacade.getInstance(this.getProject()).getNameHelper().isIdentifier(classes[0].getName())) {
                Object[] mirrorClasses = ((PsiJavaFile)mirrorFile).getClasses();
                if (classes.length != mirrorClasses.length) {
                    LOG.error("file: " + mirrorFile + " classes: " + Arrays.toString(classes) + " mirrors: " + Arrays.toString(mirrorClasses));
                } else {
                    for (int i = 0; i < classes.length; ++i) {
                        PsiClass mirrorClass = mirrorClasses[i];
                        assert (mirrorClass != null) : this + "; mirror classes: " + Arrays.asList(mirrorClasses);
                        Object aClass = classes[i];
                        assert (aClass != null) : this + "; classes: " + Arrays.asList(classes);
                        ((ClsElementImpl)aClass).setMirror((TreeElement)mirrorClass.getNode());
                    }
                }
            }
        }
        this.myMirrorFileElement = element;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = JavaPsiImplementationHelper.getInstance(this.getProject()).getClsFileNavigationElement(this);
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getNavigationElement must not return null");
        }
        return psiElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiElement getMirror() {
        MirrorLock mirrorLock = MIRROR_LOCK;
        synchronized (mirrorLock) {
            if (this.myMirrorFileElement == null) {
                VirtualFile virtualFile = this.getVirtualFile();
                String mirrorText = ClsFileImpl.decompile(this.getManager(), virtualFile);
                String ext = JavaFileType.INSTANCE.getDefaultExtension();
                PsiClass[] classes = this.getClasses();
                String fileName = (classes.length > 0 ? classes[0].getName() : virtualFile.getNameWithoutExtension()) + "." + ext;
                PsiManager manager = this.getManager();
                PsiFile mirror = PsiFileFactory.getInstance(manager.getProject()).createFileFromText(fileName, JavaLanguage.INSTANCE, (CharSequence)mirrorText, false, false);
                ASTNode mirrorTreeElement = SourceTreeToPsiMap.psiElementToTree(mirror);
                NonCancelableSection section = ProgressIndicatorProvider.getInstance().startNonCancelableSection();
                try {
                    this.setMirror((TreeElement)mirrorTreeElement);
                    Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                    this.myMirrorFileElement.putUserData(DOCUMENT_IN_MIRROR_KEY, document);
                }
                finally {
                    section.done();
                }
            }
            return this.myMirrorFileElement.getPsi();
        }
    }

    @Override
    public PsiFile getDecompiledPsiFile() {
        for (ClsFileDecompiledPsiFileProvider provider : Extensions.getExtensions(ClsFileDecompiledPsiFileProvider.EP_NAME)) {
            PsiFile decompiledPsiFile = provider.getDecompiledPsiFile(this);
            if (decompiledPsiFile == null) continue;
            return decompiledPsiFile;
        }
        return (PsiFile)this.getMirror();
    }

    @Override
    public long getModificationStamp() {
        return this.getVirtualFile().getModificationStamp();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFileImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile(this);
        } else {
            visitor.visitFile(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiFile:" + this.getName();
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        ClsFileImpl clsFileImpl = this;
        if (clsFileImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getOriginalFile must not return null");
        }
        return clsFileImpl;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        if (javaClassFileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getFileType must not return null");
        }
        return javaClassFileType;
    }

    @Override
    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getPsiRoots must not return null");
        }
        return psiFileArray;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getViewProvider must not return null");
        }
        return fileViewProvider;
    }

    @Override
    public void subtreeChanged() {
    }

    public static String decompile(PsiManager manager, VirtualFile file) {
        PsiFile psi;
        FileViewProvider provider = ((PsiManagerEx)manager).getFileManager().findViewProvider(file);
        ClsFileImpl psiFile = null;
        if (provider != null && (psi = provider.getPsi(provider.getBaseLanguage())) instanceof PsiCompiledFile) {
            psiFile = (ClsFileImpl)psi;
        }
        if (psiFile == null) {
            psiFile = new ClsFileImpl((PsiManagerImpl)manager, new ClassFileViewProvider(manager, file), true);
        }
        StringBuilder buffer = new StringBuilder();
        psiFile.appendMirrorText(0, buffer);
        return buffer.toString();
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    @NotNull
    public PsiClassHolderFileStub getStub() {
        PsiClassHolderFileStub psiClassHolderFileStub = (PsiClassHolderFileStub)this.getStubTree().getRoot();
        if (psiClassHolderFileStub == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getStub must not return null");
        }
        return psiClassHolderFileStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public StubTree getStubTree() {
        StubTree stubTree;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        StubTree derefd = this.derefStub();
        if (derefd != null) {
            stubTree = derefd;
            if (stubTree == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getStubTree must not return null");
            return stubTree;
        }
        StubTree stubHolder = StubTreeLoader.getInstance().readOrBuild(this.getProject(), this.getVirtualFile());
        if (stubHolder == null) {
            LOG.info("Class file is corrupted: " + this.getVirtualFile().getPresentableUrl());
            StubTree emptyTree = new StubTree(new PsiJavaFileStubImpl("corrupted.classfiles", true));
            this.setStubTree(emptyTree);
            this.resetMirror();
            stubTree = emptyTree;
            if (stubTree == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getStubTree must not return null");
            return stubTree;
        }
        Object object = this.lock;
        synchronized (object) {
            StubTree derefdOnLock = this.derefStub();
            if (derefdOnLock != null) {
                StubTree stubTree2 = derefdOnLock;
                // MONITOREXIT @DISABLED, blocks:[2, 9] lbl21 : MonitorExitStatement: MONITOREXIT : var3_4
                stubTree = stubTree2;
                if (stubTree2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getStubTree must not return null");
                return stubTree;
            }
            this.setStubTree(stubHolder);
        }
        this.resetMirror();
        stubTree = stubHolder;
        if (stubTree != null) return stubTree;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFileImpl.getStubTree must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStubTree(StubTree tree) {
        Object object = this.lock;
        synchronized (object) {
            this.myStub = new SoftReference<StubTree>(tree);
            ((PsiFileStubImpl)tree.getRoot()).setPsi(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetMirror() {
        ClsPackageStatementImpl clsPackageStatement = new ClsPackageStatementImpl(this);
        MirrorLock mirrorLock = MIRROR_LOCK;
        synchronized (mirrorLock) {
            this.myMirrorFileElement = null;
            this.myPackageStatement = clsPackageStatement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private StubTree derefStub() {
        Object object = this.lock;
        synchronized (object) {
            return this.myStub != null ? this.myStub.get() : null;
        }
    }

    @Override
    public ASTNode findTreeForStub(StubTree tree, StubElement<?> stub) {
        return null;
    }

    @Override
    public boolean isContentsLoaded() {
        return this.myStub != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onContentReload() {
        StubTree stubHolder;
        SoftReference<StubTree> stub = this.myStub;
        StubTree stubTree = stubHolder = stub == null ? null : stub.get();
        if (stubHolder != null) {
            ((StubBase)((Object)stubHolder.getRoot())).setPsi(null);
        }
        this.myStub = null;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        MirrorLock mirrorLock = MIRROR_LOCK;
        synchronized (mirrorLock) {
            this.myMirrorFileElement = null;
            this.myPackageStatement = null;
        }
    }

    @Override
    public PsiFile cacheCopy(FileContent content) {
        return this;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFileImpl.putInfo must not be null");
        }
        PsiFileImpl.putInfo(this, info);
    }

    @Override
    public FileASTNode getNode() {
        return null;
    }

    @Override
    public boolean isPhysical() {
        return this.myIsPhysical;
    }

    public void setPhysical(boolean isPhysical) {
        this.myIsPhysical = isPhysical;
    }

    private static class MirrorLock {
        private MirrorLock() {
        }
    }
}

