/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsNameValuePairImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

public class ClsAnnotationParameterListImpl
extends ClsElementImpl
implements PsiAnnotationParameterList {
    private static final Logger LOG = Logger.getInstance("com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl");
    private final ClsNameValuePairImpl[] myAttributes;
    private final PsiAnnotation myParent;

    public ClsAnnotationParameterListImpl(PsiAnnotation parent, PsiNameValuePair[] psiAttributes) {
        this.myParent = parent;
        this.myAttributes = new ClsNameValuePairImpl[psiAttributes.length];
        for (int i = 0; i < this.myAttributes.length; ++i) {
            String name = psiAttributes[i].getName();
            PsiAnnotationMemberValue value = psiAttributes[i].getValue();
            this.myAttributes[i] = new ClsNameValuePairImpl(this, name, value);
        }
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        if (this.myAttributes.length != 0) {
            buffer.append("(");
            for (int i = 0; i < this.myAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                this.myAttributes[i].appendMirrorText(indentLevel, buffer);
            }
            buffer.append(")");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiAnnotationParameterList mirror = (PsiAnnotationParameterList)SourceTreeToPsiMap.treeElementToPsi(element);
        PsiNameValuePair[] attrs = mirror.getAttributes();
        LOG.assertTrue(this.myAttributes.length == attrs.length);
        for (int i = 0; i < this.myAttributes.length; ++i) {
            this.myAttributes[i].setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(attrs[i]));
        }
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (this.myAttributes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl.getChildren must not return null");
        }
        return this.myAttributes;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiNameValuePair[] getAttributes() {
        if (this.myAttributes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl.getAttributes must not return null");
        }
        return this.myAttributes;
    }
}

