/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementFinder {
    public static final ExtensionPointName<PsiElementFinder> EP_NAME = ExtensionPointName.create("com.intellij.java.elementFinder");

    @Nullable
    public abstract PsiClass findClass(@NotNull String var1, @NotNull GlobalSearchScope var2);

    @NotNull
    public abstract PsiClass[] findClasses(@NotNull String var1, @NotNull GlobalSearchScope var2);

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementFinder.findPackage must not be null");
        }
        return null;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getSubPackages must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getSubPackages must not be null");
        }
        if (PsiPackage.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementFinder.getSubPackages must not return null");
        }
        return PsiPackage.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getClasses must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getClasses must not be null");
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementFinder.getClasses must not return null");
        }
        return PsiClass.EMPTY_ARRAY;
    }

    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getClassNames must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getClassNames must not be null");
        }
        return PsiElementFinder.getClassNames(this.getClasses(psiPackage, scope));
    }

    protected static Set<String> getClassNames(PsiClass[] classes) {
        if (classes.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        for (PsiClass aClass : classes) {
            ContainerUtil.addIfNotNull(aClass.getName(), names);
        }
        return names;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, Processor<PsiDirectory> consumer) {
        if (psiPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementFinder.processPackageDirectories must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiElementFinder.processPackageDirectories must not be null");
        }
        return true;
    }
}

