/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PsiDiamondType
extends PsiType {
    public PsiDiamondType(PsiAnnotation[] annotations) {
        super(annotations);
    }

    public abstract DiamondInferenceResult resolveInferredTypes();

    public static class DiamondInferenceResult {
        public static final DiamondInferenceResult EXPLICIT_CONSTRUCTOR_TYPE_ARGS = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDiamondType$DiamondInferenceResult$1.getTypes must not return null");
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot use diamonds with explicit type parameters for constructor";
            }
        };
        public static final DiamondInferenceResult NULL_RESULT = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDiamondType$DiamondInferenceResult$2.getTypes must not return null");
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot infer arguments";
            }
        };
        public static final DiamondInferenceResult ANONYMOUS_INNER_RESULT = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDiamondType$DiamondInferenceResult$3.getTypes must not return null");
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot use ''<>'' with anonymous inner classes";
            }
        };
        private final List<PsiType> myInferredTypes = new ArrayList<PsiType>();
        private String myErrorMessage;
        private String myNewExpressionPresentableText;
        private Project myProject;

        public DiamondInferenceResult() {
        }

        public DiamondInferenceResult(String expressionPresentableText, Project project) {
            this.myNewExpressionPresentableText = expressionPresentableText;
            this.myProject = project;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public PsiType[] getTypes() {
            PsiType[] psiTypeArray;
            if (this.myErrorMessage != null) {
                psiTypeArray = PsiType.EMPTY_ARRAY;
                if (PsiType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDiamondType$DiamondInferenceResult.getTypes must not return null");
                return psiTypeArray;
            }
            psiTypeArray = this.myInferredTypes.toArray(new PsiType[this.myInferredTypes.size()]);
            if (psiTypeArray != null) return psiTypeArray;
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDiamondType$DiamondInferenceResult.getTypes must not return null");
        }

        public List<PsiType> getInferredTypes() {
            return this.myInferredTypes;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public boolean failedToInfer() {
            return this.myErrorMessage != null;
        }

        public void addInferredType(PsiType psiType) {
            if (this.myErrorMessage != null) {
                return;
            }
            if (psiType == null) {
                this.myErrorMessage = "Cannot infer type arguments for " + this.myNewExpressionPresentableText;
            } else {
                this.myInferredTypes.add(psiType);
            }
        }

        private static Boolean isValid(PsiType type) {
            return type.accept(new PsiTypeVisitor<Boolean>(){

                @Override
                public Boolean visitType(PsiType type) {
                    return !(type instanceof PsiIntersectionType);
                }

                @Override
                public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                    return false;
                }

                @Override
                public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                    PsiType bound = wildcardType.getBound();
                    if (bound != null) {
                        if (bound instanceof PsiIntersectionType) {
                            return false;
                        }
                        return bound.accept(this);
                    }
                    return true;
                }

                @Override
                public Boolean visitClassType(PsiClassType classType) {
                    for (PsiType psiType : classType.getParameters()) {
                        if (psiType.accept(this).booleanValue()) continue;
                        return false;
                    }
                    return true;
                }
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiamondInferenceResult that = (DiamondInferenceResult)o;
            if (this.myErrorMessage != null ? !this.myErrorMessage.equals(that.myErrorMessage) : that.myErrorMessage != null) {
                return false;
            }
            return ((Object)this.myInferredTypes).equals(that.myInferredTypes);
        }

        public int hashCode() {
            int result = ((Object)this.myInferredTypes).hashCode();
            result = 31 * result + (this.myErrorMessage != null ? this.myErrorMessage.hashCode() : 0);
            return result;
        }
    }
}

