/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiClassType
extends PsiType {
    public static final PsiClassType[] EMPTY_ARRAY = new PsiClassType[0];
    public static final ArrayFactory<PsiClassType> ARRAY_FACTORY = new ArrayFactory<PsiClassType>(){

        public PsiClassType[] create(int count) {
            return new PsiClassType[count];
        }
    };
    protected final LanguageLevel myLanguageLevel;

    protected PsiClassType(LanguageLevel languageLevel) {
        this(languageLevel, PsiAnnotation.EMPTY_ARRAY);
    }

    protected PsiClassType(LanguageLevel languageLevel, PsiAnnotation[] annotations) {
        super(annotations);
        this.myLanguageLevel = languageLevel;
    }

    @Nullable
    public abstract PsiClass resolve();

    public abstract String getClassName();

    @NotNull
    public abstract PsiType[] getParameters();

    public int getParameterCount() {
        return this.getParameters().length;
    }

    public boolean equals(Object obj) {
        ClassResolveResult otherResult;
        String otherClassName;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PsiClassType)) {
            return false;
        }
        PsiClassType otherClassType = (PsiClassType)obj;
        String className = this.getClassName();
        if (!Comparing.equal(className, otherClassName = otherClassType.getClassName())) {
            return false;
        }
        if (this.getParameterCount() != otherClassType.getParameterCount()) {
            return false;
        }
        ClassResolveResult result = this.resolveGenerics();
        if (result == (otherResult = otherClassType.resolveGenerics())) {
            return true;
        }
        PsiClass aClass = result.getElement();
        PsiClass otherClass = otherResult.getElement();
        if (aClass == null || otherClass == null) {
            return aClass == otherClass;
        }
        return aClass.getManager().areElementsEquivalent(aClass, otherClass) && (PsiUtil.isRawSubstitutor(aClass, result.getSubstitutor()) || PsiUtil.equalOnEquivalentClasses(result.getSubstitutor(), aClass, otherResult.getSubstitutor(), otherClass));
    }

    public boolean hasParameters() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            return false;
        }
        boolean hasParams = false;
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
            if (resolveResult.getSubstitutor().substitute(parameter) == null) {
                return false;
            }
            hasParams = true;
        }
        return hasParams;
    }

    public boolean hasNonTrivialParameters() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            return false;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
            PsiClass superClass;
            PsiType type = resolveResult.getSubstitutor().substitute(parameter);
            if (type == null) continue;
            if (!(type instanceof PsiWildcardType)) {
                return true;
            }
            PsiType bound = ((PsiWildcardType)type).getBound();
            if (bound == null || ((PsiWildcardType)type).isExtends() && (superClass = parameter.getSuperClass()) != null && PsiUtil.resolveClassInType(bound) == superClass) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        String className = this.getClassName();
        if (className == null) {
            return 0;
        }
        return className.hashCode();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray;
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            psiTypeArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiClassType.getSuperTypes must not return null");
            return psiTypeArray;
        }
        PsiClassType[] superTypes = aClass.getSuperTypes();
        PsiType[] subtitutionResults = new PsiType[superTypes.length];
        for (int i = 0; i < superTypes.length; ++i) {
            subtitutionResults[i] = resolveResult.getSubstitutor().substitute(superTypes[i]);
        }
        psiTypeArray = subtitutionResults;
        if (subtitutionResults != null) return psiTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/PsiClassType.getSuperTypes must not return null");
    }

    public static boolean isRaw(ClassResolveResult resolveResult) {
        PsiClass psiClass = resolveResult.getElement();
        return psiClass != null && PsiUtil.isRawSubstitutor(psiClass, resolveResult.getSubstitutor());
    }

    public boolean isRaw() {
        return PsiClassType.isRaw(this.resolveGenerics());
    }

    @NotNull
    public abstract ClassResolveResult resolveGenerics();

    @NotNull
    public abstract PsiClassType rawType();

    @Override
    @NotNull
    public abstract GlobalSearchScope getResolveScope();

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitClassType(this);
    }

    @NotNull
    public abstract LanguageLevel getLanguageLevel();

    public abstract PsiClassType setLanguageLevel(LanguageLevel var1);

    public static interface ClassResolveResult
    extends JavaResolveResult {
        public static final ClassResolveResult EMPTY = new ClassResolveResult(){

            @Override
            public PsiClass getElement() {
                return null;
            }

            @Override
            public PsiSubstitutor getSubstitutor() {
                return PsiSubstitutor.EMPTY;
            }

            @Override
            public boolean isValidResult() {
                return false;
            }

            @Override
            public boolean isAccessible() {
                return false;
            }

            @Override
            public boolean isStaticsScopeCorrect() {
                return false;
            }

            @Override
            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            @Override
            public boolean isPackagePrefixPackageReference() {
                return false;
            }
        };

        @Override
        public PsiClass getElement();
    }
}

