/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class PsiArrayType
extends PsiType {
    private final PsiType myComponentType;

    public PsiArrayType(@NotNull PsiType componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiArrayType.<init> must not be null");
        }
        this(componentType, PsiAnnotation.EMPTY_ARRAY);
    }

    public PsiArrayType(@NotNull PsiType componentType, PsiAnnotation[] annotations) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiArrayType.<init> must not be null");
        }
        super(annotations);
        this.myComponentType = componentType;
    }

    @Override
    public String getPresentableText() {
        return StringUtil.joinOrNull(this.myComponentType.getPresentableText(), "[]");
    }

    @Override
    public String getCanonicalText() {
        return StringUtil.joinOrNull(this.myComponentType.getCanonicalText(), "[]");
    }

    @Override
    public String getInternalCanonicalText() {
        return StringUtil.joinOrNull(this.myComponentType.getInternalCanonicalText(), "[]");
    }

    @Override
    public boolean isValid() {
        return this.myComponentType.isValid();
    }

    @Override
    public boolean equalsToText(String text) {
        return text.endsWith("[]") && this.myComponentType.equalsToText(text.substring(0, text.length() - 2));
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitArrayType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myComponentType.getResolveScope();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] superTypes = this.myComponentType.getSuperTypes();
        PsiType[] result = new PsiType[superTypes.length];
        for (int i = 0; i < superTypes.length; ++i) {
            result[i] = superTypes[i].createArrayType();
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiArrayType.getSuperTypes must not return null");
        }
        return result;
    }

    @NotNull
    public PsiType getComponentType() {
        PsiType psiType = this.myComponentType;
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiArrayType.getComponentType must not return null");
        }
        return psiType;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass()) && this.myComponentType.equals(((PsiArrayType)obj).getComponentType());
    }

    public int hashCode() {
        return this.myComponentType.hashCode() * 3;
    }
}

