/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NonNls;

public class PersistentFSConstants {
    public static final long FILE_LENGTH_TO_CACHE_THRESHOLD = 0x1400000L;
    private static int ourMaxIntellisenseFilesize = PersistentFSConstants.computeMaxIntellisenseFileSize();
    @NonNls
    private static final String MAX_INTELLISENSE_SIZE_PROPERTY = "idea.max.intellisense.filesize";

    public static int getMaxIntellisenseFileSize() {
        return ourMaxIntellisenseFilesize;
    }

    public static void setMaxIntellisenseFileSize(int sizeInBytes) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException("cannot change max setMaxIntellisenseFileSize while running");
        }
        ourMaxIntellisenseFilesize = sizeInBytes;
    }

    private PersistentFSConstants() {
    }

    private static int computeMaxIntellisenseFileSize() {
        int maxLimitBytes = 0x1400000;
        String userLimitKb = System.getProperty(MAX_INTELLISENSE_SIZE_PROPERTY);
        try {
            return userLimitKb != null ? Math.min(Integer.parseInt(userLimitKb) * 1024, 0x1400000) : 0x1400000;
        }
        catch (NumberFormatException ignored) {
            return 0x1400000;
        }
    }
}

