/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VFileCreateEvent
extends VFileEvent {
    private final VirtualFile myParent;
    private final boolean myDirectory;
    private final String myChildName;
    private final boolean myReCreation;

    public VFileCreateEvent(Object requestor, @NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory, boolean isFromRefresh) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent.<init> must not be null");
        }
        if (childName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent.<init> must not be null");
        }
        this(requestor, parent, childName, isDirectory, isFromRefresh, false);
    }

    public VFileCreateEvent(Object requestor, @NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory, boolean isFromRefresh, boolean isReCreation) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent.<init> must not be null");
        }
        if (childName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent.<init> must not be null");
        }
        super(requestor, isFromRefresh);
        this.myChildName = childName;
        this.myParent = parent;
        this.myDirectory = isDirectory;
        this.myReCreation = isReCreation;
    }

    public String getChildName() {
        return this.myChildName;
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[" + (this.myReCreation ? "re" : "") + "create " + (this.myDirectory ? "dir " : "file ") + this.myChildName + " in " + this.myParent.getUrl() + "]";
    }

    @Override
    public String getPath() {
        return this.myParent.getPath() + "/" + this.myChildName;
    }

    @Override
    public VirtualFile getFile() {
        return this.myParent.findChild(this.myChildName);
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myParent.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent.getFileSystem must not return null");
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        if (this.myParent.isValid()) {
            VirtualFile child = this.myParent.findChild(this.myChildName);
            return !this.myReCreation && child == null || this.myReCreation && child != null;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCreateEvent event = (VFileCreateEvent)o;
        if (this.myDirectory != event.myDirectory) {
            return false;
        }
        if (!this.myChildName.equals(event.myChildName)) {
            return false;
        }
        if (!this.myParent.equals(event.myParent)) {
            return false;
        }
        return this.myReCreation == event.myReCreation;
    }

    @Override
    public int hashCode() {
        int result = this.myParent.hashCode();
        result = 31 * result + (this.myDirectory ? 1 : 0);
        result = 31 * result + this.myChildName.hashCode();
        result = 31 * result + (this.myReCreation ? 1 : 0);
        return result;
    }
}

