/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import com.intellij.openapi.vfs.impl.jar.JarHandlerBase;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class CoreJarHandler
extends JarHandlerBase {
    private final CoreJarFileSystem myFileSystem;
    private final VirtualFile myRoot;

    public CoreJarHandler(CoreJarFileSystem fileSystem, String path) {
        super(path);
        this.myFileSystem = fileSystem;
        HashMap<JarHandlerBase.EntryInfo, CoreJarVirtualFile> entries = new HashMap<JarHandlerBase.EntryInfo, CoreJarVirtualFile>();
        for (JarHandlerBase.EntryInfo info : this.getEntriesMap().values()) {
            this.getOrCreateFile(info, entries);
        }
        this.myRoot = this.getOrCreateFile(this.getEntryInfo(""), entries);
    }

    private CoreJarVirtualFile getOrCreateFile(JarHandlerBase.EntryInfo info, Map<JarHandlerBase.EntryInfo, CoreJarVirtualFile> entries) {
        CoreJarVirtualFile answer = entries.get(info);
        if (answer == null) {
            JarHandlerBase.EntryInfo parentEntry = info.parent;
            answer = new CoreJarVirtualFile(this, info, parentEntry != null ? this.getOrCreateFile(parentEntry, entries) : null);
            entries.put(info, answer);
        }
        return answer;
    }

    @Nullable
    public VirtualFile findFileByPath(String pathInJar) {
        return this.myRoot != null ? this.myRoot.findFileByRelativePath(pathInJar) : null;
    }

    public CoreJarFileSystem getFileSystem() {
        return this.myFileSystem;
    }
}

